/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InResourceServerPredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String serverId;

    public static InResourceServerPredicate create() {
        return new InResourceServerPredicate();
    }

    public InResourceServerPredicate resourceServer(String id) {
        this.serverId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof InResourceServer)) {
            return false;
        }
        return this.serverId.equals(((InResourceServer)((Object)value)).getResourceServerId());
    }

    public static class ExternalizerImpl
    implements Externalizer<InResourceServerPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InResourceServerPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.serverId, (ObjectOutput)output);
        }

        public InResourceServerPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InResourceServerPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InResourceServerPredicate res = new InResourceServerPredicate();
            res.serverId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

