/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeWithCPIndex;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;

public class BytecodeWithKlass
extends BytecodeWithCPIndex {
    BytecodeWithKlass(Method method, int bci) {
        super(method, bci);
    }

    protected Klass getKlass() {
        return this.method().getConstants().getKlassRefAt(this.index());
    }

    public Symbol getClassName() {
        ConstantPool.CPSlot obj = this.method().getConstants().getSlotAt(this.index());
        if (obj.isMetaData()) {
            return obj.getSymbol();
        }
        return ((Klass)obj.getOop()).getName();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.index()));
        buf.append(" ");
        buf.append("[Class ");
        buf.append(this.getClassName().asString().replace('/', '.'));
        buf.append(']');
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

