#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 rope-utf16-splay
version:              0.3.2.0
visibility:           public
id:                   rope-utf16-splay-0.3.2.0-5mP4j1fCbrTDcTAnOrxucw
key:                  rope-utf16-splay-0.3.2.0-5mP4j1fCbrTDcTAnOrxucw
license:              BSD-3-Clause
copyright:            (c) 2018 Olle Fredriksson
maintainer:           fredriksson.olle@gmail.com
author:               Olle Fredriksson
homepage:             https://github.com/ollef/rope-utf16-splay
synopsis:
    Ropes optimised for updating using UTF-16 code units and
    row/column pairs.

description:
    Ropes optimised for updating using UTF-16 code units and
    row/column pairs.  This implementation uses splay trees
    instead of the usual finger trees. According to my
    benchmarks, splay trees are faster in most situations.

category:             Data, Text, Language
abi:                  3164b9fd535b8f6f7f2eb4655ef45a29
exposed:              True
exposed-modules:
    Data.Rope.UTF16 Data.Rope.UTF16.Internal
    Data.Rope.UTF16.Internal.Position Data.Rope.UTF16.Internal.Text
    Data.SplayTree

import-dirs:          /usr/lib/ghc-8.10.5/site-local/rope-utf16-splay-0.3.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/rope-utf16-splay-0.3.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/rope-utf16-splay-0.3.2.0
hs-libraries:         HSrope-utf16-splay-0.3.2.0-5mP4j1fCbrTDcTAnOrxucw
depends:              base-4.14.2.0 text-1.2.4.1
haddock-interfaces:
    /usr/share/doc/haskell-rope-utf16-splay/html/rope-utf16-splay.haddock

haddock-html:         /usr/share/doc/haskell-rope-utf16-splay/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

