#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 non-negative
version:              0.1.2
visibility:           public
id:                   non-negative-0.1.2-IOvKlCYOcRKFV5QhNasqau
key:                  non-negative-0.1.2-IOvKlCYOcRKFV5QhNasqau
license:              LicenseRef-GPL
maintainer:           Henning Thielemann <haskell@henning-thielemann.de>
author:               Henning Thielemann <haskell@henning-thielemann.de>
homepage:             http://code.haskell.org/~thielema/non-negative/
synopsis:             Non-negative numbers
description:
    Provides a class for non-negative numbers,
    a wrapper which can turn any ordered numeric type into a member of that class,
    and a lazy number type for non-negative numbers
    (a generalization of Peano numbers).
    This library is used by the @event-list@ package.

category:             Math
abi:                  37ce1c515dc41523fe4f900f655b46c7
exposed:              True
exposed-modules:
    Numeric.NonNegative.Chunky Numeric.NonNegative.Class
    Numeric.NonNegative.Wrapper

hidden-modules:       Numeric.NonNegative.ChunkyPrivate
import-dirs:          /usr/lib/ghc-8.10.5/site-local/non-negative-0.1.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/non-negative-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/non-negative-0.1.2
hs-libraries:         HSnon-negative-0.1.2-IOvKlCYOcRKFV5QhNasqau
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk base-4.14.2.0
    utility-ht-0.0.16-ENbeZPQpVYnHqott2eWxFg

haddock-interfaces:
    /usr/share/doc/haskell-non-negative/html/non-negative.haddock

haddock-html:         /usr/share/doc/haskell-non-negative/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

