#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nettle
version:              0.3.0
visibility:           public
id:                   nettle-0.3.0-Dw5jlsr2HJl9QPcJTEJmwK
key:                  nettle-0.3.0-Dw5jlsr2HJl9QPcJTEJmwK
license:              MIT
copyright:            Stefan Bühler <stbuehler@web.de>
maintainer:           Stefan Bühler <stbuehler@web.de>
author:               Stefan Bühler <stbuehler@web.de>
homepage:             https://github.com/stbuehler/haskell-nettle
synopsis:             safe nettle binding
description:
    safe binding for the nettle (<http://www.lysator.liu.se/~nisse/nettle/nettle.html>) library.
    Tested with 3.4, might work with 3.2 (but not earlier).

category:             Cryptography
abi:                  b023af20c46ef1dcdb4b52e31329db8e
exposed:              True
exposed-modules:
    Crypto.Nettle.CCM Crypto.Nettle.ChaChaPoly1305
    Crypto.Nettle.Ciphers Crypto.Nettle.HMAC Crypto.Nettle.Hash
    Crypto.Nettle.KeyedHash Crypto.Nettle.UMAC

hidden-modules:
    Crypto.Nettle.Ciphers.Internal Crypto.Nettle.Ciphers.ForeignImports
    Crypto.Nettle.Hash.ForeignImports Crypto.Nettle.Hash.Types
    Nettle.Utils

import-dirs:          /usr/lib/ghc-8.10.5/site-local/nettle-0.3.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/nettle-0.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/nettle-0.3.0
hs-libraries:         HSnettle-0.3.0-Dw5jlsr2HJl9QPcJTEJmwK
extra-libraries:      nettle
depends:
    base-4.14.2.0 byteable-0.1.1-Gf4TH6XbSdI4yHpNVK8xgD
    bytestring-0.10.12.0
    crypto-cipher-types-0.0.9-LQo54bzmotf2im7aqpU2MN
    securemem-0.1.10-BEeIFImmh46Qes0xw1pUh
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV

haddock-interfaces:   /usr/share/doc/haskell-nettle/html/nettle.haddock
haddock-html:         /usr/share/doc/haskell-nettle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

