#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haddock-library
version:              1.9.0
visibility:           public
id:                   haddock-library-1.9.0-WfIrfQVCr7Fk2HwXrxXWR
key:                  haddock-library-1.9.0-WfIrfQVCr7Fk2HwXrxXWR
license:              BSD-2-Clause
maintainer:
    Alec Theriault <alec.theriault@gmail.com>, Alex Biehl <alexbiehl@gmail.com>, Simon Hengel <sol@typeful.net>, Mateusz Kowalczyk <fuuzetsu@fuuzetsu.co.uk>

homepage:             http://www.haskell.org/haddock/
synopsis:             Library exposing some functionality of Haddock.
description:
    Haddock is a documentation-generation tool for Haskell
    libraries. These modules expose some
    functionality of it without pulling in the GHC
    dependency. Please note that the API is likely
    to change so be sure to specify upper bounds in
    your projects. For interacting with Haddock
    itself, see the [haddock package](https://hackage.haskell.org/package/haddock).

category:             Documentation
abi:                  81e2cca553bf85d812e6621ada288188
exposed:              True
exposed-modules:
    Documentation.Haddock.Doc Documentation.Haddock.Markup
    Documentation.Haddock.Parser Documentation.Haddock.Types

hidden-modules:
    CompatPrelude Documentation.Haddock.Parser.Util
    Documentation.Haddock.Parser.Monad
    Documentation.Haddock.Parser.Identifier

import-dirs:          /usr/lib/ghc-8.10.2/site-local/haddock-library-1.9.0
library-dirs:         /usr/lib/ghc-8.10.2/site-local/haddock-library-1.9.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/haddock-library-1.9.0
hs-libraries:         HShaddock-library-1.9.0-WfIrfQVCr7Fk2HwXrxXWR
depends:
    base-4.14.1.0 bytestring-0.10.10.0 containers-0.6.2.1
    parsec-3.1.14.0 text-1.2.3.2 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-haddock-library/html/haddock-library.haddock

haddock-html:         /usr/share/doc/haskell-haddock-library/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

