/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.spi;

import java.net.URL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public interface ArchiveRootProvider {
    public boolean isArchiveFile(URL var1, boolean var2);

    default public boolean isArchiveFile(FileObject fo, boolean strict) {
        URL url = URLMapper.findURL(fo, 1);
        return url == null ? false : this.isArchiveFile(url, strict);
    }

    public boolean isArchiveArtifact(URL var1);

    default public boolean isArchiveArtifact(FileObject fo) {
        URL url = URLMapper.findURL(fo, 1);
        return url == null ? false : this.isArchiveArtifact(url);
    }

    public URL getArchiveFile(URL var1);

    default public FileObject getArchiveFile(FileObject fo) {
        URL rootURL = URLMapper.findURL(fo, 1);
        if (rootURL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveFile(rootURL));
    }

    public URL getArchiveRoot(URL var1);

    default public FileObject getArchiveRoot(FileObject fo) {
        URL archiveURL = URLMapper.findURL(fo, 1);
        if (archiveURL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveRoot(archiveURL));
    }
}

