/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ObjectWas;

public class ColonyWas
extends ObjectWas {
    private static final Logger logger = Logger.getLogger(ColonyWas.class.getName());
    private final Colony colony;
    private final int population;
    private final int productionBonus;
    private final List<BuildableType> buildQueue;

    public ColonyWas(Colony colony) {
        this.colony = colony;
        this.population = colony.getUnitCount();
        this.productionBonus = colony.getProductionBonus();
        this.buildQueue = new ArrayList<BuildableType>(colony.getBuildQueue());
    }

    @Override
    public boolean fireChanges() {
        List<BuildableType> newBuildQueue;
        int newProductionBonus;
        boolean ret = false;
        int newPopulation = this.colony.getUnitCount();
        if (newPopulation != this.population) {
            String pc = Colony.ColonyChangeEvent.POPULATION_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.population, newPopulation);
            ret = true;
        }
        if ((newProductionBonus = this.colony.getProductionBonus()) != this.productionBonus) {
            String pc = Colony.ColonyChangeEvent.BONUS_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.productionBonus, newProductionBonus);
            ret = true;
        }
        if (!(newBuildQueue = this.colony.getBuildQueue()).equals(this.buildQueue)) {
            String pc = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
            this.colony.firePropertyChange(pc, this.buildQueue, newBuildQueue);
            ret = true;
        }
        if (this.colony.getGoodsContainer() != null) {
            ret |= this.colony.getGoodsContainer().fireChanges();
        }
        return ret;
    }
}

