/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;

public final class ClassicMapControls
extends MapControls {
    private final JPanel panel;
    private final Font arrowFont;
    private final List<Component> componentList = new ArrayList<Component>();

    public ClassicMapControls(FreeColClient freeColClient) {
        super(freeColClient, false);
        ImageLibrary lib = freeColClient.getGUI().getFixedImageLibrary();
        this.panel = new MigPanel(new MigLayout("wrap 3"));
        this.panel.add((Component)this.miniMap, "span, width " + lib.scaleInt(220) + ", height " + lib.scaleInt(128));
        this.panel.add((Component)this.miniMapZoomInButton, "newline 10");
        this.panel.add((Component)this.miniMapZoomOutButton, "skip");
        String[] arrows = new String[]{ResourceManager.getString("arrow.NW"), ResourceManager.getString("arrow.N"), ResourceManager.getString("arrow.NE"), ResourceManager.getString("arrow.W"), ResourceManager.getString("arrow.E"), ResourceManager.getString("arrow.SW"), ResourceManager.getString("arrow.S"), ResourceManager.getString("arrow.SE")};
        this.arrowFont = lib.getScaledFont("simple-bold-small", StringUtils.join("", arrows));
        this.panel.add((Component)this.makeButton("NW", arrows[0]), "newline 20");
        this.panel.add(this.makeButton("N", arrows[1]));
        this.panel.add(this.makeButton("NE", arrows[2]));
        this.panel.add(this.makeButton("W", arrows[3]));
        this.panel.add((Component)this.makeButton("E", arrows[4]), "skip");
        this.panel.add(this.makeButton("SW", arrows[5]));
        this.panel.add(this.makeButton("S", arrows[6]));
        this.panel.add((Component)this.makeButton("SE", arrows[7]), "wrap 20");
        this.componentList.add(this.panel);
    }

    private JButton makeButton(String direction, String arrow) {
        ActionManager am = this.getFreeColClient().getActionManager();
        JButton button = new JButton(am.getFreeColAction("moveAction." + direction));
        button.setFont(this.arrowFont);
        button.setText(arrow);
        return button;
    }

    @Override
    protected boolean initializeUnitButtons() {
        if (!super.initializeUnitButtons()) {
            return false;
        }
        for (UnitButton ub : this.unitButtons) {
            this.panel.add(ub);
        }
        this.panel.add((Component)this.infoPanel, "newline push, span, width " + this.infoPanel.getWidth() + ", height " + this.infoPanel.getHeight());
        return true;
    }

    @Override
    public List<Component> getComponentsToAdd(Dimension newSize) {
        if (this.getGame() == null || this.panel.isShowing()) {
            return Collections.emptyList();
        }
        int width = (int)this.panel.getPreferredSize().getWidth();
        this.panel.setSize(width, newSize.height);
        this.panel.setLocation(newSize.width - width, 0);
        return this.componentList;
    }

    @Override
    public List<Component> getComponentsPresent() {
        return this.panel.isShowing() ? this.componentList : Collections.emptyList();
    }
}

