/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.datastream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GetDataStreamsAction
extends ActionType<Response> {
    public static final GetDataStreamsAction INSTANCE = new GetDataStreamsAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamsAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(GetDataStreamsAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected Response read(StreamInput in) throws IOException {
            return new Response(in);
        }

        @Override
        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            listener.onResponse(new Response(TransportAction.getDataStreams(state, request)));
        }

        static List<DataStream> getDataStreams(ClusterState clusterState, Request request) {
            Map<String, DataStream> dataStreams = clusterState.metaData().dataStreams();
            if (request.names.length == 0) {
                return new ArrayList<DataStream>(dataStreams.values());
            }
            ArrayList<DataStream> results = new ArrayList<DataStream>();
            for (String name : request.names) {
                if (Regex.isSimpleMatchPattern(name)) {
                    for (Map.Entry<String, DataStream> entry : dataStreams.entrySet()) {
                        if (!Regex.simpleMatch(name, entry.getKey())) continue;
                        results.add(entry.getValue());
                    }
                    continue;
                }
                if (!dataStreams.containsKey(name)) continue;
                results.add(dataStreams.get(name));
            }
            return results;
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<DataStream> dataStreams;

        public Response(List<DataStream> dataStreams) {
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readList(DataStream::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.dataStreams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (DataStream dataStream : this.dataStreams) {
                dataStream.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final String[] names;

        public Request(String[] names) {
            this.names = Objects.requireNonNull(names);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }
    }
}

