﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotfleetwise/model/DecoderManifestSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoTFleetWise
{
namespace Model
{
  class ListDecoderManifestsResult
  {
  public:
    AWS_IOTFLEETWISE_API ListDecoderManifestsResult();
    AWS_IOTFLEETWISE_API ListDecoderManifestsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IOTFLEETWISE_API ListDecoderManifestsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline const Aws::Vector<DecoderManifestSummary>& GetSummaries() const{ return m_summaries; }

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline void SetSummaries(const Aws::Vector<DecoderManifestSummary>& value) { m_summaries = value; }

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline void SetSummaries(Aws::Vector<DecoderManifestSummary>&& value) { m_summaries = std::move(value); }

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline ListDecoderManifestsResult& WithSummaries(const Aws::Vector<DecoderManifestSummary>& value) { SetSummaries(value); return *this;}

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline ListDecoderManifestsResult& WithSummaries(Aws::Vector<DecoderManifestSummary>&& value) { SetSummaries(std::move(value)); return *this;}

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline ListDecoderManifestsResult& AddSummaries(const DecoderManifestSummary& value) { m_summaries.push_back(value); return *this; }

    /**
     * <p> A list of information about each decoder manifest. </p>
     */
    inline ListDecoderManifestsResult& AddSummaries(DecoderManifestSummary&& value) { m_summaries.push_back(std::move(value)); return *this; }


    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline ListDecoderManifestsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline ListDecoderManifestsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p> The token to retrieve the next set of results, or <code>null</code> if there
     * are no more results. </p>
     */
    inline ListDecoderManifestsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListDecoderManifestsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListDecoderManifestsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListDecoderManifestsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::Vector<DecoderManifestSummary> m_summaries;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IoTFleetWise
} // namespace Aws
