load ../lib/common

@test "make torrents" {
	releasePackage core 'pkg-any-a'
	releasePackage extra 'pkg-any-b'
	db-update

	make_repo_torrents

	[[ -f "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -L "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/core/os/i686/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]

	[[ -f "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
	[[ -L "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/extra/os/i686/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
}

@test "make torrents migrates torrents" {
	releasePackage core 'pkg-any-a'
	releasePackage extra 'pkg-any-b'
	db-update

	# Emulate old make_repo_torrents
	mkdir -p -- "${FTP_BASE}/torrents"
	echo mktorrent > "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent"
	echo mktorrent > "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent"

	make_repo_torrents

	[[ -f "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -L "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/core/os/i686/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ "$(cat "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent")" = mktorrent ]]

	[[ -f "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
	[[ -L "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/extra/os/i686/pkg-any-b-1-1-any${PKGEXT}.torrent" ]]
	[[ "$(cat "${FTP_BASE}/torrents/pkg-any-b-1-1-any${PKGEXT}.torrent")" = mktorrent ]]
}

@test "make torrents with insufficient permissions fails" {
	releasePackage core 'pkg-any-a'
	releasePackage extra 'pkg-any-b'
	db-update

	chmod -w "${FTP_BASE}/core/os/i686"
	if make_repo_torrents; then return 1; fi
	chmod +w "${FTP_BASE}/core/os/i686"
}

@test "make torrents maintains the pool after failure" {
	releasePackage core 'pkg-any-a'
	db-update

	mkdir "${FTP_BASE}/torrents"
	chmod -w "${FTP_BASE}/torrents"
	if make_repo_torrents; then return 1; fi
	chmod +w "${FTP_BASE}/torrents"

	[[ ! -f "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/core/os/i686/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]

	make_repo_torrents

	[[ -f "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -L "${FTP_BASE}/torrents/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
	[[ -f "${FTP_BASE}/core/os/i686/pkg-any-a-1-1-any${PKGEXT}.torrent" ]]
}
