/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.StructContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkMetadata;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.SpecificReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.StructTypes;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ValueReaders;
import org.openjdk.jmc.flightrecorder.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.parser.IEventSink;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

class TypeManager {
    private final Map<Long, StructContentType<Object[]>> structTypes = new HashMap<Long, StructContentType<Object[]>>();
    private final FastAccessNumberMap<TypeEntry> otherTypes = new FastAccessNumberMap();
    private final FastAccessNumberMap<EventTypeEntry> eventTypes = new FastAccessNumberMap();
    private final LoaderContext context;
    private final ChunkStructure header;
    private long skippedEventCount;

    TypeManager(List<ChunkMetadata.ClassElement> classList, LoaderContext context, ChunkStructure header) throws InvalidJfrFileException, IOException {
        this.context = context;
        this.header = header;
        for (ChunkMetadata.ClassElement classElement : classList) {
            if (classElement.isEventType()) {
                this.eventTypes.put(classElement.classId, (Object)new EventTypeEntry(classElement));
                continue;
            }
            this.otherTypes.put(classElement.classId, (Object)new TypeEntry(classElement, context));
        }
        for (ChunkMetadata.ClassElement classElement : classList) {
            this.resolveAnnotations(classElement);
            for (int i = 0; i < classElement.getFieldCount(); ++i) {
                this.resolveAnnotations(classElement.fields.get(i));
            }
        }
        for (EventTypeEntry eventTypeEntry : this.eventTypes) {
            eventTypeEntry.init(context);
        }
    }

    void readEvent(long typeId, IDataInput input, long size) throws InvalidJfrFileException, IOException {
        EventTypeEntry entry = (EventTypeEntry)this.eventTypes.get(typeId);
        if (entry == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Event type with id " + typeId + " was not declared");
            ++this.skippedEventCount;
        } else {
            entry.readEvent(input);
            entry.updateEventStats(size);
        }
    }

    void readConstants(long typeId, IDataInput input, int constantCount) throws InvalidJfrFileException, IOException {
        TypeEntry entry = this.getTypeEntry(typeId);
        for (int j = 0; j < constantCount; ++j) {
            entry.readConstant(input);
        }
    }

    void resolveConstants() throws InvalidJfrFileException {
        HashMap<String, FastAccessNumberMap<Object>> pools = new HashMap<String, FastAccessNumberMap<Object>>();
        for (TypeEntry classEntry : this.otherTypes) {
            classEntry.resolveConstants();
            pools.put(classEntry.element.typeIdentifier, classEntry.constants);
        }
        this.context.allConstantPoolsResolved(pools);
    }

    long getSkippedEventCount() {
        return this.skippedEventCount;
    }

    private TypeEntry getTypeEntry(long typeId) throws InvalidJfrFileException {
        TypeEntry entry = (TypeEntry)this.otherTypes.get(typeId);
        if (entry == null) {
            throw new InvalidJfrFileException("Class with id " + typeId + " was not declared");
        }
        return entry;
    }

    private void resolveAnnotations(ChunkMetadata.AnnotatedElement ae) throws InvalidJfrFileException {
        if (ae.annotations != null) {
            for (ChunkMetadata.AnnotationElement a : ae.annotations) {
                ChunkMetadata.ClassElement annotationType = this.getTypeEntry((long)a.classId).element;
                ae.resolveAnnotation(annotationType.typeIdentifier, a.values);
            }
        }
    }

    private ValueReaders.IValueReader createFieldReader(ChunkMetadata.FieldElement f, String valueType, LoaderContext context, String eventTypeId) throws InvalidJfrFileException {
        TypeEntry fieldType = this.getTypeEntry(f.classId);
        String typeIdentifier = fieldType.element.typeIdentifier;
        boolean isNumeric = ValueReaders.PrimitiveReader.isNumeric(typeIdentifier);
        ValueReaders.IValueReader reader = fieldType.getReader();
        if (f.ticksUnitKind == UnitLookup.TIMESPAN) {
            reader = new ValueReaders.QuantityReader(typeIdentifier, (IUnit)this.header.getTicksTimespanUnit(), f.unsigned);
        } else if (f.ticksUnitKind == UnitLookup.TIMESTAMP) {
            reader = new ValueReaders.TicksTimestampReader(typeIdentifier, this.header, f.unsigned);
        } else if (f.unit != null) {
            reader = new ValueReaders.QuantityReader(typeIdentifier, f.unit, f.unsigned);
        } else if (isNumeric) {
            IUnit unit;
            reader = "org.openjdk.jmc.flightrecorder.value_interpretation.type_identifier".equals(valueType) ? new TypeIdentifierReader(typeIdentifier, f.unsigned) : ("lineNumber".equals(f.fieldIdentifier) || "bytecodeIndex".equals(f.fieldIdentifier) || "modifiers".equals(f.fieldIdentifier) || "javaThreadId".equals(f.fieldIdentifier) ? new ValueReaders.PrimitiveReader(typeIdentifier) : new ValueReaders.QuantityReader(typeIdentifier, (IUnit)((unit = UnitLookup.getUnitOrNull((String)valueType)) == null ? UnitLookup.NUMBER_UNITY : unit), f.unsigned));
        }
        if (f.isStoredInPool()) {
            if (isNumeric) {
                throw new InvalidJfrFileException("Numerics should not be put in constant pools");
            }
            reader = new ValueReaders.PoolReader(fieldType.constants, reader.getContentType(), context, typeIdentifier, eventTypeId);
        }
        return f.isArray() ? new ValueReaders.ArrayReader(reader, this.header) : reader;
    }

    private static String buildLabel(String id, ChunkMetadata.AnnotatedElement element) {
        String labelOrId = element.label == null ? id : element.label;
        return element.experimental ? MessageFormat.format(Messages.getString("TypeManager_EXPERIMENTAL_TYPE"), labelOrId) : labelOrId;
    }

    private class TypeIdentifierReader
    implements ValueReaders.IValueReader {
        private final String typeIdentifier;
        private final boolean unsigned;

        TypeIdentifierReader(String typeIdentifier, boolean unsigned) throws InvalidJfrFileException {
            this.typeIdentifier = typeIdentifier;
            this.unsigned = unsigned;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            long typeId = ValueReaders.PrimitiveReader.readLong(in, this.typeIdentifier, this.unsigned);
            return ((EventTypeEntry)TypeManager.this.eventTypes.get(typeId)).getValueType();
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            return value;
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            ValueReaders.PrimitiveReader.readLong(in, this.typeIdentifier, this.unsigned);
        }

        @Override
        public ContentType<?> getContentType() {
            return UnitLookup.LABELED_IDENTIFIER;
        }
    }

    private class EventTypeEntry {
        private final ChunkMetadata.ClassElement element;
        private final List<ValueReaders.IValueReader> valueReaders;
        private Object[] reusableStruct;
        private IEventSink eventSink;
        private LabeledIdentifier eventType;
        private LoaderContext context;

        EventTypeEntry(ChunkMetadata.ClassElement element) {
            this.element = element;
            this.valueReaders = new ArrayList<ValueReaders.IValueReader>(element.getFieldCount());
        }

        void readEvent(IDataInput input) throws InvalidJfrFileException, IOException {
            for (int i = 0; i < this.valueReaders.size(); ++i) {
                this.reusableStruct[i] = this.valueReaders.get(i).read(input, false);
            }
            this.eventSink.addEvent(this.reusableStruct);
        }

        LabeledIdentifier getValueType() {
            if (this.eventType == null) {
                this.eventType = new LabeledIdentifier(this.element.typeIdentifier, this.element.classId, this.element.label, this.element.description);
            }
            return this.eventType;
        }

        void init(LoaderContext context) throws InvalidJfrFileException, IOException {
            this.context = context;
            if (context.hideExperimentals() && this.element.experimental) {
                this.eventSink = new NopEventSink();
            } else {
                ArrayList<ValueField> fieldsList = new ArrayList<ValueField>();
                ArrayList<Integer> skipFields = new ArrayList<Integer>();
                for (int i = 0; i < this.element.getFieldCount(); ++i) {
                    ChunkMetadata.FieldElement fe = this.element.fields.get(i);
                    String valueType = context.getValueInterpretation(this.element.typeIdentifier, fe.fieldIdentifier);
                    ValueReaders.IValueReader reader = TypeManager.this.createFieldReader(fe, valueType, context, this.element.typeIdentifier);
                    String fieldLabel = TypeManager.buildLabel(fe.fieldIdentifier, fe);
                    if (context.hideExperimentals() && fe.experimental) {
                        this.valueReaders.add(reader);
                        skipFields.add(i);
                        continue;
                    }
                    if (reader instanceof ValueReaders.StructReader) {
                        ChunkMetadata.ClassElement fieldType = ((TypeManager)TypeManager.this).getTypeEntry((long)fe.classId).element;
                        for (int j = 0; j < fieldType.getFieldCount(); ++j) {
                            ChunkMetadata.FieldElement nestedField = fieldType.fields.get(j);
                            String nestedId = fe.fieldIdentifier + ":" + nestedField.fieldIdentifier;
                            String nestedValueType = context.getValueInterpretation(this.element.typeIdentifier, nestedId);
                            ValueReaders.IValueReader nestedReader = TypeManager.this.createFieldReader(nestedField, nestedValueType, context, this.element.typeIdentifier);
                            this.valueReaders.add(nestedReader);
                            String nestedLabel = fieldLabel + " : " + (nestedField.label == null ? nestedField.fieldIdentifier : nestedField.label);
                            fieldsList.add(new ValueField(nestedId, nestedLabel, nestedField.description, nestedReader.getContentType()));
                        }
                        continue;
                    }
                    this.valueReaders.add(reader);
                    fieldsList.add(new ValueField(fe.fieldIdentifier, fieldLabel, fe.description, reader.getContentType()));
                }
                String typeLabel = TypeManager.buildLabel(this.element.typeIdentifier, this.element);
                this.eventSink = context.getSinkFactory().create(this.element.typeIdentifier, typeLabel, this.element.category, this.element.description, fieldsList);
                this.reusableStruct = new Object[this.valueReaders.size()];
                if (skipFields.size() > 0) {
                    this.eventSink = new SkipFieldsEventSink(this.eventSink, skipFields, this.reusableStruct.length);
                }
            }
        }

        void updateEventStats(long size) {
            this.context.updateEventStats(this.element.typeIdentifier, size);
        }
    }

    private class TypeEntry {
        private static final String STRUCT_TYPE_CLASS = "java.lang.Class";
        private static final String STRUCT_TYPE_THREAD = "java.lang.Thread";
        private static final String STRUCT_TYPE_STACK_TRACE = "com.oracle.jfr.types.StackTrace";
        private static final String STRUCT_TYPE_STACK_TRACE_2 = "jdk.types.StackTrace";
        private static final String STRUCT_TYPE_STACK_FRAME = "com.oracle.jfr.types.StackFrame";
        private static final String STRUCT_TYPE_STACK_FRAME_2 = "jdk.types.StackFrame";
        private static final String STRUCT_TYPE_METHOD = "com.oracle.jfr.types.Method";
        private static final String STRUCT_TYPE_METHOD_2 = "jdk.types.Method";
        private static final String STRUCT_TYPE_CLASS_LOADER = "com.oracle.jfr.types.ClassLoader";
        private static final String STRUCT_TYPE_CLASS_LOADER_2 = "jdk.types.ClassLoader";
        private static final String STRUCT_TYPE_MODULE = "com.oracle.jfr.types.Module";
        private static final String STRUCT_TYPE_MODULE_2 = "jdk.types.Module";
        private static final String STRUCT_TYPE_PACKAGE = "com.oracle.jfr.types.Package";
        private static final String STRUCT_TYPE_PACKAGE_2 = "jdk.types.Package";
        private static final String STRUCT_TYPE_OLD_OBJECT = "com.oracle.jfr.types.OldObject";
        private static final String STRUCT_TYPE_OLD_OBJECT_2 = "jdk.types.OldObject";
        private static final String STRUCT_TYPE_OLD_OBJECT_ARRAY = "com.oracle.jfr.types.OldObjectArray";
        private static final String STRUCT_TYPE_OLD_OBJECT_ARRAY_2 = "jdk.types.OldObjectArray";
        private static final String STRUCT_TYPE_OLD_OBJECT_FIELD = "com.oracle.jfr.types.OldObjectField";
        private static final String STRUCT_TYPE_OLD_OBJECT_FIELD_2 = "jdk.types.OldObjectField";
        private static final String STRUCT_TYPE_OLD_OBJECT_GC_ROOT = "com.oracle.jfr.types.OldObjectGcRoot";
        private static final String STRUCT_TYPE_OLD_OBJECT_GC_ROOT_2 = "jdk.types.OldObjectGcRoot";
        private static final String STRUCT_TYPE_THREAD_GROUP = "com.oracle.jfr.types.ThreadGroup";
        private static final String STRUCT_TYPE_THREAD_GROUP_2 = "jdk.types.ThreadGroup";
        final ChunkMetadata.ClassElement element;
        final LoaderContext context;
        final FastAccessNumberMap<Object> constants;
        private ValueReaders.IValueReader reader;

        TypeEntry(ChunkMetadata.ClassElement element, LoaderContext context) {
            this(element, context, (FastAccessNumberMap<Object>)new FastAccessNumberMap());
        }

        TypeEntry(ChunkMetadata.ClassElement element, LoaderContext context, FastAccessNumberMap<Object> constants) {
            this.element = element;
            this.context = context;
            this.constants = constants;
        }

        public ValueReaders.IValueReader getReader() throws InvalidJfrFileException {
            if (this.reader == null) {
                int fieldCount = this.element.getFieldCount();
                if (this.element.isSimpleType() && fieldCount == 1) {
                    ChunkMetadata.FieldElement singleField = this.element.fields.get(0);
                    if (singleField.classId == this.element.classId) {
                        throw new InvalidJfrFileException(this.element.typeIdentifier + " is a simple type referring to itself");
                    }
                    this.reader = TypeManager.this.createFieldReader(this.element.fields.get(0), null, this.context, this.element.typeIdentifier);
                } else if (fieldCount == 0 && this.element.superType == null) {
                    this.reader = "java.lang.String".equals(this.element.typeIdentifier) ? new ValueReaders.StringReader(this.constants) : new ValueReaders.PrimitiveReader(this.element.typeIdentifier);
                } else {
                    ValueReaders.AbstractStructReader typeReader = this.element.typeIdentifier.startsWith("jdk.") ? this.createStructReaderV2(this.element.typeIdentifier, this.element.label, this.element.description, fieldCount) : this.createStructReaderV1(this.element.typeIdentifier, this.element.label, this.element.description, fieldCount);
                    this.reader = typeReader;
                    for (int i = 0; i < fieldCount; ++i) {
                        ChunkMetadata.FieldElement fe = this.element.fields.get(i);
                        ValueReaders.IValueReader reader = TypeManager.this.createFieldReader(fe, null, this.context, this.element.typeIdentifier);
                        String labelOrId = fe.label == null ? fe.fieldIdentifier : fe.label;
                        typeReader.addField(fe.fieldIdentifier, labelOrId, fe.description, reader);
                    }
                }
            }
            return this.reader;
        }

        private ValueReaders.AbstractStructReader createStructReaderV2(String identifier, String name, String description, int fieldCount) {
            switch (identifier) {
                case "jdk.types.ThreadGroup": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrThreadGroup.class, fieldCount, UnitLookup.THREAD_GROUP);
                }
                case "jdk.types.ClassLoader": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaClassLoader.class, fieldCount, UnitLookup.CLASS_LOADER);
                }
                case "jdk.types.OldObjectGcRoot": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectGcRoot.class, fieldCount, UnitLookup.OLD_OBJECT_GC_ROOT);
                }
                case "jdk.types.OldObject": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObject.class, fieldCount, UnitLookup.OLD_OBJECT);
                }
                case "jdk.types.OldObjectArray": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectArray.class, fieldCount, UnitLookup.OLD_OBJECT_ARRAY);
                }
                case "jdk.types.OldObjectField": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectField.class, fieldCount, UnitLookup.OLD_OBJECT_FIELD);
                }
                case "jdk.types.Method": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrMethod.class, fieldCount, UnitLookup.METHOD);
                }
                case "jdk.types.StackFrame": {
                    return new SpecificReaders.StackFrame2Reader(StructTypes.JfrFrame.class, fieldCount, UnitLookup.STACKTRACE_FRAME);
                }
                case "jdk.types.StackTrace": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrStackTrace.class, fieldCount, UnitLookup.STACKTRACE);
                }
                case "jdk.types.Module": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaModule.class, fieldCount, UnitLookup.MODULE);
                }
                case "jdk.types.Package": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaPackage.class, fieldCount, UnitLookup.PACKAGE);
                }
            }
            return this.createDefaultStructReader(fieldCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ValueReaders.AbstractStructReader createDefaultStructReader(int fieldCount) {
            Map map = TypeManager.this.structTypes;
            synchronized (map) {
                StructContentType structType = (StructContentType)TypeManager.this.structTypes.get(this.element.classId);
                if (structType == null) {
                    structType = new StructContentType(this.element.typeIdentifier, this.element.label != null ? this.element.label : this.element.typeIdentifier, this.element.description);
                    TypeManager.this.structTypes.put(this.element.classId, structType);
                }
                return new ValueReaders.StructReader((StructContentType<Object[]>)structType, fieldCount);
            }
        }

        private ValueReaders.AbstractStructReader createStructReaderV1(String identifier, String name, String description, int fieldCount) {
            switch (identifier) {
                case "java.lang.Thread": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrThread.class, fieldCount, UnitLookup.THREAD);
                }
                case "com.oracle.jfr.types.ThreadGroup": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrThreadGroup.class, fieldCount, UnitLookup.THREAD_GROUP);
                }
                case "java.lang.Class": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaClass.class, fieldCount, UnitLookup.CLASS);
                }
                case "com.oracle.jfr.types.ClassLoader": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaClassLoader.class, fieldCount, UnitLookup.CLASS_LOADER);
                }
                case "com.oracle.jfr.types.OldObjectGcRoot": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectGcRoot.class, fieldCount, UnitLookup.OLD_OBJECT_GC_ROOT);
                }
                case "com.oracle.jfr.types.OldObject": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObject.class, fieldCount, UnitLookup.OLD_OBJECT);
                }
                case "com.oracle.jfr.types.OldObjectArray": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectArray.class, fieldCount, UnitLookup.OLD_OBJECT_ARRAY);
                }
                case "com.oracle.jfr.types.OldObjectField": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrOldObjectField.class, fieldCount, UnitLookup.OLD_OBJECT_FIELD);
                }
                case "com.oracle.jfr.types.Method": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrMethod.class, fieldCount, UnitLookup.METHOD);
                }
                case "com.oracle.jfr.types.StackFrame": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrFrame.class, fieldCount, UnitLookup.STACKTRACE_FRAME);
                }
                case "com.oracle.jfr.types.StackTrace": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrStackTrace.class, fieldCount, UnitLookup.STACKTRACE);
                }
                case "com.oracle.jfr.types.Module": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaModule.class, fieldCount, UnitLookup.MODULE);
                }
                case "com.oracle.jfr.types.Package": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaPackage.class, fieldCount, UnitLookup.PACKAGE);
                }
            }
            return this.createDefaultStructReader(fieldCount);
        }

        void resolveConstants() throws InvalidJfrFileException {
            ValueReaders.IValueReader r = this.reader;
            if (r != null) {
                for (Object c : this.constants) {
                    r.resolve(c);
                }
            }
            this.context.addTypeConstantPool(this.element.classId, this.element.typeIdentifier, this.constants);
        }

        void readConstant(IDataInput input) throws InvalidJfrFileException, IOException {
            long start = input.getPosition();
            long constantIndex = input.readLong();
            Object value = this.constants.get(constantIndex);
            if (value == null) {
                value = this.getReader().read(input, true);
                value = this.context.constantRead(constantIndex, value, this.element.typeIdentifier);
                this.constants.put(constantIndex, value);
            } else {
                this.getReader().skip(input);
            }
            long end = input.getPosition();
            this.context.addEntryPoolSize(this.element.typeIdentifier, end - start);
        }
    }

    private static class SkipFieldsEventSink
    implements IEventSink {
        private final IEventSink subSink;
        private final List<Integer> skipFields;
        private final Object[] reusableStruct;

        SkipFieldsEventSink(IEventSink subSink, List<Integer> skipFields, int fieldCount) {
            this.subSink = subSink;
            this.skipFields = skipFields;
            this.reusableStruct = new Object[fieldCount - skipFields.size()];
        }

        @Override
        public void addEvent(Object[] fieldValues) {
            Iterator<Integer> skipIter = this.skipFields.iterator();
            int skipNext = skipIter.next();
            int j = 0;
            for (int i = 0; i < fieldValues.length; ++i) {
                if (i != skipNext) {
                    this.reusableStruct[j++] = fieldValues[i];
                    continue;
                }
                if (!skipIter.hasNext()) continue;
                skipNext = skipIter.next();
            }
            this.subSink.addEvent(this.reusableStruct);
        }
    }

    private static class NopEventSink
    implements IEventSink {
        private NopEventSink() {
        }

        @Override
        public void addEvent(Object[] values) {
        }
    }
}

