#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random-source
version:              0.3.0.11
visibility:           public
id:                   random-source-0.3.0.11-GZSMCf2BpOL57GjVDH5kGj
key:                  random-source-0.3.0.11-GZSMCf2BpOL57GjVDH5kGj
license:              LicenseRef-PublicDomain
maintainer:           James Cook <mokus@deepbondi.net>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/mokus0/random-fu
synopsis:             Generic basis for random number generators
description:
    Random number generation based on entropy sources
    able to produce a small but well-defined set of
    primitive variates.  Also includes facilities for
    \"completing\" partial implementations, making it
    easy to define new entropy sources in a way that
    is naturally forward-compatible.

category:             Math
abi:                  4ebd8d3297c01f1c9707d2cf3dff9be0
exposed:              True
exposed-modules:
    Data.Random.Internal.Source Data.Random.Internal.Words
    Data.Random.Source Data.Random.Source.DevRandom
    Data.Random.Source.IO Data.Random.Source.MWC
    Data.Random.Source.PureMT Data.Random.Source.Std
    Data.Random.Source.StdGen

hidden-modules:
    Data.Random.Source.Internal.Prim Data.Random.Source.Internal.TH

import-dirs:          /usr/lib/ghc-8.10.5/site-local/random-source-0.3.0.11
library-dirs:         /usr/lib/ghc-8.10.5/site-local/random-source-0.3.0.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/random-source-0.3.0.11
hs-libraries:         HSrandom-source-0.3.0.11-GZSMCf2BpOL57GjVDH5kGj
depends:
    base-4.14.2.0 flexible-defaults-0.0.3-8RAkVRmvCPbBLR0js49nPu
    mersenne-random-pure64-0.2.2.0-4Pznc5LaATZHOe7X7DP55u mtl-2.2.2
    mwc-random-0.15.0.1-Lu34VS2dGNU7K4wW2NiHiE
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub
    stateref-0.3-Eh1DsLBg0MW5KjbrEZPHel
    syb-0.7.2.1-LCeM0k3cWww5FKQVRHAOJq template-haskell-2.16.0.0
    th-extras-0.0.0.4-FnOOGG1MkqcGS8mNYxqgfy

haddock-interfaces:
    /usr/share/doc/haskell-random-source/html/random-source.haddock

haddock-html:         /usr/share/doc/haskell-random-source/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

