﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ChimeSDKVoice
{
namespace Model
{
  class GetPhoneNumberSettingsResult
  {
  public:
    AWS_CHIMESDKVOICE_API GetPhoneNumberSettingsResult();
    AWS_CHIMESDKVOICE_API GetPhoneNumberSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CHIMESDKVOICE_API GetPhoneNumberSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline const Aws::String& GetCallingName() const{ return m_callingName; }

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline void SetCallingName(const Aws::String& value) { m_callingName = value; }

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline void SetCallingName(Aws::String&& value) { m_callingName = std::move(value); }

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline void SetCallingName(const char* value) { m_callingName.assign(value); }

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline GetPhoneNumberSettingsResult& WithCallingName(const Aws::String& value) { SetCallingName(value); return *this;}

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline GetPhoneNumberSettingsResult& WithCallingName(Aws::String&& value) { SetCallingName(std::move(value)); return *this;}

    /**
     * <p>The default outbound calling name for the account.</p>
     */
    inline GetPhoneNumberSettingsResult& WithCallingName(const char* value) { SetCallingName(value); return *this;}


    /**
     * <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
     */
    inline const Aws::Utils::DateTime& GetCallingNameUpdatedTimestamp() const{ return m_callingNameUpdatedTimestamp; }

    /**
     * <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
     */
    inline void SetCallingNameUpdatedTimestamp(const Aws::Utils::DateTime& value) { m_callingNameUpdatedTimestamp = value; }

    /**
     * <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
     */
    inline void SetCallingNameUpdatedTimestamp(Aws::Utils::DateTime&& value) { m_callingNameUpdatedTimestamp = std::move(value); }

    /**
     * <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
     */
    inline GetPhoneNumberSettingsResult& WithCallingNameUpdatedTimestamp(const Aws::Utils::DateTime& value) { SetCallingNameUpdatedTimestamp(value); return *this;}

    /**
     * <p>The updated outbound calling name timestamp, in ISO 8601 format.</p>
     */
    inline GetPhoneNumberSettingsResult& WithCallingNameUpdatedTimestamp(Aws::Utils::DateTime&& value) { SetCallingNameUpdatedTimestamp(std::move(value)); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline GetPhoneNumberSettingsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline GetPhoneNumberSettingsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline GetPhoneNumberSettingsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::String m_callingName;

    Aws::Utils::DateTime m_callingNameUpdatedTimestamp;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ChimeSDKVoice
} // namespace Aws
