﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigatewayv2/ApiGatewayV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/apigatewayv2/model/AuthorizationType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/apigatewayv2/model/ParameterConstraints.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ApiGatewayV2
{
namespace Model
{
  class UpdateRouteResult
  {
  public:
    AWS_APIGATEWAYV2_API UpdateRouteResult();
    AWS_APIGATEWAYV2_API UpdateRouteResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APIGATEWAYV2_API UpdateRouteResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Specifies whether a route is managed by API Gateway. If you created an API
     * using quick create, the $default route is managed by API Gateway. You can't
     * modify the $default route key.</p>
     */
    inline bool GetApiGatewayManaged() const{ return m_apiGatewayManaged; }

    /**
     * <p>Specifies whether a route is managed by API Gateway. If you created an API
     * using quick create, the $default route is managed by API Gateway. You can't
     * modify the $default route key.</p>
     */
    inline void SetApiGatewayManaged(bool value) { m_apiGatewayManaged = value; }

    /**
     * <p>Specifies whether a route is managed by API Gateway. If you created an API
     * using quick create, the $default route is managed by API Gateway. You can't
     * modify the $default route key.</p>
     */
    inline UpdateRouteResult& WithApiGatewayManaged(bool value) { SetApiGatewayManaged(value); return *this;}


    /**
     * <p>Specifies whether an API key is required for this route. Supported only for
     * WebSocket APIs.</p>
     */
    inline bool GetApiKeyRequired() const{ return m_apiKeyRequired; }

    /**
     * <p>Specifies whether an API key is required for this route. Supported only for
     * WebSocket APIs.</p>
     */
    inline void SetApiKeyRequired(bool value) { m_apiKeyRequired = value; }

    /**
     * <p>Specifies whether an API key is required for this route. Supported only for
     * WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithApiKeyRequired(bool value) { SetApiKeyRequired(value); return *this;}


    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline const Aws::Vector<Aws::String>& GetAuthorizationScopes() const{ return m_authorizationScopes; }

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline void SetAuthorizationScopes(const Aws::Vector<Aws::String>& value) { m_authorizationScopes = value; }

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline void SetAuthorizationScopes(Aws::Vector<Aws::String>&& value) { m_authorizationScopes = std::move(value); }

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline UpdateRouteResult& WithAuthorizationScopes(const Aws::Vector<Aws::String>& value) { SetAuthorizationScopes(value); return *this;}

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline UpdateRouteResult& WithAuthorizationScopes(Aws::Vector<Aws::String>&& value) { SetAuthorizationScopes(std::move(value)); return *this;}

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline UpdateRouteResult& AddAuthorizationScopes(const Aws::String& value) { m_authorizationScopes.push_back(value); return *this; }

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline UpdateRouteResult& AddAuthorizationScopes(Aws::String&& value) { m_authorizationScopes.push_back(std::move(value)); return *this; }

    /**
     * <p>A list of authorization scopes configured on a route. The scopes are used
     * with a JWT authorizer to authorize the method invocation. The authorization
     * works by matching the route scopes against the scopes parsed from the access
     * token in the incoming request. The method invocation is authorized if any route
     * scope matches a claimed scope in the access token. Otherwise, the invocation is
     * not authorized. When the route scope is configured, the client must provide an
     * access token instead of an identity token for authorization purposes.</p>
     */
    inline UpdateRouteResult& AddAuthorizationScopes(const char* value) { m_authorizationScopes.push_back(value); return *this; }


    /**
     * <p>The authorization type for the route. For WebSocket APIs, valid values are
     * NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
     * using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
     * JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     * for using a Lambda authorizer.</p>
     */
    inline const AuthorizationType& GetAuthorizationType() const{ return m_authorizationType; }

    /**
     * <p>The authorization type for the route. For WebSocket APIs, valid values are
     * NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
     * using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
     * JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     * for using a Lambda authorizer.</p>
     */
    inline void SetAuthorizationType(const AuthorizationType& value) { m_authorizationType = value; }

    /**
     * <p>The authorization type for the route. For WebSocket APIs, valid values are
     * NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
     * using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
     * JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     * for using a Lambda authorizer.</p>
     */
    inline void SetAuthorizationType(AuthorizationType&& value) { m_authorizationType = std::move(value); }

    /**
     * <p>The authorization type for the route. For WebSocket APIs, valid values are
     * NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
     * using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
     * JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     * for using a Lambda authorizer.</p>
     */
    inline UpdateRouteResult& WithAuthorizationType(const AuthorizationType& value) { SetAuthorizationType(value); return *this;}

    /**
     * <p>The authorization type for the route. For WebSocket APIs, valid values are
     * NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
     * using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
     * JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM
     * for using a Lambda authorizer.</p>
     */
    inline UpdateRouteResult& WithAuthorizationType(AuthorizationType&& value) { SetAuthorizationType(std::move(value)); return *this;}


    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline const Aws::String& GetAuthorizerId() const{ return m_authorizerId; }

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline void SetAuthorizerId(const Aws::String& value) { m_authorizerId = value; }

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline void SetAuthorizerId(Aws::String&& value) { m_authorizerId = std::move(value); }

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline void SetAuthorizerId(const char* value) { m_authorizerId.assign(value); }

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline UpdateRouteResult& WithAuthorizerId(const Aws::String& value) { SetAuthorizerId(value); return *this;}

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline UpdateRouteResult& WithAuthorizerId(Aws::String&& value) { SetAuthorizerId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the Authorizer resource to be associated with this route.
     * The authorizer identifier is generated by API Gateway when you created the
     * authorizer.</p>
     */
    inline UpdateRouteResult& WithAuthorizerId(const char* value) { SetAuthorizerId(value); return *this;}


    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline const Aws::String& GetModelSelectionExpression() const{ return m_modelSelectionExpression; }

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline void SetModelSelectionExpression(const Aws::String& value) { m_modelSelectionExpression = value; }

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline void SetModelSelectionExpression(Aws::String&& value) { m_modelSelectionExpression = std::move(value); }

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline void SetModelSelectionExpression(const char* value) { m_modelSelectionExpression.assign(value); }

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline UpdateRouteResult& WithModelSelectionExpression(const Aws::String& value) { SetModelSelectionExpression(value); return *this;}

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline UpdateRouteResult& WithModelSelectionExpression(Aws::String&& value) { SetModelSelectionExpression(std::move(value)); return *this;}

    /**
     * <p>The model selection expression for the route. Supported only for WebSocket
     * APIs.</p>
     */
    inline UpdateRouteResult& WithModelSelectionExpression(const char* value) { SetModelSelectionExpression(value); return *this;}


    /**
     * <p>The operation name for the route.</p>
     */
    inline const Aws::String& GetOperationName() const{ return m_operationName; }

    /**
     * <p>The operation name for the route.</p>
     */
    inline void SetOperationName(const Aws::String& value) { m_operationName = value; }

    /**
     * <p>The operation name for the route.</p>
     */
    inline void SetOperationName(Aws::String&& value) { m_operationName = std::move(value); }

    /**
     * <p>The operation name for the route.</p>
     */
    inline void SetOperationName(const char* value) { m_operationName.assign(value); }

    /**
     * <p>The operation name for the route.</p>
     */
    inline UpdateRouteResult& WithOperationName(const Aws::String& value) { SetOperationName(value); return *this;}

    /**
     * <p>The operation name for the route.</p>
     */
    inline UpdateRouteResult& WithOperationName(Aws::String&& value) { SetOperationName(std::move(value)); return *this;}

    /**
     * <p>The operation name for the route.</p>
     */
    inline UpdateRouteResult& WithOperationName(const char* value) { SetOperationName(value); return *this;}


    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetRequestModels() const{ return m_requestModels; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline void SetRequestModels(const Aws::Map<Aws::String, Aws::String>& value) { m_requestModels = value; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline void SetRequestModels(Aws::Map<Aws::String, Aws::String>&& value) { m_requestModels = std::move(value); }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRequestModels(const Aws::Map<Aws::String, Aws::String>& value) { SetRequestModels(value); return *this;}

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRequestModels(Aws::Map<Aws::String, Aws::String>&& value) { SetRequestModels(std::move(value)); return *this;}

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(const Aws::String& key, const Aws::String& value) { m_requestModels.emplace(key, value); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(Aws::String&& key, const Aws::String& value) { m_requestModels.emplace(std::move(key), value); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(const Aws::String& key, Aws::String&& value) { m_requestModels.emplace(key, std::move(value)); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(Aws::String&& key, Aws::String&& value) { m_requestModels.emplace(std::move(key), std::move(value)); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(const char* key, Aws::String&& value) { m_requestModels.emplace(key, std::move(value)); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(Aws::String&& key, const char* value) { m_requestModels.emplace(std::move(key), value); return *this; }

    /**
     * <p>The request models for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestModels(const char* key, const char* value) { m_requestModels.emplace(key, value); return *this; }


    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline const Aws::Map<Aws::String, ParameterConstraints>& GetRequestParameters() const{ return m_requestParameters; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline void SetRequestParameters(const Aws::Map<Aws::String, ParameterConstraints>& value) { m_requestParameters = value; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline void SetRequestParameters(Aws::Map<Aws::String, ParameterConstraints>&& value) { m_requestParameters = std::move(value); }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRequestParameters(const Aws::Map<Aws::String, ParameterConstraints>& value) { SetRequestParameters(value); return *this;}

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRequestParameters(Aws::Map<Aws::String, ParameterConstraints>&& value) { SetRequestParameters(std::move(value)); return *this;}

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(const Aws::String& key, const ParameterConstraints& value) { m_requestParameters.emplace(key, value); return *this; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(Aws::String&& key, const ParameterConstraints& value) { m_requestParameters.emplace(std::move(key), value); return *this; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(const Aws::String& key, ParameterConstraints&& value) { m_requestParameters.emplace(key, std::move(value)); return *this; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(Aws::String&& key, ParameterConstraints&& value) { m_requestParameters.emplace(std::move(key), std::move(value)); return *this; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(const char* key, ParameterConstraints&& value) { m_requestParameters.emplace(key, std::move(value)); return *this; }

    /**
     * <p>The request parameters for the route. Supported only for WebSocket APIs.</p>
     */
    inline UpdateRouteResult& AddRequestParameters(const char* key, const ParameterConstraints& value) { m_requestParameters.emplace(key, value); return *this; }


    /**
     * <p>The route ID.</p>
     */
    inline const Aws::String& GetRouteId() const{ return m_routeId; }

    /**
     * <p>The route ID.</p>
     */
    inline void SetRouteId(const Aws::String& value) { m_routeId = value; }

    /**
     * <p>The route ID.</p>
     */
    inline void SetRouteId(Aws::String&& value) { m_routeId = std::move(value); }

    /**
     * <p>The route ID.</p>
     */
    inline void SetRouteId(const char* value) { m_routeId.assign(value); }

    /**
     * <p>The route ID.</p>
     */
    inline UpdateRouteResult& WithRouteId(const Aws::String& value) { SetRouteId(value); return *this;}

    /**
     * <p>The route ID.</p>
     */
    inline UpdateRouteResult& WithRouteId(Aws::String&& value) { SetRouteId(std::move(value)); return *this;}

    /**
     * <p>The route ID.</p>
     */
    inline UpdateRouteResult& WithRouteId(const char* value) { SetRouteId(value); return *this;}


    /**
     * <p>The route key for the route.</p>
     */
    inline const Aws::String& GetRouteKey() const{ return m_routeKey; }

    /**
     * <p>The route key for the route.</p>
     */
    inline void SetRouteKey(const Aws::String& value) { m_routeKey = value; }

    /**
     * <p>The route key for the route.</p>
     */
    inline void SetRouteKey(Aws::String&& value) { m_routeKey = std::move(value); }

    /**
     * <p>The route key for the route.</p>
     */
    inline void SetRouteKey(const char* value) { m_routeKey.assign(value); }

    /**
     * <p>The route key for the route.</p>
     */
    inline UpdateRouteResult& WithRouteKey(const Aws::String& value) { SetRouteKey(value); return *this;}

    /**
     * <p>The route key for the route.</p>
     */
    inline UpdateRouteResult& WithRouteKey(Aws::String&& value) { SetRouteKey(std::move(value)); return *this;}

    /**
     * <p>The route key for the route.</p>
     */
    inline UpdateRouteResult& WithRouteKey(const char* value) { SetRouteKey(value); return *this;}


    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline const Aws::String& GetRouteResponseSelectionExpression() const{ return m_routeResponseSelectionExpression; }

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline void SetRouteResponseSelectionExpression(const Aws::String& value) { m_routeResponseSelectionExpression = value; }

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline void SetRouteResponseSelectionExpression(Aws::String&& value) { m_routeResponseSelectionExpression = std::move(value); }

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline void SetRouteResponseSelectionExpression(const char* value) { m_routeResponseSelectionExpression.assign(value); }

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRouteResponseSelectionExpression(const Aws::String& value) { SetRouteResponseSelectionExpression(value); return *this;}

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRouteResponseSelectionExpression(Aws::String&& value) { SetRouteResponseSelectionExpression(std::move(value)); return *this;}

    /**
     * <p>The route response selection expression for the route. Supported only for
     * WebSocket APIs.</p>
     */
    inline UpdateRouteResult& WithRouteResponseSelectionExpression(const char* value) { SetRouteResponseSelectionExpression(value); return *this;}


    /**
     * <p>The target for the route.</p>
     */
    inline const Aws::String& GetTarget() const{ return m_target; }

    /**
     * <p>The target for the route.</p>
     */
    inline void SetTarget(const Aws::String& value) { m_target = value; }

    /**
     * <p>The target for the route.</p>
     */
    inline void SetTarget(Aws::String&& value) { m_target = std::move(value); }

    /**
     * <p>The target for the route.</p>
     */
    inline void SetTarget(const char* value) { m_target.assign(value); }

    /**
     * <p>The target for the route.</p>
     */
    inline UpdateRouteResult& WithTarget(const Aws::String& value) { SetTarget(value); return *this;}

    /**
     * <p>The target for the route.</p>
     */
    inline UpdateRouteResult& WithTarget(Aws::String&& value) { SetTarget(std::move(value)); return *this;}

    /**
     * <p>The target for the route.</p>
     */
    inline UpdateRouteResult& WithTarget(const char* value) { SetTarget(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline UpdateRouteResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline UpdateRouteResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline UpdateRouteResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    bool m_apiGatewayManaged;

    bool m_apiKeyRequired;

    Aws::Vector<Aws::String> m_authorizationScopes;

    AuthorizationType m_authorizationType;

    Aws::String m_authorizerId;

    Aws::String m_modelSelectionExpression;

    Aws::String m_operationName;

    Aws::Map<Aws::String, Aws::String> m_requestModels;

    Aws::Map<Aws::String, ParameterConstraints> m_requestParameters;

    Aws::String m_routeId;

    Aws::String m_routeKey;

    Aws::String m_routeResponseSelectionExpression;

    Aws::String m_target;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ApiGatewayV2
} // namespace Aws
