/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.util.Collections;
import java.util.List;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.jspecify.annotations.Nullable;

public class BuildCompletionNotifyingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;
    private final FailureFactory failureFactory;

    public BuildCompletionNotifyingBuildActionRunner(GradleEnterprisePluginManager gradleEnterprisePluginManager, FailureFactory failureFactory, BuildActionRunner delegate) {
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
        this.failureFactory = failureFactory;
        this.delegate = delegate;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        BuildActionRunner.Result result;
        try {
            result = this.delegate.run(action, buildController);
        }
        catch (Throwable t) {
            this.notifyEnterprisePluginManager(BuildActionRunner.Result.failed((Throwable)t, (Failure)this.failureFactory.create(t)));
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        this.notifyEnterprisePluginManager(result);
        return result;
    }

    private void notifyEnterprisePluginManager(BuildActionRunner.Result result) {
        assert (result.getBuildFailure() == null || result.getRichBuildFailure() != null) : "Rich build failure must not be null when build failure is present. Build failure: " + result.getBuildFailure();
        List<Failure> unwrappedBuildFailure = BuildCompletionNotifyingBuildActionRunner.unwrapBuildFailure(result.getRichBuildFailure());
        this.gradleEnterprisePluginManager.buildFinished(result.getBuildFailure(), unwrappedBuildFailure);
    }

    private static @Nullable List<Failure> unwrapBuildFailure(@Nullable Failure richBuildFailure) {
        if (richBuildFailure == null) {
            return null;
        }
        return richBuildFailure.getOriginal() instanceof MultipleBuildFailures ? richBuildFailure.getCauses() : Collections.singletonList(richBuildFailure);
    }
}

