﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/macie2/Macie2Request.h>
#include <aws/macie2/Macie2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Macie2 {
namespace Model {

/**
 */
class ListMembersRequest : public Macie2Request {
 public:
  AWS_MACIE2_API ListMembersRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListMembers"; }

  AWS_MACIE2_API Aws::String SerializePayload() const override;

  AWS_MACIE2_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The maximum number of items to include in each page of a paginated
   * response.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListMembersRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The nextToken string that specifies which page of results to return in a
   * paginated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListMembersRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies which accounts to include in the response, based on the status of
   * an account's relationship with the administrator account. By default, the
   * response includes only current member accounts. To include all accounts, set
   * this value to false.</p>
   */
  inline const Aws::String& GetOnlyAssociated() const { return m_onlyAssociated; }
  inline bool OnlyAssociatedHasBeenSet() const { return m_onlyAssociatedHasBeenSet; }
  template <typename OnlyAssociatedT = Aws::String>
  void SetOnlyAssociated(OnlyAssociatedT&& value) {
    m_onlyAssociatedHasBeenSet = true;
    m_onlyAssociated = std::forward<OnlyAssociatedT>(value);
  }
  template <typename OnlyAssociatedT = Aws::String>
  ListMembersRequest& WithOnlyAssociated(OnlyAssociatedT&& value) {
    SetOnlyAssociated(std::forward<OnlyAssociatedT>(value));
    return *this;
  }
  ///@}
 private:
  int m_maxResults{0};

  Aws::String m_nextToken;

  Aws::String m_onlyAssociated;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_onlyAssociatedHasBeenSet = false;
};

}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
