/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String preparedRoles = null;
    private String preparedCredentials = null;
    protected String dataSourceName = null;
    protected boolean localDataSource = false;
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;
    private volatile boolean connectionSuccess = true;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean bl) {
        this.localDataSource = bl;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            Principal principal = this.authenticate(connection, string, string2);
            return principal;
        }
        finally {
            this.close(connection);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionSuccess;
    }

    protected Principal authenticate(Connection connection, String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(connection, string);
        if (string3 == null) {
            this.getCredentialHandler().mutate(string2);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.getCredentialHandler().matches(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateSuccess", new Object[]{string}));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        ArrayList<String> arrayList = this.getRoles(connection, string);
        return new GenericPrincipal(string, string2, arrayList);
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.commit"), (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.close"), (Throwable)sQLException);
        }
    }

    protected Connection open() {
        try {
            Object object;
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                object = this.getServer();
                if (object == null) {
                    this.connectionSuccess = false;
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.noNamingContext"));
                    return null;
                }
                context = object.getGlobalNamingContext();
            }
            object = (DataSource)context.lookup(this.dataSourceName);
            Connection connection = object.getConnection();
            this.connectionSuccess = true;
            return connection;
        }
        catch (Exception exception) {
            this.connectionSuccess = false;
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getPassword(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            String string2 = this.getPassword(connection, string);
            return string2;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String getPassword(Connection connection, String string) {
        String string2 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.preparedCredentials);){
            String string3;
            block15: {
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    String string4 = string3 = string2 != null ? string2.trim() : null;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return string3;
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", new Object[]{string}), (Throwable)sQLException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Principal getPrincipal(String string) {
        Connection connection = this.open();
        if (connection == null) {
            return new GenericPrincipal(string, null, null);
        }
        try {
            GenericPrincipal genericPrincipal = new GenericPrincipal(string, this.getPassword(connection, string), this.getRoles(connection, string));
            return genericPrincipal;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getRoles(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            ArrayList<String> arrayList = this.getRoles(connection, string);
            return arrayList;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ArrayList<String> getRoles(Connection connection, String string) {
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !this.isRoleStoreDefined()) {
            return null;
        }
        ArrayList<String> arrayList = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.preparedRoles);){
            Object object;
            block16: {
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    arrayList = new ArrayList<String>();
                    while (resultSet.next()) {
                        object = resultSet.getString(1);
                        if (object == null) continue;
                        arrayList.add(((String)object).trim());
                    }
                    object = arrayList;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return object;
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", new Object[]{string}), (Throwable)sQLException);
            return null;
        }
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.roleNameCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userRoleTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedRoles = stringBuilder.toString();
        stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.userCredCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedCredentials = stringBuilder.toString();
        super.startInternal();
    }
}

