/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ClasspathScanner;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Pattern VM_INTERNAL_OBJECT_ARRAY_PATTERN = Pattern.compile("^(\\[+)L(.+);$");
    private static final Pattern VM_INTERNAL_PRIMITIVE_ARRAY_PATTERN = Pattern.compile("^(\\[+)(\\[[ZBCDFIJS])$");
    private static final Pattern SOURCE_CODE_SYNTAX_ARRAY_PATTERN = Pattern.compile("^([^\\[\\]]+)((?>\\[\\])++)$");
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ClasspathScanner classpathScanner = new ClasspathScanner(ClassLoaderUtils::getDefaultClassLoader, ReflectionUtils::tryToLoadClass);
    private static final Set<String> noCyclesDetectedCache = ConcurrentHashMap.newKeySet();
    private static final Map<String, Class<?>> classNameToTypeMap;
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap;

    private ReflectionUtils() {
    }

    public static boolean isPublic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isPrivate(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static boolean isNotPrivate(Class<?> clazz) {
        return !ReflectionUtils.isPrivate(clazz);
    }

    @API(status=API.Status.INTERNAL, since="1.1")
    public static boolean isNotPrivate(Member member) {
        return !ReflectionUtils.isPrivate(member);
    }

    public static boolean isAbstract(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isStatic(clazz.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static boolean isNotStatic(Class<?> clazz) {
        return !ReflectionUtils.isStatic(clazz);
    }

    public static boolean isStatic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isStatic(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.1")
    public static boolean isNotStatic(Member member) {
        return !ReflectionUtils.isStatic(member);
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isFinal(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isFinal(clazz.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isNotFinal(Class<?> clazz) {
        return !ReflectionUtils.isFinal(clazz);
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isFinal(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isFinal(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isNotFinal(Member member) {
        return !ReflectionUtils.isFinal(member);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return !ReflectionUtils.isStatic(clazz) && clazz.isMemberClass();
    }

    public static boolean returnsVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    @API(status=API.Status.INTERNAL, since="1.3.2")
    public static boolean isMultidimensionalArray(Object obj) {
        return obj != null && obj.getClass().isArray() && obj.getClass().getComponentType().isArray();
    }

    public static boolean isAssignableTo(Class<?> sourceType, Class<?> targetType) {
        Preconditions.notNull(sourceType, "source type must not be null");
        Preconditions.condition(!sourceType.isPrimitive(), "source type must not be a primitive type");
        Preconditions.notNull(targetType, "target type must not be null");
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return sourceType == primitiveToWrapperMap.get(targetType) || ReflectionUtils.isWideningConversion(sourceType, targetType);
        }
        return false;
    }

    public static boolean isAssignableTo(Object obj, Class<?> targetType) {
        Preconditions.notNull(targetType, "target type must not be null");
        if (obj == null) {
            return !targetType.isPrimitive();
        }
        if (targetType.isInstance(obj)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> sourceType = obj.getClass();
            return sourceType == primitiveToWrapperMap.get(targetType) || ReflectionUtils.isWideningConversion(sourceType, targetType);
        }
        return false;
    }

    static boolean isWideningConversion(Class<?> sourceType, Class<?> targetType) {
        Preconditions.condition(targetType.isPrimitive(), "targetType must be primitive");
        boolean isPrimitive = sourceType.isPrimitive();
        boolean isWrapper = primitiveToWrapperMap.containsValue(sourceType);
        if (!isPrimitive && !isWrapper) {
            return false;
        }
        if (isPrimitive) {
            sourceType = primitiveToWrapperMap.get(sourceType);
        }
        if (sourceType == Byte.class) {
            return targetType == Short.TYPE || targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Short.class || sourceType == Character.class) {
            return targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Integer.class) {
            return targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Long.class) {
            return targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Float.class) {
            return targetType == Double.TYPE;
        }
        return false;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return primitiveToWrapperMap.get(type);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(args, "Argument array must not be null");
        Preconditions.containsNoNullElements(args, "Individual arguments must not be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            return ReflectionUtils.newInstance(clazz.getDeclaredConstructor(parameterTypes), args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        Preconditions.notNull(constructor, "Constructor must not be null");
        try {
            return ReflectionUtils.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static <T> Optional<Object> readFieldValue(Class<T> clazz, String fieldName, T instance) {
        return ReflectionUtils.tryToReadFieldValue(clazz, fieldName, instance).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static <T> Try<Object> tryToReadFieldValue(Class<T> clazz, String fieldName, T instance) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(fieldName, "Field name must not be null or blank");
        return Try.call(() -> clazz.getDeclaredField(fieldName)).andThen(field -> ReflectionUtils.tryToReadFieldValue(field, instance));
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Object> readFieldValue(Field field) {
        return ReflectionUtils.tryToReadFieldValue(field).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Object> tryToReadFieldValue(Field field) {
        return ReflectionUtils.tryToReadFieldValue(field, null);
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Object> readFieldValue(Field field, Object instance) {
        return ReflectionUtils.tryToReadFieldValue(field, instance).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Object> tryToReadFieldValue(Field field, Object instance) {
        Preconditions.notNull(field, "Field must not be null");
        Preconditions.condition(instance != null || ReflectionUtils.isStatic(field), () -> String.format("Cannot read non-static field [%s] on a null instance.", field));
        return Try.call(() -> ReflectionUtils.makeAccessible(field).get(instance));
    }

    public static List<Object> readFieldValues(List<Field> fields, Object instance) {
        return ReflectionUtils.readFieldValues(fields, instance, field -> true);
    }

    public static List<Object> readFieldValues(List<Field> fields, Object instance, Predicate<Field> predicate) {
        Preconditions.notNull(fields, "fields list must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        return fields.stream().filter(predicate).map(field -> ReflectionUtils.tryToReadFieldValue(field, instance).getOrThrow(ExceptionUtils::throwAsUncheckedException)).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Preconditions.notNull(method, "Method must not be null");
        Preconditions.condition(target != null || ReflectionUtils.isStatic(method), () -> String.format("Cannot invoke non-static method [%s] on a null target.", method.toGenericString()));
        try {
            return ReflectionUtils.makeAccessible(method).invoke(target, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Class<?>> loadClass(String name, ClassLoader classLoader) {
        return ReflectionUtils.tryToLoadClass(name, classLoader).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name, ClassLoader classLoader) {
        Preconditions.notBlank(name, "Class name must not be null or blank");
        Preconditions.notNull(classLoader, "ClassLoader must not be null");
        String trimmedName = name.trim();
        if (classNameToTypeMap.containsKey(trimmedName)) {
            return Try.success(classNameToTypeMap.get(trimmedName));
        }
        return Try.call(() -> {
            Matcher matcher = VM_INTERNAL_PRIMITIVE_ARRAY_PATTERN.matcher(trimmedName);
            if (matcher.matches()) {
                String brackets = matcher.group(1);
                String componentTypeName = matcher.group(2);
                int dimensions = brackets.length();
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            matcher = VM_INTERNAL_OBJECT_ARRAY_PATTERN.matcher(trimmedName);
            if (matcher.matches()) {
                String brackets = matcher.group(1);
                String componentTypeName = matcher.group(2);
                int dimensions = brackets.length();
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            matcher = SOURCE_CODE_SYNTAX_ARRAY_PATTERN.matcher(trimmedName);
            if (matcher.matches()) {
                String componentTypeName = matcher.group(1);
                String bracketPairs = matcher.group(2);
                int dimensions = bracketPairs.length() / 2;
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            return Class.forName(trimmedName, false, classLoader);
        });
    }

    private static Class<?> loadArrayType(ClassLoader classLoader, String componentTypeName, int dimensions) throws ClassNotFoundException {
        Class<?> componentType = classNameToTypeMap.containsKey(componentTypeName) ? classNameToTypeMap.get(componentTypeName) : Class.forName(componentTypeName, false, classLoader);
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static String getFullyQualifiedMethodName(Class<?> clazz, Method method) {
        Preconditions.notNull(method, "Method must not be null");
        return ReflectionUtils.getFullyQualifiedMethodName(clazz, method.getName(), method.getParameterTypes());
    }

    public static String getFullyQualifiedMethodName(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return String.format("%s#%s(%s)", clazz.getName(), methodName, ClassUtils.nullSafeToString(parameterTypes));
    }

    public static String[] parseFullyQualifiedMethodName(String fullyQualifiedMethodName) {
        int indexOfLastOpeningParenthesis;
        String methodPart;
        Preconditions.notBlank(fullyQualifiedMethodName, "fullyQualifiedMethodName must not be null or blank");
        int indexOfFirstHashtag = fullyQualifiedMethodName.indexOf(35);
        boolean validSyntax = indexOfFirstHashtag > 0 && indexOfFirstHashtag < fullyQualifiedMethodName.length() - 1;
        Preconditions.condition(validSyntax, () -> "[" + fullyQualifiedMethodName + "] is not a valid fully qualified method name: it must start with a fully qualified class name followed by a '#' and then the method name, optionally followed by a parameter list enclosed in parentheses.");
        String className = fullyQualifiedMethodName.substring(0, indexOfFirstHashtag);
        String methodName = methodPart = fullyQualifiedMethodName.substring(indexOfFirstHashtag + 1);
        String methodParameters = "";
        if (methodPart.endsWith("()")) {
            methodName = methodPart.substring(0, methodPart.length() - 2);
        } else if (methodPart.endsWith(")") && (indexOfLastOpeningParenthesis = methodPart.lastIndexOf(40)) > 0 && indexOfLastOpeningParenthesis < methodPart.length() - 1) {
            methodName = methodPart.substring(0, indexOfLastOpeningParenthesis);
            methodParameters = methodPart.substring(indexOfLastOpeningParenthesis + 1, methodPart.length() - 1);
        }
        return new String[]{className, methodName, methodParameters};
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Object> getOutermostInstance(Object inner, Class<?> requiredType) {
        Preconditions.notNull(inner, "inner object must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        if (requiredType.isInstance(inner)) {
            return Optional.of(inner);
        }
        Optional<Object> candidate = ReflectionUtils.getOuterInstance(inner);
        if (candidate.isPresent()) {
            return ReflectionUtils.getOutermostInstance(candidate.get(), requiredType);
        }
        return Optional.empty();
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return ReflectionUtils.makeAccessible(field).get(inner);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException(t);
            }
        });
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String fullClassPath = System.getProperty("java.class.path");
        return Arrays.stream(fullClassPath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInClasspathRoot(root, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, ClassFilter classFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInClasspathRoot(root, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInClasspathRoot(URI root, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, classFilter).stream();
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInPackage(basePackageName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, ClassFilter classFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInPackage(basePackageName, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInPackage(String basePackageName, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, classFilter).stream();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInModule(moduleName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter classFilter) {
        return Collections.unmodifiableList(ModuleUtils.findAllClassesInModule(moduleName, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInModule(String moduleName, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, classFilter).stream();
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        LinkedHashSet candidates = new LinkedHashSet();
        ReflectionUtils.findNestedClasses(clazz, predicate, candidates);
        return Collections.unmodifiableList(new ArrayList(candidates));
    }

    public static Stream<Class<?>> streamNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        return ReflectionUtils.findNestedClasses(clazz, predicate).stream();
    }

    private static void findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate, Set<Class<?>> candidates) {
        if (!ReflectionUtils.isSearchable(clazz)) {
            return;
        }
        if (ReflectionUtils.isInnerClass(clazz) && predicate.test(clazz)) {
            ReflectionUtils.detectInnerClassCycle(clazz);
        }
        try {
            for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
                if (!predicate.test(nestedClass)) continue;
                ReflectionUtils.detectInnerClassCycle(nestedClass);
                candidates.add(nestedClass);
            }
        }
        catch (NoClassDefFoundError error) {
            logger.debug(error, () -> "Failed to retrieve declared classes for " + clazz.getName());
        }
        ReflectionUtils.findNestedClasses(clazz.getSuperclass(), predicate, candidates);
        for (Class<?> ifc : clazz.getInterfaces()) {
            ReflectionUtils.findNestedClasses(ifc, predicate, candidates);
        }
    }

    private static void detectInnerClassCycle(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        if (noCyclesDetectedCache.contains(className)) {
            return;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (ReflectionUtils.isInnerClass(clazz) && ReflectionUtils.isSearchable(superclass)) {
            for (Class<?> enclosing = clazz.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                if (!superclass.equals(enclosing)) continue;
                throw new JUnitException(String.format("Detected cycle in inner class hierarchy between %s and %s", className, enclosing.getName()));
            }
        }
        noCyclesDetectedCache.add(className);
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        try {
            List constructors = Arrays.stream(clazz.getDeclaredConstructors()).filter(ctor -> !ctor.isSynthetic()).collect(Collectors.toList());
            Preconditions.condition(constructors.size() == 1, () -> String.format("Class [%s] must declare a single constructor", clazz.getName()));
            return (Constructor)constructors.get(0);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static List<Constructor<?>> findConstructors(Class<?> clazz, Predicate<Constructor<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        try {
            return Arrays.stream(clazz.getDeclaredConstructors()).filter(predicate).collect(CollectionUtils.toUnmodifiableList());
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        return ReflectionUtils.streamFields(clazz, predicate, traversalMode).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Stream<Field> streamFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findAllFieldsInHierarchy(clazz, predicate, traversalMode).stream();
    }

    private static List<Field> findAllFieldsInHierarchy(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        List localFields = ReflectionUtils.getDeclaredFields(clazz, predicate).stream().filter(field -> !field.isSynthetic()).collect(Collectors.toList());
        List superclassFields = ReflectionUtils.getSuperclassFields(clazz, predicate, traversalMode).stream().filter(field -> !ReflectionUtils.isFieldShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        List interfaceFields = ReflectionUtils.getInterfaceFields(clazz, predicate, traversalMode).stream().filter(field -> !ReflectionUtils.isFieldShadowedByLocalFields(field, localFields)).collect(Collectors.toList());
        ArrayList<Field> fields = new ArrayList<Field>();
        if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
            fields.addAll(superclassFields);
            fields.addAll(interfaceFields);
        }
        fields.addAll(localFields);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            fields.addAll(interfaceFields);
            fields.addAll(superclassFields);
        }
        return fields;
    }

    public static boolean isMethodPresent(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        return ReflectionUtils.findMethod(clazz, predicate).isPresent();
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    static Optional<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.tryToGetMethod(clazz, methodName, parameterTypes).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Method> tryToGetMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return Try.call(() -> clazz.getMethod(methodName, parameterTypes));
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, String parameterTypeNames) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return ReflectionUtils.findMethod(clazz, methodName, ReflectionUtils.resolveParameterTypes(clazz, methodName, parameterTypeNames));
    }

    @API(status=API.Status.INTERNAL, since="1.10")
    public static Class<?>[] resolveParameterTypes(Class<?> clazz, String methodName, String parameterTypeNames) {
        if (StringUtils.isBlank(parameterTypeNames)) {
            return EMPTY_CLASS_ARRAY;
        }
        return (Class[])Arrays.stream(parameterTypeNames.split(",")).map(String::trim).map(typeName -> ReflectionUtils.loadRequiredParameterType(clazz, methodName, typeName)).toArray(Class[]::new);
    }

    private static Class<?> loadRequiredParameterType(Class<?> clazz, String methodName, String typeName) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(clazz);
        return ReflectionUtils.tryToLoadClass(typeName, classLoader).getOrThrow(cause -> new JUnitException(String.format("Failed to load parameter type [%s] for method [%s] in class [%s].", typeName, methodName, clazz.getName()), (Throwable)cause));
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Individual parameter types must not be null");
        return ReflectionUtils.findMethod(clazz, method -> ReflectionUtils.hasCompatibleSignature(method, methodName, parameterTypes));
    }

    private static Optional<Method> findMethod(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Class<?> current = clazz;
        while (ReflectionUtils.isSearchable(current)) {
            List<Method> methods;
            List<Method> list = methods = current.isInterface() ? ReflectionUtils.getMethods(current, predicate) : ReflectionUtils.getDeclaredMethods(current, predicate, HierarchyTraversalMode.BOTTOM_UP);
            if (!methods.isEmpty()) {
                return Optional.of(methods.get(0));
            }
            for (Class<?> ifc : current.getInterfaces()) {
                Optional<Method> optional = ReflectionUtils.findMethod(ifc, predicate);
                if (!optional.isPresent()) continue;
                return optional;
            }
            current = current.getSuperclass();
        }
        return Optional.empty();
    }

    @API(status=API.Status.STABLE, since="1.7")
    public static Method getRequiredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes).orElseThrow(() -> new JUnitException(String.format("Could not find method [%s] in class [%s]", methodName, clazz.getName())));
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.findMethods(clazz, predicate, HierarchyTraversalMode.TOP_DOWN);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        return ReflectionUtils.streamMethods(clazz, predicate, traversalMode).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Stream<Method> streamMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findAllMethodsInHierarchy(clazz, predicate, traversalMode).stream().distinct();
    }

    private static List<Method> findAllMethodsInHierarchy(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        List localMethods = ReflectionUtils.getDeclaredMethods(clazz, predicate, traversalMode).stream().filter(method -> !method.isSynthetic()).collect(Collectors.toList());
        List superclassMethods = ReflectionUtils.getSuperclassMethods(clazz, predicate, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        List interfaceMethods = ReflectionUtils.getInterfaceMethods(clazz, predicate, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        ArrayList<Method> methods = new ArrayList<Method>();
        if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
            methods.addAll(superclassMethods);
            methods.addAll(interfaceMethods);
        }
        methods.addAll(localMethods);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            methods.addAll(interfaceMethods);
            methods.addAll(superclassMethods);
        }
        return methods;
    }

    private static List<Field> getFields(Class<?> clazz, Predicate<Field> predicate) {
        return ReflectionUtils.toSortedMutableList(clazz.getFields(), predicate);
    }

    private static List<Field> getDeclaredFields(Class<?> clazz, Predicate<Field> predicate) {
        return ReflectionUtils.toSortedMutableList(clazz.getDeclaredFields(), predicate);
    }

    private static List<Method> getMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.toSortedMutableList(clazz.getMethods(), predicate);
    }

    private static List<Method> getDeclaredMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        List<Method> defaultMethods = ReflectionUtils.getDefaultMethods(clazz, predicate);
        List<Method> declaredMethods = ReflectionUtils.toSortedMutableList(clazz.getDeclaredMethods(), predicate);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            declaredMethods.addAll(defaultMethods);
            return declaredMethods;
        }
        defaultMethods.addAll(declaredMethods);
        return defaultMethods;
    }

    private static List<Method> getDefaultMethods(Class<?> clazz, Predicate<Method> predicate) {
        List visibleDefaultMethods = Arrays.stream(clazz.getMethods()).filter(predicate.and(Method::isDefault)).collect(Collectors.toCollection(ArrayList::new));
        if (visibleDefaultMethods.isEmpty()) {
            return visibleDefaultMethods;
        }
        return Arrays.stream(clazz.getInterfaces()).map(ifc -> ReflectionUtils.getMethods(ifc, predicate)).flatMap(Collection::stream).filter(visibleDefaultMethods::contains).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Field> toSortedMutableList(Field[] fields, Predicate<Field> predicate) {
        return Arrays.stream(fields).filter(predicate).sorted(ReflectionUtils::defaultFieldSorter).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Method> toSortedMutableList(Method[] methods, Predicate<Method> predicate) {
        return Arrays.stream(methods).filter(predicate).sorted(ReflectionUtils::defaultMethodSorter).collect(Collectors.toCollection(ArrayList::new));
    }

    private static int defaultFieldSorter(Field field1, Field field2) {
        return Integer.compare(field1.getName().hashCode(), field2.getName().hashCode());
    }

    private static int defaultMethodSorter(Method method1, Method method2) {
        String name1 = method1.getName();
        String name2 = method2.getName();
        int comparison = Integer.compare(name1.hashCode(), name2.hashCode());
        if (comparison == 0 && (comparison = name1.compareTo(name2)) == 0) {
            comparison = method1.toString().compareTo(method2.toString());
        }
        return comparison;
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        ArrayList<Method> allInterfaceMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List localInterfaceMethods = ReflectionUtils.getMethods(ifc, predicate).stream().filter(method -> !ReflectionUtils.isAbstract(method)).collect(Collectors.toList());
            List superinterfaceMethods = ReflectionUtils.getInterfaceMethods(ifc, predicate, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localInterfaceMethods)).collect(Collectors.toList());
            if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
                allInterfaceMethods.addAll(superinterfaceMethods);
            }
            allInterfaceMethods.addAll(localInterfaceMethods);
            if (traversalMode != HierarchyTraversalMode.BOTTOM_UP) continue;
            allInterfaceMethods.addAll(superinterfaceMethods);
        }
        return allInterfaceMethods;
    }

    private static List<Field> getInterfaceFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        ArrayList<Field> allInterfaceFields = new ArrayList<Field>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List<Field> localInterfaceFields = ReflectionUtils.getFields(ifc, predicate);
            List superinterfaceFields = ReflectionUtils.getInterfaceFields(ifc, predicate, traversalMode).stream().filter(field -> !ReflectionUtils.isFieldShadowedByLocalFields(field, localInterfaceFields)).collect(Collectors.toList());
            if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
                allInterfaceFields.addAll(superinterfaceFields);
            }
            allInterfaceFields.addAll(localInterfaceFields);
            if (traversalMode != HierarchyTraversalMode.BOTTOM_UP) continue;
            allInterfaceFields.addAll(superinterfaceFields);
        }
        return allInterfaceFields;
    }

    private static List<Field> getSuperclassFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Class<?> superclass = clazz.getSuperclass();
        if (!ReflectionUtils.isSearchable(superclass)) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllFieldsInHierarchy(superclass, predicate, traversalMode);
    }

    private static boolean isFieldShadowedByLocalFields(Field field, List<Field> localFields) {
        return localFields.stream().anyMatch(local -> local.getName().equals(field.getName()));
    }

    private static List<Method> getSuperclassMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Class<?> superclass = clazz.getSuperclass();
        if (!ReflectionUtils.isSearchable(superclass)) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllMethodsInHierarchy(superclass, predicate, traversalMode);
    }

    private static boolean isMethodShadowedByLocalMethods(Method method, List<Method> localMethods) {
        return localMethods.stream().anyMatch(local -> ReflectionUtils.isMethodShadowedBy(method, local));
    }

    private static boolean isMethodShadowedBy(Method upper, Method lower) {
        return ReflectionUtils.hasCompatibleSignature(upper, lower.getName(), lower.getParameterTypes());
    }

    private static boolean hasCompatibleSignature(Method candidate, String methodName, Class<?>[] parameterTypes) {
        if (!methodName.equals(candidate.getName())) {
            return false;
        }
        if (parameterTypes.length != candidate.getParameterCount()) {
            return false;
        }
        if (Arrays.equals(parameterTypes, candidate.getParameterTypes())) {
            return true;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> lowerType = parameterTypes[i];
            Class<?> upperType = candidate.getParameterTypes()[i];
            if (upperType.isAssignableFrom(lowerType)) continue;
            return false;
        }
        return ReflectionUtils.isGeneric(candidate);
    }

    static boolean isGeneric(Method method) {
        return ReflectionUtils.isGeneric(method.getGenericReturnType()) || Arrays.stream(method.getGenericParameterTypes()).anyMatch(ReflectionUtils::isGeneric);
    }

    private static boolean isGeneric(Type type) {
        return type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    public static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static Set<Class<?>> getAllAssignmentCompatibleClasses(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        LinkedHashSet result = new LinkedHashSet();
        ReflectionUtils.getAllAssignmentCompatibleClasses(clazz, result);
        return result;
    }

    private static void getAllAssignmentCompatibleClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (result.contains(interfaceClass)) continue;
                ReflectionUtils.getAllAssignmentCompatibleClasses(interfaceClass, result);
            }
        }
    }

    private static boolean isSearchable(Class<?> clazz) {
        return clazz != null && clazz != Object.class;
    }

    private static Throwable getUnderlyingCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ReflectionUtils.getUnderlyingCause(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }

    static {
        List<Class> commonTypes = Arrays.asList(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[][].class, byte[][].class, char[][].class, short[][].class, int[][].class, long[][].class, float[][].class, double[][].class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Boolean[].class, Byte[].class, Character[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, String[].class, Boolean[][].class, Byte[][].class, Character[][].class, Short[][].class, Integer[][].class, Long[][].class, Float[][].class, Double[][].class, String[][].class);
        HashMap classNamesToTypes = new HashMap(64);
        commonTypes.forEach(type -> {
            classNamesToTypes.put(type.getName(), type);
            classNamesToTypes.put(type.getCanonicalName(), type);
        });
        classNameToTypeMap = Collections.unmodifiableMap(classNamesToTypes);
        IdentityHashMap<Class<Comparable<Boolean>>, Class> primitivesToWrappers = new IdentityHashMap<Class<Comparable<Boolean>>, Class>(8);
        primitivesToWrappers.put(Boolean.TYPE, Boolean.class);
        primitivesToWrappers.put(Byte.TYPE, Byte.class);
        primitivesToWrappers.put(Character.TYPE, Character.class);
        primitivesToWrappers.put(Short.TYPE, Short.class);
        primitivesToWrappers.put(Integer.TYPE, Integer.class);
        primitivesToWrappers.put(Long.TYPE, Long.class);
        primitivesToWrappers.put(Float.TYPE, Float.class);
        primitivesToWrappers.put(Double.TYPE, Double.class);
        primitiveToWrapperMap = Collections.unmodifiableMap(primitivesToWrappers);
    }

    public static enum HierarchyTraversalMode {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

