﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>Metadata properties of the tracking entity, trial, or trial
   * component.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MetadataProperties">AWS
   * API Reference</a></p>
   */
  class MetadataProperties
  {
  public:
    AWS_SAGEMAKER_API MetadataProperties();
    AWS_SAGEMAKER_API MetadataProperties(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API MetadataProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The commit ID.</p>
     */
    inline const Aws::String& GetCommitId() const{ return m_commitId; }

    /**
     * <p>The commit ID.</p>
     */
    inline bool CommitIdHasBeenSet() const { return m_commitIdHasBeenSet; }

    /**
     * <p>The commit ID.</p>
     */
    inline void SetCommitId(const Aws::String& value) { m_commitIdHasBeenSet = true; m_commitId = value; }

    /**
     * <p>The commit ID.</p>
     */
    inline void SetCommitId(Aws::String&& value) { m_commitIdHasBeenSet = true; m_commitId = std::move(value); }

    /**
     * <p>The commit ID.</p>
     */
    inline void SetCommitId(const char* value) { m_commitIdHasBeenSet = true; m_commitId.assign(value); }

    /**
     * <p>The commit ID.</p>
     */
    inline MetadataProperties& WithCommitId(const Aws::String& value) { SetCommitId(value); return *this;}

    /**
     * <p>The commit ID.</p>
     */
    inline MetadataProperties& WithCommitId(Aws::String&& value) { SetCommitId(std::move(value)); return *this;}

    /**
     * <p>The commit ID.</p>
     */
    inline MetadataProperties& WithCommitId(const char* value) { SetCommitId(value); return *this;}


    /**
     * <p>The repository.</p>
     */
    inline const Aws::String& GetRepository() const{ return m_repository; }

    /**
     * <p>The repository.</p>
     */
    inline bool RepositoryHasBeenSet() const { return m_repositoryHasBeenSet; }

    /**
     * <p>The repository.</p>
     */
    inline void SetRepository(const Aws::String& value) { m_repositoryHasBeenSet = true; m_repository = value; }

    /**
     * <p>The repository.</p>
     */
    inline void SetRepository(Aws::String&& value) { m_repositoryHasBeenSet = true; m_repository = std::move(value); }

    /**
     * <p>The repository.</p>
     */
    inline void SetRepository(const char* value) { m_repositoryHasBeenSet = true; m_repository.assign(value); }

    /**
     * <p>The repository.</p>
     */
    inline MetadataProperties& WithRepository(const Aws::String& value) { SetRepository(value); return *this;}

    /**
     * <p>The repository.</p>
     */
    inline MetadataProperties& WithRepository(Aws::String&& value) { SetRepository(std::move(value)); return *this;}

    /**
     * <p>The repository.</p>
     */
    inline MetadataProperties& WithRepository(const char* value) { SetRepository(value); return *this;}


    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline const Aws::String& GetGeneratedBy() const{ return m_generatedBy; }

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline bool GeneratedByHasBeenSet() const { return m_generatedByHasBeenSet; }

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline void SetGeneratedBy(const Aws::String& value) { m_generatedByHasBeenSet = true; m_generatedBy = value; }

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline void SetGeneratedBy(Aws::String&& value) { m_generatedByHasBeenSet = true; m_generatedBy = std::move(value); }

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline void SetGeneratedBy(const char* value) { m_generatedByHasBeenSet = true; m_generatedBy.assign(value); }

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline MetadataProperties& WithGeneratedBy(const Aws::String& value) { SetGeneratedBy(value); return *this;}

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline MetadataProperties& WithGeneratedBy(Aws::String&& value) { SetGeneratedBy(std::move(value)); return *this;}

    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline MetadataProperties& WithGeneratedBy(const char* value) { SetGeneratedBy(value); return *this;}


    /**
     * <p>The project ID.</p>
     */
    inline const Aws::String& GetProjectId() const{ return m_projectId; }

    /**
     * <p>The project ID.</p>
     */
    inline bool ProjectIdHasBeenSet() const { return m_projectIdHasBeenSet; }

    /**
     * <p>The project ID.</p>
     */
    inline void SetProjectId(const Aws::String& value) { m_projectIdHasBeenSet = true; m_projectId = value; }

    /**
     * <p>The project ID.</p>
     */
    inline void SetProjectId(Aws::String&& value) { m_projectIdHasBeenSet = true; m_projectId = std::move(value); }

    /**
     * <p>The project ID.</p>
     */
    inline void SetProjectId(const char* value) { m_projectIdHasBeenSet = true; m_projectId.assign(value); }

    /**
     * <p>The project ID.</p>
     */
    inline MetadataProperties& WithProjectId(const Aws::String& value) { SetProjectId(value); return *this;}

    /**
     * <p>The project ID.</p>
     */
    inline MetadataProperties& WithProjectId(Aws::String&& value) { SetProjectId(std::move(value)); return *this;}

    /**
     * <p>The project ID.</p>
     */
    inline MetadataProperties& WithProjectId(const char* value) { SetProjectId(value); return *this;}

  private:

    Aws::String m_commitId;
    bool m_commitIdHasBeenSet = false;

    Aws::String m_repository;
    bool m_repositoryHasBeenSet = false;

    Aws::String m_generatedBy;
    bool m_generatedByHasBeenSet = false;

    Aws::String m_projectId;
    bool m_projectIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
