#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
#     Please read more about how to change this file at
#     https://www.github.com/GoogleCloudPlatform/magic-modules
#
# ----------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {'metadata_version': '1.1', 'status': ["preview"], 'supported_by': 'community'}

DOCUMENTATION = '''
---
module: gcp_logging_metric_info
description:
- Gather info for GCP Metric
short_description: Gather info for GCP Metric
author: Google Inc. (@googlecloudplatform)
requirements:
- python >= 2.6
- requests >= 2.18.4
- google-auth >= 1.3.0
options:
  project:
    description:
    - The Google Cloud Platform project to use.
    type: str
  auth_kind:
    description:
    - The type of credential used.
    type: str
    required: true
    choices:
    - application
    - machineaccount
    - serviceaccount
  service_account_contents:
    description:
    - The contents of a Service Account JSON file, either in a dictionary or as a
      JSON string that represents it.
    type: jsonarg
  service_account_file:
    description:
    - The path of a Service Account JSON file if serviceaccount is selected as type.
    type: path
  service_account_email:
    description:
    - An optional service account email address if machineaccount is selected and
      the user does not wish to use the default email.
    type: str
  scopes:
    description:
    - Array of scopes to be used
    type: list
    elements: str
  env_type:
    description:
    - Specifies which Ansible environment you're running this module within.
    - This should not be set unless you know what you're doing.
    - This only alters the User Agent string for any API requests.
    type: str
notes:
- for authentication, you can set service_account_file using the C(gcp_service_account_file)
  env variable.
- for authentication, you can set service_account_contents using the C(GCP_SERVICE_ACCOUNT_CONTENTS)
  env variable.
- For authentication, you can set service_account_email using the C(GCP_SERVICE_ACCOUNT_EMAIL)
  env variable.
- For authentication, you can set auth_kind using the C(GCP_AUTH_KIND) env variable.
- For authentication, you can set scopes using the C(GCP_SCOPES) env variable.
- Environment variables values will only be used if the playbook values are not set.
- The I(service_account_email) and I(service_account_file) options are mutually exclusive.
'''

EXAMPLES = '''
- name: get info on a metric
  gcp_logging_metric_info:
    project: test_project
    auth_kind: serviceaccount
    service_account_file: "/tmp/auth.pem"
'''

RETURN = '''
resources:
  description: List of resources
  returned: always
  type: complex
  contains:
    name:
      description:
      - The client-assigned metric identifier. Examples - "error_count", "nginx/requests".
      - Metric identifiers are limited to 100 characters and can include only the
        following characters A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/.
        The forward-slash character (/) denotes a hierarchy of name pieces, and it
        cannot be the first character of the name.
      returned: success
      type: str
    description:
      description:
      - A description of this metric, which is used in documentation. The maximum
        length of the description is 8000 characters.
      returned: success
      type: str
    filter:
      description:
      - An advanced logs filter (U(https://cloud.google.com/logging/docs/view/advanced-filters))
        which is used to match log entries.
      returned: success
      type: str
    metricDescriptor:
      description:
      - The metric descriptor associated with the logs-based metric.
      returned: success
      type: complex
      contains:
        unit:
          description:
          - The unit in which the metric value is reported. It is only applicable
            if the valueType is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported
            units are a subset of [The Unified Code for Units of Measure](U(http://unitsofmeasure.org/ucum.html))
            standard .
          returned: success
          type: str
        valueType:
          description:
          - Whether the measurement is an integer, a floating-point number, etc.
          - Some combinations of metricKind and valueType might not be supported.
          - For counter metrics, set this to INT64.
          returned: success
          type: str
        metricKind:
          description:
          - Whether the metric records instantaneous values, changes to a value, etc.
          - Some combinations of metricKind and valueType might not be supported.
          - For counter metrics, set this to DELTA.
          returned: success
          type: str
        labels:
          description:
          - The set of labels that can be used to describe a specific instance of
            this metric type. For example, the appengine.googleapis.com/http/server/response_latencies
            metric type has a label for the HTTP response code, response_code, so
            you can look at latencies for successful responses or just for responses
            that failed.
          returned: success
          type: complex
          contains:
            key:
              description:
              - The label key.
              returned: success
              type: str
            description:
              description:
              - A human-readable description for the label.
              returned: success
              type: str
            valueType:
              description:
              - The type of data that can be assigned to the label.
              returned: success
              type: str
        displayName:
          description:
          - A concise name for the metric, which can be displayed in user interfaces.
            Use sentence case without an ending period, for example "Request count".
            This field is optional but it is recommended to be set for any metrics
            associated with user-visible concepts, such as Quota.
          returned: success
          type: str
        type:
          description:
          - The metric type, including its DNS name prefix. The type is not URL-encoded.
          - All user-defined metric types have the DNS name `custom.googleapis.com`
            or `external.googleapis.com`.
          returned: success
          type: str
    labelExtractors:
      description:
      - A map from a label key string to an extractor expression which is used to
        extract data from a log entry field and assign as the label value. Each label
        key specified in the LabelDescriptor must have an associated extractor expression
        in this map. The syntax of the extractor expression is the same as for the
        valueExtractor field.
      returned: success
      type: dict
    valueExtractor:
      description:
      - A valueExtractor is required when using a distribution logs-based metric to
        extract the values to record from a log entry. Two functions are supported
        for value extraction - EXTRACT(field) or REGEXP_EXTRACT(field, regex). The
        argument are 1. field - The name of the log entry field from which the value
        is to be extracted. 2. regex - A regular expression using the Google RE2 syntax
        (U(https://github.com/google/re2/wiki/Syntax)) with a single capture group
        to extract data from the specified log entry field. The value of the field
        is converted to a string before applying the regex. It is an error to specify
        a regex that does not include exactly one capture group.
      returned: success
      type: str
    bucketOptions:
      description:
      - The bucketOptions are required when the logs-based metric is using a DISTRIBUTION
        value type and it describes the bucket boundaries used to create a histogram
        of the extracted values.
      returned: success
      type: complex
      contains:
        linearBuckets:
          description:
          - Specifies a linear sequence of buckets that all have the same width (except
            overflow and underflow).
          - Each bucket represents a constant absolute uncertainty on the specific
            value in the bucket.
          returned: success
          type: complex
          contains:
            numFiniteBuckets:
              description:
              - Must be greater than 0.
              returned: success
              type: int
            width:
              description:
              - Must be greater than 0.
              returned: success
              type: int
            offset:
              description:
              - Lower bound of the first bucket.
              returned: success
              type: str
        exponentialBuckets:
          description:
          - Specifies an exponential sequence of buckets that have a width that is
            proportional to the value of the lower bound. Each bucket represents a
            constant relative uncertainty on a specific value in the bucket.
          returned: success
          type: complex
          contains:
            numFiniteBuckets:
              description:
              - Must be greater than 0.
              returned: success
              type: int
            growthFactor:
              description:
              - Must be greater than 1.
              returned: success
              type: str
            scale:
              description:
              - Must be greater than 0.
              returned: success
              type: str
        explicitBuckets:
          description:
          - Specifies a set of buckets with arbitrary widths.
          returned: success
          type: complex
          contains:
            bounds:
              description:
              - The values must be monotonically increasing.
              returned: success
              type: list
'''

################################################################################
# Imports
################################################################################
from ansible_collections.google.cloud.plugins.module_utils.gcp_utils import navigate_hash, GcpSession, GcpModule, GcpRequest
import json

################################################################################
# Main
################################################################################


def main():
    module = GcpModule(argument_spec=dict())

    if not module.params['scopes']:
        module.params['scopes'] = ['https://www.googleapis.com/auth/cloud-platform']

    return_value = {'resources': fetch_list(module, collection(module))}
    module.exit_json(**return_value)


def collection(module):
    return "https://logging.googleapis.com/v2/projects/{project}/metrics".format(**module.params)


def fetch_list(module, link):
    auth = GcpSession(module, 'logging')
    return auth.list(link, return_if_object, array_name='metrics')


def return_if_object(module, response):
    # If not found, return nothing.
    if response.status_code == 404:
        return None

    # If no content, return nothing.
    if response.status_code == 204:
        return None

    try:
        module.raise_for_status(response)
        result = response.json()
    except getattr(json.decoder, 'JSONDecodeError', ValueError) as inst:
        module.fail_json(msg="Invalid JSON response with error: %s" % inst)

    if navigate_hash(result, ['error', 'errors']):
        module.fail_json(msg=navigate_hash(result, ['error', 'errors']))

    return result


if __name__ == "__main__":
    main()
