require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS__ENDIAN_H_)) {
    eval 'sub _SYS__ENDIAN_H_ () {1;}' unless defined(&_SYS__ENDIAN_H_);
    unless(defined(&_MACHINE_ENDIAN_H_)) {
	die("sys/_endian.h should not be included directly");
    }
    eval 'sub _BYTE_ORDER () { &__BYTE_ORDER__;}' unless defined(&_BYTE_ORDER);
    eval 'sub _LITTLE_ENDIAN () { &__ORDER_LITTLE_ENDIAN__;}' unless defined(&_LITTLE_ENDIAN);
    eval 'sub _BIG_ENDIAN () { &__ORDER_BIG_ENDIAN__;}' unless defined(&_BIG_ENDIAN);
    eval 'sub _PDP_ENDIAN () { &__ORDER_PDP_ENDIAN__;}' unless defined(&_PDP_ENDIAN);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {1;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {0;}' unless defined(&_QUAD_LOWWORD);
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {0;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {1;}' unless defined(&_QUAD_LOWWORD);
    } else {
	die("Unsupported endian");
    }
    if((defined(&__BSD_VISIBLE) ? &__BSD_VISIBLE : undef)) {
	eval 'sub LITTLE_ENDIAN () { &_LITTLE_ENDIAN;}' unless defined(&LITTLE_ENDIAN);
	eval 'sub BIG_ENDIAN () { &_BIG_ENDIAN;}' unless defined(&BIG_ENDIAN);
	eval 'sub PDP_ENDIAN () { &_PDP_ENDIAN;}' unless defined(&PDP_ENDIAN);
	eval 'sub BYTE_ORDER () { &_BYTE_ORDER;}' unless defined(&BYTE_ORDER);
    }
    eval 'sub __bswap16 {
        my($x) = @_;
	    eval q( &__builtin_bswap16($x));
    }' unless defined(&__bswap16);
    eval 'sub __bswap32 {
        my($x) = @_;
	    eval q( &__builtin_bswap32($x));
    }' unless defined(&__bswap32);
    eval 'sub __bswap64 {
        my($x) = @_;
	    eval q( &__builtin_bswap64($x));
    }' unless defined(&__bswap64);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub __ntohl {
	    my($x) = @_;
    	    eval q(( &__bswap32($x)));
	}' unless defined(&__ntohl);
	eval 'sub __ntohs {
	    my($x) = @_;
    	    eval q(( &__bswap16($x)));
	}' unless defined(&__ntohs);
	eval 'sub __htonl {
	    my($x) = @_;
    	    eval q(( &__bswap32($x)));
	}' unless defined(&__htonl);
	eval 'sub __htons {
	    my($x) = @_;
    	    eval q(( &__bswap16($x)));
	}' unless defined(&__htons);
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub __htonl {
	    my($x) = @_;
    	    eval q((( &__uint32_t)($x)));
	}' unless defined(&__htonl);
	eval 'sub __htons {
	    my($x) = @_;
    	    eval q((( &__uint16_t)($x)));
	}' unless defined(&__htons);
	eval 'sub __ntohl {
	    my($x) = @_;
    	    eval q((( &__uint32_t)($x)));
	}' unless defined(&__ntohl);
	eval 'sub __ntohs {
	    my($x) = @_;
    	    eval q((( &__uint16_t)($x)));
	}' unless defined(&__ntohs);
    }
}
1;
