#!/usr/local/bin/bash

set -o pipefail -eux

declare -a args
IFS='/:' read -ra args <<< "$1"

cloud="${args[0]}"
python="${args[1]}"
group="${args[2]}"

target="shippable/${cloud}/group${group}/"

stage="${S:-prod}"

# shellcheck disable=SC2086
ansible-test integration --color -v --retry-on-error "${target}" ${COVERAGE:+"$COVERAGE"} ${CHANGED:+"$CHANGED"} ${UNSTABLE:+"$UNSTABLE"} \
    --remote-terminate always --remote-stage "${stage}" \
    --docker --python "${python}"
