#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for nxos_ospfv2
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: nxos_ospfv2
short_description: OSPFv2 resource module
description:
- This module manages OSPFv2 configuration on devices running Cisco NX-OS.
version_added: 1.0.0
notes:
- Tested against NX-OS 7.0(3)I5(1).
- Unsupported for Cisco MDS
- This module works with connection C(network_cli) and C(httpapi).
author: Nilashish Chakraborty (@NilashishC)
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the NX-OS device
      by executing the command B(show running-config | section "^router ospf .*").
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A list of OSPF process configuration.
    type: dict
    suboptions:
      processes:
        description:
        - A list of OSPF instances' configurations.
        type: list
        elements: dict
        suboptions:
          areas:
            description:
            - Configure properties of OSPF Areas.
            type: list
            elements: dict
            suboptions:
              area_id:
                description:
                - The Area ID in IP Address format.
                type: str
                required: true
              authentication:
                description:
                - Authentication settings for the Area.
                type: dict
                suboptions:
                  set:
                    description:
                    - Set authentication for the area.
                    type: bool
                  message_digest:
                    description:
                    - Use message-digest authentication.
                    type: bool
              default_cost:
                description:
                - Specify the default cost for default summary LSA.
                type: int
              filter_list:
                description:
                - Filter prefixes between OSPF areas.
                type: list
                elements: dict
                suboptions:
                  route_map:
                    description:
                    - The Route-map name.
                    type: str
                    required: true
                  direction:
                    description:
                    - The direction to apply the route map.
                    type: str
                    choices: [in, out]
                    required: true
              nssa:
                description:
                - NSSA settings for the area.
                type: dict
                suboptions:
                  set:
                    description:
                    - Configure area as NSSA.
                    type: bool
                  default_information_originate:
                    description:
                    - Originate Type-7 default LSA into NSSA area.
                    type: bool
                  no_redistribution:
                    description:
                    - Do not send redistributed LSAs into NSSA area.
                    type: bool
                  no_summary:
                    description:
                    - Do not send summary LSAs into NSSA area.
                    type: bool
                  translate:
                    description:
                    - Translate LSA.
                    type: dict
                    suboptions:
                      type7:
                        description:
                        - Translate from Type 7 to Type 5.
                        type: dict
                        suboptions:
                          always:
                            description:
                            - Always translate LSAs
                            type: bool
                          never:
                            description:
                            - Never translate LSAs
                            type: bool
                          supress_fa:
                            description:
                            - Suppress forwarding address in translated LSAs.
                            type: bool
              ranges:
                description:
                - Configure an address range for the area.
                type: list
                elements: dict
                suboptions:
                  prefix:
                    description:
                    - IP in Prefix format (x.x.x.x/len)
                    type: str
                    required: true
                  cost:
                    description:
                    - Cost to use for the range.
                    type: int
                  not_advertise:
                    description:
                    - Suppress advertising the specified range.
                    type: bool
              stub:
                description:
                - Settings for configuring the area as a stub.
                type: dict
                suboptions:
                  set:
                    description:
                    - Configure the area as a stub.
                    type: bool
                  no_summary:
                    description:
                    - Prevent ABR from sending summary LSAs into stub area.
                    type: bool
          auto_cost:
            description:
            - Calculate OSPF cost according to bandwidth.
            type: dict
            suboptions:
              reference_bandwidth:
                description:
                - Reference bandwidth used to assign OSPF cost.
                type: int
                required: true
              unit:
                description:
                - Specify in which unit the reference bandwidth is specified.
                type: str
                required: true
                choices: [Gbps, Mbps]
          bfd:
            description:
            - Enable BFD on all OSPF interfaces.
            type: bool
          default_information:
            description:
            - Control distribution of default routes.
            type: dict
            suboptions:
              originate:
                description:
                - Distribute a default route.
                type: dict
                suboptions:
                  set:
                    description:
                    - Enable distribution of default route.
                    type: bool
                  always:
                    description:
                    - Always advertise a default route.
                    type: bool
                  route_map:
                    description:
                    - Policy to control distribution of default routes
                    type: str
          default_metric:
            description:
            - Specify default metric for redistributed routes.
            type: int
          distance:
            description:
            - Configure the OSPF administrative distance.
            type: int
          flush_routes:
            description:
            - Flush routes on a non-graceful controlled restart.
            type: bool
          graceful_restart:
            description:
            - Configure graceful restart.
            type: dict
            suboptions:
              set:
                description:
                - Enable graceful-restart.
                type: bool
              grace_period:
                description:
                - Configure maximum interval to restart gracefully.
                type: int
              helper_disable:
                description:
                - Enable/Disable helper mode.
                type: bool
          isolate:
            description:
            - Isolate this router from OSPF perspective.
            type: bool
          log_adjacency_changes:
            description:
            - Log changes in adjacency state.
            type: dict
            suboptions:
              log:
                description:
                - Enable/disable logging changes in adjacency state.
                type: bool
              detail:
                description:
                - Notify all state changes.
                type: bool
          max_lsa:
            description:
            - Feature to limit the number of non-self-originated LSAs.
            type: dict
            suboptions:
              max_non_self_generated_lsa:
                description:
                - Set the maximum number of non self-generated LSAs.
                type: int
                required: true
              threshold:
                description:
                - Threshold value (%) at which to generate a warning message.
                type: int
              ignore_count:
                description:
                - Set count on how many times adjacencies can be suppressed.
                type: int
              ignore_time:
                description:
                - Set time during which all adjacencies are suppressed.
                type: int
              reset_time:
                description:
                - Set number of minutes after which ignore-count is reset to zero.
                type: int
              warning_only:
                description:
                - Log a warning message when limit is exceeded.
                type: bool
          max_metric:
            description:
            - Maximize the cost metric.
            type: dict
            suboptions:
              router_lsa:
                description:
                - Router LSA configuration.
                type: dict
                suboptions:
                  set:
                    description:
                    - Set router-lsa attribute.
                    type: bool
                  external_lsa:
                    description:
                    - External LSA configuration.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set external-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Set max metric value for external LSAs.
                        type: int
                  include_stub:
                    description:
                    - Advertise Max metric for Stub links as well.
                    type: bool
                  on_startup:
                    description:
                    - Effective only at startup.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set on-startup attribute.
                        type: bool
                      wait_period:
                        description:
                        - Wait period in seconds after startup.
                        type: int
                      wait_for_bgp_asn:
                        description:
                        - ASN of BGP to wait for.
                        type: int
                  summary_lsa:
                    description:
                    - Summary LSAs configuration.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set summary-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Max metric value for summary LSAs.
                        type: int
          maximum_paths:
            description:
            - Maximum paths per destination.
            type: int
          mpls:
            description:
            - OSPF MPLS configuration settings.
            type: dict
            suboptions:
              traffic_eng:
                description:
                - OSPF MPLS Traffic Engineering commands.
                type: dict
                suboptions:
                  areas:
                    description:
                    - List of Area IDs.
                    type: list
                    elements: dict
                    suboptions:
                      area_id:
                        description:
                        - Area Id in ip address format.
                        type: str
                  multicast_intact:
                    description:
                    - MPLS TE multicast support.
                    type: bool
                  router_id:
                    description:
                    - Router ID associated with TE.
                    type: str
          name_lookup:
            description:
            - Display OSPF router ids as DNS names.
            type: bool
          passive_interface:
            description:
            - Suppress routing updates on the interface.
            type: dict
            suboptions:
              default:
                description:
                - Interfaces passive by default.
                type: bool
          process_id:
            description:
            - The OSPF process tag.
            type: str
            required: true
          redistribute:
            description:
            - Redistribute information from another routing protocol.
            type: list
            elements: dict
            suboptions:
              protocol:
                description:
                - The name of the protocol.
                type: str
                choices: [bgp, direct, eigrp, isis, lisp, ospf, rip, static]
                required: true
              id:
                description:
                - The identifier for the protocol specified.
                type: str
              route_map:
                description:
                - The route map policy to constrain redistribution.
                type: str
                required: true
          rfc1583compatibility:
            description:
            - Configure 1583 compatibility for external path preferences.
            type: bool
          router_id:
            description:
            - Set OSPF process router-id.
            type: str
          shutdown:
            description:
            - Shutdown the OSPF protocol instance.
            type: bool
          summary_address:
            description:
            - Configure route summarization for redistribution.
            type: list
            elements: dict
            suboptions:
              prefix:
                description:
                - IP prefix in format x.x.x.x/ml.
                type: str
                required: true
              not_advertise:
                description:
                - Suppress advertising the specified summary.
                type: bool
              tag:
                description:
                - A 32-bit tag value.
                type: int
          table_map:
            description:
            - Policy for filtering/modifying OSPF routes before sending them to RIB.
            type: dict
            suboptions:
              name:
                description:
                - The Route Map name.
                type: str
                required: true
              filter:
                description:
                - Block the OSPF routes from being sent to RIB.
                type: bool
          timers:
            description:
            - Configure timer related constants.
            type: dict
            suboptions:
              lsa_arrival:
                description:
                - Mimimum interval between arrival of a LSA.
                type: int
              lsa_group_pacing:
                description:
                - LSA group refresh/maxage interval.
                type: int
              throttle:
                description:
                - Configure throttle related constants.
                type: dict
                suboptions:
                  lsa:
                    description:
                    - Set rate-limiting for LSA generation.
                    type: dict
                    suboptions:
                      start_interval:
                        description:
                        - The start interval.
                        type: int
                      hold_interval:
                        description:
                        - The hold interval.
                        type: int
                      max_interval:
                        description:
                        - The max interval.
                        type: int
                  spf:
                    description:
                    - Set OSPF SPF timers.
                    type: dict
                    suboptions:
                      initial_spf_delay:
                        description:
                        - Initial SPF schedule delay in milliseconds.
                        type: int
                      min_hold_time:
                        description:
                        - Minimum hold time between SPF calculations.
                        type: int
                      max_wait_time:
                        description:
                        - Maximum wait time between SPF calculations.
                        type: int
          vrfs:
            description:
            - Configure VRF specific OSPF settings.
            type: list
            elements: dict
            suboptions:
              areas:
                description:
                - Configure properties of OSPF Areas.
                type: list
                elements: dict
                suboptions:
                  area_id:
                    description:
                    - The Area ID in IP Address format.
                    type: str
                    required: true
                  authentication:
                    description:
                    - Authentication settings for the Area.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set authentication for the area.
                        type: bool
                      message_digest:
                        description:
                        - Use message-digest authentication.
                        type: bool
                  default_cost:
                    description:
                    - Specify the default cost for default summary LSA.
                    type: int
                  filter_list:
                    description:
                    - Filter prefixes between OSPF areas.
                    type: list
                    elements: dict
                    suboptions:
                      route_map:
                        description:
                        - The Route-map name.
                        type: str
                        required: true
                      direction:
                        description:
                        - The direction to apply the route map.
                        type: str
                        choices: [in, out]
                        required: true
                  nssa:
                    description:
                    - NSSA settings for the area.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Configure area as NSSA.
                        type: bool
                      default_information_originate:
                        description:
                        - Originate Type-7 default LSA into NSSA area.
                        type: bool
                      no_redistribution:
                        description:
                        - Do not send redistributed LSAs into NSSA area.
                        type: bool
                      no_summary:
                        description:
                        - Do not send summary LSAs into NSSA area.
                        type: bool
                      translate:
                        description:
                        - Translate LSA.
                        type: dict
                        suboptions:
                          type7:
                            description:
                            - Translate from Type 7 to Type 5.
                            type: dict
                            suboptions:
                              always:
                                description:
                                - Always translate LSAs
                                type: bool
                              never:
                                description:
                                - Never translate LSAs
                                type: bool
                              supress_fa:
                                description:
                                - Suppress forwarding address in translated LSAs.
                                type: bool
                  ranges:
                    description:
                    - Configure an address range for the area.
                    type: list
                    elements: dict
                    suboptions:
                      prefix:
                        description:
                        - IP in Prefix format (x.x.x.x/len)
                        type: str
                        required: true
                      cost:
                        description:
                        - Cost to use for the range.
                        type: int
                      not_advertise:
                        description:
                        - Suppress advertising the specified range.
                        type: bool
                  stub:
                    description:
                    - Settings for configuring the area as a stub.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Configure the area as a stub.
                        type: bool
                      no_summary:
                        description:
                        - Prevent ABR from sending summary LSAs into stub area.
                        type: bool
              auto_cost:
                description:
                - Calculate OSPF cost according to bandwidth.
                type: dict
                suboptions:
                  reference_bandwidth:
                    description:
                    - Reference bandwidth used to assign OSPF cost.
                    type: int
                    required: true
                  unit:
                    description:
                    - Specify in which unit the reference bandwidth is specified.
                    type: str
                    required: True
                    choices: [Gbps, Mbps]
              bfd:
                description:
                - Enable BFD on all OSPF interfaces.
                type: bool
              default_information:
                description:
                - Control distribution of default routes.
                type: dict
                suboptions:
                  originate:
                    description:
                    - Distribute a default route.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Enable distribution of default route.
                        type: bool
                      always:
                        description:
                        - Always advertise a default route.
                        type: bool
                      route_map:
                        description:
                        - Policy to control distribution of default routes
                        type: str
              default_metric:
                description:
                - Specify default metric for redistributed routes.
                type: int
              distance:
                description:
                - Configure the OSPF administrative distance.
                type: int
              down_bit_ignore:
                description:
                - Configure a PE router to ignore the DN bit for network summary,
                  external and NSSA external LSA.
                type: bool
              capability:
                description:
                - OSPF capability settings.
                type: dict
                suboptions:
                  vrf_lite:
                    description:
                    - Enable VRF-lite capability settings.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Enable VRF-lite support.
                        type: bool
                      evpn:
                        description:
                        - Ethernet VPN.
                        type: bool
              graceful_restart:
                description:
                - Configure graceful restart.
                type: dict
                suboptions:
                  set:
                    description:
                    - Enable graceful-restart.
                    type: bool
                  grace_period:
                    description:
                    - Configure maximum interval to restart gracefully.
                    type: int
                  helper_disable:
                    description:
                    - Enable/Disable helper mode.
                    type: bool
              log_adjacency_changes:
                description:
                - Log changes in adjacency state.
                type: dict
                suboptions:
                  log:
                    description:
                    - Enable/disable logging changes in adjacency state.
                    type: bool
                  detail:
                    description:
                    - Notify all state changes.
                    type: bool
              max_lsa:
                description:
                - Feature to limit the number of non-self-originated LSAs.
                type: dict
                suboptions:
                  max_non_self_generated_lsa:
                    description:
                    - Set the maximum number of non self-generated LSAs.
                    type: int
                    required: true
                  threshold:
                    description:
                    - Threshold value (%) at which to generate a warning message.
                    type: int
                  ignore_count:
                    description:
                    - Set count on how many times adjacencies can be suppressed.
                    type: int
                  ignore_time:
                    description:
                    - Set time during which all adjacencies are suppressed.
                    type: int
                  reset_time:
                    description:
                    - Set number of minutes after which ignore-count is reset to zero.
                    type: int
                  warning_only:
                    description:
                    - Log a warning message when limit is exceeded.
                    type: bool
              max_metric:
                description:
                - Maximize the cost metric.
                type: dict
                suboptions:
                  router_lsa:
                    description:
                    - Router LSA configuration.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set router-lsa attribute.
                        type: bool
                      external_lsa:
                        description:
                        - External LSA configuration.
                        type: dict
                        suboptions:
                          set:
                            description:
                            - Set external-lsa attribute.
                            type: bool
                          max_metric_value:
                            description:
                            - Set max metric value for external LSAs.
                            type: int
                      include_stub:
                        description:
                        - Advertise Max metric for Stub links as well.
                        type: bool
                      on_startup:
                        description:
                        - Effective only at startup.
                        type: dict
                        suboptions:
                          set:
                            description:
                            - Set on-startup attribute.
                            type: bool
                          wait_period:
                            description:
                            - Wait period in seconds after startup.
                            type: int
                          wait_for_bgp_asn:
                            description:
                            - ASN of BGP to wait for.
                            type: int
                      summary_lsa:
                        description:
                        - Summary LSAs configuration.
                        type: dict
                        suboptions:
                          set:
                            description:
                            - Set summary-lsa attribute.
                            type: bool
                          max_metric_value:
                            description:
                            - Max metric value for summary LSAs.
                            type: int
              maximum_paths:
                description:
                - Maximum paths per destination.
                type: int
              name_lookup:
                description:
                - Display OSPF router ids as DNS names.
                type: bool
              passive_interface:
                description:
                - Suppress routing updates on the interface.
                type: dict
                suboptions:
                  default:
                    description:
                    - Interfaces passive by default.
                    type: bool
              redistribute:
                description:
                - Redistribute information from another routing protocol.
                type: list
                elements: dict
                suboptions:
                  protocol:
                    description:
                    - The name of the protocol.
                    type: str
                    choices: [bgp, direct, eigrp, isis, lisp, ospf, rip, static]
                    required: true
                  id:
                    description:
                    - The identifier for the protocol specified.
                    type: str
                  route_map:
                    description:
                    - The route map policy to constrain redistribution.
                    type: str
                    required: true
              rfc1583compatibility:
                description:
                - Configure 1583 compatibility for external path preferences.
                type: bool
              router_id:
                description:
                - Set OSPF process router-id.
                type: str
              shutdown:
                description:
                - Shutdown the OSPF protocol instance.
                type: bool
              summary_address:
                description:
                - Configure route summarization for redistribution.
                type: list
                elements: dict
                suboptions:
                  prefix:
                    description:
                    - IP prefix in format x.x.x.x/ml.
                    type: str
                    required: true
                  not_advertise:
                    description:
                    - Suppress advertising the specified summary.
                    type: bool
                  tag:
                    description:
                    - A 32-bit tag value.
                    type: int
              table_map:
                description:
                - Policy for filtering/modifying OSPF routes before sending them to
                  RIB.
                type: dict
                suboptions:
                  name:
                    description:
                    - The Route Map name.
                    type: str
                    required: true
                  filter:
                    description:
                    - Block the OSPF routes from being sent to RIB.
                    type: bool
              timers:
                description:
                - Configure timer related constants.
                type: dict
                suboptions:
                  lsa_arrival:
                    description:
                    - Mimimum interval between arrival of a LSA.
                    type: int
                  lsa_group_pacing:
                    description:
                    - LSA group refresh/maxage interval.
                    type: int
                  throttle:
                    description:
                    - Configure throttle related constants.
                    type: dict
                    suboptions:
                      lsa:
                        description:
                        - Set rate-limiting for LSA generation.
                        type: dict
                        suboptions:
                          start_interval:
                            description:
                            - The start interval.
                            type: int
                          hold_interval:
                            description:
                            - The hold interval.
                            type: int
                          max_interval:
                            description:
                            - The max interval.
                            type: int
                      spf:
                        description:
                        - Set OSPF SPF timers.
                        type: dict
                        suboptions:
                          initial_spf_delay:
                            description:
                            - Initial SPF schedule delay in milliseconds.
                            type: int
                          min_hold_time:
                            description:
                            - Minimum hold time between SPF calculations.
                            type: int
                          max_wait_time:
                            description:
                            - Maximum wait time between SPF calculations.
                            type: int
              vrf:
                description:
                - Name/Identifier of the VRF.
                type: str
                required: true
  state:
    description:
    - The state the configuration should be left in.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - parsed
    - rendered
    default: merged

"""
EXAMPLES = """
# Using merged

# Before state:
# -------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# nxos-9k-rdo#

- name: Merge the provided configuration with the existing running configuration
  cisco.nxos.nxos_ospfv2:
    config:
      processes:
      - process_id: 100
        router_id: 203.0.113.20
      - process_id: 102
        router_id: 198.51.100.1
        areas:
        - area_id: 0.0.0.100
          filter_list:
          - route_map: rmap_1
            direction: in
          - route_map: rmap_2
            direction: out
          ranges:
          - prefix: 198.51.100.64/27
            not_advertise: true
          - prefix: 198.51.100.96/27
            cost: 120
        - area_id: 0.0.0.101
          authentication:
            message_digest: true
        redistribute:
        - protocol: eigrp
          id: 120
          route_map: rmap_1
        - protocol: direct
          route_map: ospf102-direct-connect
        vrfs:
        - vrf: zone1
          router_id: 198.51.100.129
          redistribute:
          - protocol: static
            route_map: zone1-static-connect
          summary_address:
          - prefix: 198.51.100.128/27
            tag: 121
          - prefix: 198.51.100.160/27
          areas:
          - area_id: 0.0.0.102
            nssa:
              default_information_originate: true
              no_summary: true
          - area_id: 0.0.0.103
            nssa:
              no_summary: true
              translate:
                type7:
                  always: true
        - vrf: zone2
          auto_cost:
            reference_bandwidth: 45
            unit: Gbps
    state: merged

# Task output
# -------------
# before: {}
#
# commands:
#  - router ospf 102
#  - router-id 198.51.100.1
#  - redistribute eigrp 120 route-map rmap_1
#  - redistribute direct route-map ospf102-direct-connect
#  - area 0.0.0.100 filter-list route-map rmap_1 in
#  - area 0.0.0.100 filter-list route-map rmap_2 out
#  - area 0.0.0.100 range 198.51.100.64/27 not-advertise
#  - area 0.0.0.100 range 198.51.100.96/27 cost 120
#  - area 0.0.0.101 authentication message-digest
#  - vrf zone1
#  - router-id 198.51.100.129
#  - summary-address 198.51.100.128/27 tag 121
#  - summary-address 198.51.100.160/27
#  - redistribute static route-map zone1-static-connect
#  - area 0.0.0.102 nssa no-summary default-information-originate
#  - area 0.0.0.103 nssa no-summary
#  - area 0.0.0.103 nssa translate type7 always
#  - vrf zone2
#  - auto-cost reference-bandwidth 45 Gbps
#  - router ospf 100
#  - router-id 203.0.113.20
#
# after:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: out
#          route_map: rmap_2
#        - direction: in
#          route_map: rmap_1
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#        - cost: 120
#          prefix: 198.51.100.96/27
#      - area_id: 0.0.0.101
#        authentication:
#          message_digest: true
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "120"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        - area_id: 0.0.0.103
#          nssa:
#            no_summary: true
#            translate:
#              type7:
#                always: true
#        redistribute:
#        - protocol: static
#          route_map: zone1-static-connect
#        router_id: 198.51.100.129
#        vrf: zone1
#      - auto_cost:
#          reference_bandwidth: 45
#          unit: Gbps
#        vrf: zone2
#

# After state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   area 0.0.0.100 range 198.51.100.96/27 cost 120
#   area 0.0.0.101 authentication message-digest
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     area 0.0.0.103 nssa no-summary
#     area 0.0.0.103 nssa translate type7 always
#     redistribute static route-map zone1-static-connect
#     summary-address 198.51.100.128/27 tag 121
#     summary-address 198.51.100.160/27
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps

# Using replaced

# Before state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   area 0.0.0.100 range 198.51.100.96/27 cost 120
#   area 0.0.0.101 authentication message-digest
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     area 0.0.0.103 nssa no-summary
#     area 0.0.0.103 nssa translate type7 always
#     redistribute static route-map zone1-static-connect
#     summary-address 198.51.100.128/27 tag 121
#     summary-address 198.51.100.160/27
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps

- name: Replace device configurations of listed OSPF processes with provided configurations
  cisco.nxos.nxos_ospfv2:
    config:
      processes:
      - process_id: 102
        router_id: 198.51.100.1
        areas:
        - area_id: 0.0.0.100
          filter_list:
          - route_map: rmap_8
            direction: in
          ranges:
          - prefix: 198.51.100.64/27
            not_advertise: true
        - area_id: 0.0.0.101
          stub:
            no_summary: true
        redistribute:
        - protocol: eigrp
          id: 130
          route_map: rmap_1
        - protocol: direct
          route_map: ospf102-direct-connect
        vrfs:
        - vrf: zone1
          router_id: 198.51.100.129
          redistribute:
          - protocol: bgp
            id: 65563
            route_map: zone1-bgp-connect
          areas:
          - area_id: 0.0.0.102
            nssa:
              default_information_originate: true
              no_summary: true
    state: replaced

# Task output
# -------------
# before:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: out
#          route_map: rmap_2
#        - direction: in
#          route_map: rmap_1
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#        - cost: 120
#          prefix: 198.51.100.96/27
#      - area_id: 0.0.0.101
#        authentication:
#          message_digest: true
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "120"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        - area_id: 0.0.0.103
#          nssa:
#            no_summary: true
#            translate:
#              type7:
#                always: true
#        redistribute:
#        - protocol: static
#          route_map: zone1-static-connect
#        router_id: 198.51.100.129
#        vrf: zone1
#      - auto_cost:
#          reference_bandwidth: 45
#          unit: Gbps
#        vrf: zone2
#
#  commands:
#  - router ospf 102
#  - redistribute eigrp 130 route-map rmap_1
#  - no redistribute eigrp 120 route-map rmap_1
#  - area 0.0.0.100 filter-list route-map rmap_8 in
#  - no area 0.0.0.100 filter-list route-map rmap_2 out
#  - no area 0.0.0.100 range 198.51.100.96/27
#  - no area 0.0.0.101 authentication
#  - area 0.0.0.101 stub no-summary
#  - vrf zone1
#  - no summary-address 198.51.100.128/27 tag 121
#  - no summary-address 198.51.100.160/27
#  - redistribute bgp 65563 route-map zone1-bgp-connect
#  - no redistribute static route-map zone1-static-connect
#  - no area 0.0.0.103 nssa
#  - no area 0.0.0.103 nssa translate type7 always
#  - no vrf zone2
#
# after:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.101
#        stub:
#          no_summary: true
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: in
#          route_map: rmap_8
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "130"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        redistribute:
#        - id: "65563"
#          protocol: bgp
#          route_map: zone1-bgp-connect
#        router_id: 198.51.100.129
#        vrf: zone1

# After state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   area 0.0.0.101 stub no-summary
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 130 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_8 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     redistribute bgp 65563 route-map zone1-bgp-connect

# Using overridden

# Before state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   area 0.0.0.100 range 198.51.100.96/27 cost 120
#   area 0.0.0.101 authentication message-digest
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     area 0.0.0.103 nssa no-summary
#     area 0.0.0.103 nssa translate type7 always
#     redistribute static route-map zone1-static-connect
#     summary-address 198.51.100.128/27 tag 121
#     summary-address 198.51.100.160/27
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps

- name: Override all OSPF configuration with provided configuration
  cisco.nxos.nxos_ospfv2:
    config:
      processes:
      - process_id: 104
        router_id: 203.0.113.20
      - process_id: 102
        router_id: 198.51.100.1
        shutdown: true
    state: overridden

# Task output
# -------------
# before:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: out
#          route_map: rmap_2
#        - direction: in
#          route_map: rmap_1
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#        - cost: 120
#          prefix: 198.51.100.96/27
#      - area_id: 0.0.0.101
#        authentication:
#          message_digest: true
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "120"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        - area_id: 0.0.0.103
#          nssa:
#            no_summary: true
#            translate:
#              type7:
#                always: true
#        redistribute:
#        - protocol: static
#          route_map: zone1-static-connect
#        router_id: 198.51.100.129
#        vrf: zone1
#      - auto_cost:
#          reference_bandwidth: 45
#          unit: Gbps
#        vrf: zone2
#
# commands:
#  - no router ospf 100
#  - router ospf 104
#  - router-id 203.0.113.20
#  - router ospf 102
#  - shutdown
#  - no redistribute direct route-map ospf102-direct-connect
#  - no redistribute eigrp 120 route-map rmap_1
#  - no area 0.0.0.100 filter-list route-map rmap_2 out
#  - no area 0.0.0.100 filter-list route-map rmap_1 in
#  - no area 0.0.0.100 range 198.51.100.64/27
#  - no area 0.0.0.100 range 198.51.100.96/27
#  - no area 0.0.0.101 authentication
#  - no vrf zone1
#  - no vrf zone2
#
# after:
#    processes:
#    - process_id: "102"
#      router_id: 198.51.100.1
#      shutdown: true
#    - process_id: "104"
#      router_id: 203.0.113.20

# After state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 102
#   router-id 198.51.100.1
#   shutdown
# router ospf 104
#   router-id 203.0.113.20

# Using deleted to delete a single OSPF process

# Before state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   area 0.0.0.100 range 198.51.100.96/27 cost 120
#   area 0.0.0.101 authentication message-digest
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     area 0.0.0.103 nssa no-summary
#     area 0.0.0.103 nssa translate type7 always
#     redistribute static route-map zone1-static-connect
#     summary-address 198.51.100.128/27 tag 121
#     summary-address 198.51.100.160/27
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps

- name: Delete a single OSPF process
  cisco.nxos.nxos_ospfv2:
    config:
      processes:
      - process_id: 102
    state: deleted

# Task output
# -------------
# before:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: out
#          route_map: rmap_2
#        - direction: in
#          route_map: rmap_1
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#        - cost: 120
#          prefix: 198.51.100.96/27
#      - area_id: 0.0.0.101
#        authentication:
#          message_digest: true
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "120"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        - area_id: 0.0.0.103
#          nssa:
#            no_summary: true
#            translate:
#              type7:
#                always: true
#        redistribute:
#        - protocol: static
#          route_map: zone1-static-connect
#        router_id: 198.51.100.129
#        vrf: zone1
#      - auto_cost:
#          reference_bandwidth: 45
#          unit: Gbps
#        vrf: zone2
#
# commands:
#  - no router ospf 102
#
# after:
#   processes:
#   - process_id: "100"
#     router_id: 203.0.113.20

# After state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20

# Using deleted all OSPF processes from the device

# Before state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# router ospf 100
#   router-id 203.0.113.20
# router ospf 102
#   router-id 198.51.100.1
#   redistribute direct route-map ospf102-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 198.51.100.64/27 not-advertise
#   area 0.0.0.100 range 198.51.100.96/27 cost 120
#   area 0.0.0.101 authentication message-digest
#   vrf zone1
#     router-id 198.51.100.129
#     area 0.0.0.102 nssa no-summary default-information-originate
#     area 0.0.0.103 nssa no-summary
#     area 0.0.0.103 nssa translate type7 always
#     redistribute static route-map zone1-static-connect
#     summary-address 198.51.100.128/27 tag 121
#     summary-address 198.51.100.160/27
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps

- name: Delete all OSPF processes from the device
  cisco.nxos.nxos_ospfv2:
    state: deleted

# Task output
# -------------
# before:
#    processes:
#    - process_id: "100"
#      router_id: 203.0.113.20
#    - areas:
#      - area_id: 0.0.0.100
#        filter_list:
#        - direction: out
#          route_map: rmap_2
#        - direction: in
#          route_map: rmap_1
#        ranges:
#        - not_advertise: true
#          prefix: 198.51.100.64/27
#        - cost: 120
#          prefix: 198.51.100.96/27
#      - area_id: 0.0.0.101
#        authentication:
#          message_digest: true
#      process_id: "102"
#      redistribute:
#      - protocol: direct
#        route_map: ospf102-direct-connect
#      - id: "120"
#        protocol: eigrp
#        route_map: rmap_1
#      router_id: 198.51.100.1
#      vrfs:
#      - areas:
#        - area_id: 0.0.0.102
#          nssa:
#            default_information_originate: true
#            no_summary: true
#        - area_id: 0.0.0.103
#          nssa:
#            no_summary: true
#            translate:
#              type7:
#                always: true
#        redistribute:
#        - protocol: static
#          route_map: zone1-static-connect
#        router_id: 198.51.100.129
#        vrf: zone1
#      - auto_cost:
#          reference_bandwidth: 45
#          unit: Gbps
#        vrf: zone2
#
# commands:
#  - no router ospf 100
#  - no router ospf 102
#
#  after: {}

# After state:
# ------------
# nxos-9k-rdo# sh running-config | section "^router ospf .*"
# nxos-9k-rdo#

# Using rendered

- name: Render platform specific configuration lines (without connecting to the device)
  cisco.nxos.nxos_ospfv2:
    config:
      processes:
      - process_id: 100
        router_id: 203.0.113.20
      - process_id: 102
        router_id: 198.51.100.1
        areas:
        - area_id: 0.0.0.100
          filter_list:
          - route_map: rmap_1
            direction: in
          - route_map: rmap_2
            direction: out
          ranges:
          - prefix: 198.51.100.64/27
            not_advertise: true
          - prefix: 198.51.100.96/27
            cost: 120
        - area_id: 0.0.0.101
          authentication:
            message_digest: true
        redistribute:
        - protocol: eigrp
          id: 120
          route_map: rmap_1
        - protocol: direct
          route_map: ospf102-direct-connect
        vrfs:
        - vrf: zone1
          router_id: 198.51.100.129
          redistribute:
          - protocol: static
            route_map: zone1-static-connect
          summary_address:
          - prefix: 198.51.100.128/27
            tag: 121
          - prefix: 198.51.100.160/27
          areas:
          - area_id: 0.0.0.102
            nssa:
              default_information_originate: true
              no_summary: true
          - area_id: 0.0.0.103
            nssa:
              no_summary: true
              translate:
                type7:
                  always: true
        - vrf: zone2
          auto_cost:
            reference_bandwidth: 45
            unit: Gbps
    state: rendered

# Task Output (redacted)
# -----------------------
# rendered:
#  - router ospf 100
#  - router-id 203.0.113.20
#  - router ospf 102
#  - router-id 198.51.100.1
#  - redistribute eigrp 120 route-map rmap_1
#  - redistribute direct route-map ospf102-direct-connect
#  - area 0.0.0.100 filter-list route-map rmap_1 in
#  - area 0.0.0.100 filter-list route-map rmap_2 out
#  - area 0.0.0.100 range 198.51.100.64/27 not-advertise
#  - area 0.0.0.100 range 198.51.100.96/27 cost 120
#  - area 0.0.0.101 authentication message-digest
#  - vrf zone1
#  - router-id 198.51.100.129
#  - summary-address 198.51.100.128/27 tag 121
#  - summary-address 198.51.100.160/27
#  - redistribute static route-map zone1-static-connect
#  - area 0.0.0.102 nssa no-summary default-information-originate
#  - area 0.0.0.103 nssa no-summary
#  - area 0.0.0.103 nssa translate type7 always
#  - vrf zone2
#  - auto-cost reference-bandwidth 45 Gbps

# Using parsed

# parsed.cfg
# ------------
# router ospf 100
#   router-id 192.0.100.1
#   area 0.0.0.101 nssa no-summary no-redistribution
#   area 0.0.0.102 stub no-summary
#   redistribute direct route-map ospf-direct-connect
#   redistribute eigrp 120 route-map rmap_1
#   area 0.0.0.100 filter-list route-map rmap_2 out
#   area 0.0.0.100 filter-list route-map rmap_1 in
#   area 0.0.0.100 range 192.0.2.0/24 not-advertise
#   area 0.0.0.100 range 192.0.3.0/24 cost 120
#   area 0.0.0.100 authentication message-digest
#   vrf zone1
#     router-id 192.0.100.2
#     area 0.0.100.1 nssa no-summary no-redistribution
#     redistribute static route-map zone1-direct-connect
#     summary-address 10.0.0.0/24 tag 120
#     summary-address 11.0.0.0/24 not-advertise
#   vrf zone2
#     auto-cost reference-bandwidth 45 Gbps
#     down-bit-ignore
#     capability vrf-lite evpn
#     shutdown
# router ospf 102
#   router-id 198.54.100.1
#   shutdown
#   vrf zone2
#     summary-address 192.0.8.0/24 tag 120
#   vrf zone4
#     shutdown

- name: Parse externally provided OSPFv2 config
  cisco.nxos.nxos_ospfv2:
    running_config: "{{ lookup('file', 'ospfv2.cfg') }}"
    state: parsed

# Task output (redacted)
# -----------------------
# parsed:
#   processes:
#   - process_id: "100"
#     areas:
#       - area_id: 0.0.0.101
#         nssa:
#           no_redistribution: true
#           no_summary: true
#       - area_id: 0.0.0.102
#         stub:
#           no_summary: true
#       - area_id: 0.0.0.100
#         authentication:
#           message_digest: true
#         filter_list:
#           - direction: out
#             route_map: rmap_2
#           - direction: in
#             route_map: rmap_1
#         ranges:
#           - not_advertise: true
#             prefix: 192.0.2.0/24
#           - cost: 120
#             prefix: 192.0.3.0/24
#     redistribute:
#       - protocol: direct
#         route_map: ospf-direct-connect
#       - id: "120"
#         protocol: eigrp
#         route_map: rmap_1
#     router_id: 192.0.100.1
#     vrfs:
#       - vrf: zone1
#         areas:
#           - area_id: 0.0.100.1
#             nssa:
#               no_redistribution: true
#               no_summary: true
#         redistribute:
#           - protocol: static
#             route_map: zone1-direct-connect
#         router_id: 192.0.100.2
#         summary_address:
#           - prefix: 10.0.0.0/24
#             tag: 120
#           - not_advertise: true
#             prefix: 11.0.0.0/24
#       - vrf: zone2
#         auto_cost:
#           reference_bandwidth: 45
#           unit: Gbps
#         capability:
#           vrf_lite:
#             evpn: true
#         down_bit_ignore: true
#         shutdown: true
#   - process_id: "102"
#     router_id: 198.54.100.1
#     shutdown: true
#     vrfs:
#       - vrf: zone2
#         summary_address:
#           - prefix: 192.0.8.0/24
#             tag: 120
#       - vrf: zone4
#         shutdown: true

# Using gathered

- name: Gather OSPFv2 facts using gathered
  cisco.nxos.nxos_ospfv2:
    state: gathered

# Task output (redacted)
# -----------------------
#  gathered:
#    processes:
#      - process_id: "102"
#        areas:
#          - area_id: 0.0.0.101
#            stub:
#              no_summary: true
#          - area_id: 0.0.0.100
#            filter_list:
#              - direction: in
#                route_map: rmap_8
#            ranges:
#              - not_advertise: true
#                prefix: 198.51.100.64/27
#        redistribute:
#          - protocol: direct
#            route_map: ospf102-direct-connect
#          - id: "130"
#            protocol: eigrp
#            route_map: rmap_1
#        router_id: 198.51.100.1
#        vrfs:
#          - vrf: zone1
#            areas:
#              - area_id: 0.0.0.102
#                nssa:
#                  default_information_originate: true
#                  no_summary: true
#            redistribute:
#             - id: "65563"
#               protocol: bgp
#               route_map: zone1-bgp-connect
#            router_id: 198.51.100.129
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
    - "router ospf 102"
    - "router-id 198.54.100.1"
    - "router ospf 100"
    - "router-id 192.0.100.1"
    - "redistribute eigrp 120 route-map rmap_1"
    - "redistribute direct route-map ospf-direct-connect"
    - "area 0.0.0.100 filter-list route-map rmap_1 in"
    - "area 0.0.0.100 filter-list route-map rmap_2 out"
    - "area 0.0.0.100 range 192.0.2.0/24 not-advertise"
    - "area 0.0.0.100 range 192.0.3.0/24 cost 120"
    - "vrf zone1"
    - "router-id 192.0.100.2"
    - "summary-address 10.0.0.0/24 tag 121"
    - "summary-address 11.0.0.0/24"
    - "redistribute static route-map zone1-direct-connect"
    - "vrf zone2"
    - "auto-cost reference-bandwidth 45 Gbps"
    - "capability vrf-lite evpn"
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.argspec.ospfv2.ospfv2 import (
    Ospfv2Args,
)
from ansible_collections.cisco.nxos.plugins.module_utils.network.nxos.config.ospfv2.ospfv2 import (
    Ospfv2,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Ospfv2Args.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Ospfv2(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
