# -*- coding: utf-8 -*-
# Copyright: (c) 2019, Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class ModuleDocFragment(object):
    # Parameters for Service Now modules
    DOCUMENTATION = r'''
options:
    auth:
      description:
      - The method used to authenticate with the Service Now instance.
      - Basic authentication uses user name and password.
      - OAuth authentication uses a client id and secret in addition to Basic authentication.
      - Token authentication uses a bearer token in addition to OAuth authentication.
      - OpenID Connect authentication, an extension of OAuth 2.0, uses a provider, like Okta, to obtain a bearer token.
      - If the vaule is not specified in the task, the value of environment variable C(SN_AUTH) will be used instead.
      choices: ['basic', 'oauth', 'token', 'openid']
      type: str
      default: basic
    raise_on_empty:
      description:
      - If set to false, will not cause a SNOW method to raise an exception should it return no records.
      - This is particurlarly useful in snow_record_find, when not sure if any record exists.
      type: bool
      default: True
    log_level:
      description:
      - Set the logging level of the module
      choices: ['debug', 'info', 'normal']
      type: str
      default: normal
    instance:
      description:
      - The ServiceNow instance name, without the domain, service-now.com.
      - If the value is not specified in the task, the value of environment variable C(SN_INSTANCE) will be used instead.
      required: false
      type: str
    host:
      description:
      - The ServiceNow hostname.
      - This value is FQDN for ServiceNow host.
      - If the value is not specified in the task, the value of environment variable C(SN_HOST) will be used instead.
      - Mutually exclusive with C(instance).
      type: str
    username:
      description:
      - Name of user for connection to ServiceNow.
      - Required whether using Basic, OAuth or OpenID authentication.
      - If the value is not specified in the task, the value of environment variable C(SN_USERNAME) will be used instead.
      required: false
      type: str
    password:
      description:
      - Password for username.
      - Required whether using Basic, OAuth or OpenID authentication.
      - If the value is not specified in the task, the value of environment variable C(SN_PASSWORD) will be used instead.
      required: false
      type: str
    client_id:
      description:
      - Client ID generated by ServiceNow.
      - Required when using OAuth or OpenID authentication, unless token is specified.
      - If the value is not specified in the task, the value of environment variable C(SN_CLIENTID) will be used instead.
      required: false
      type: str
    client_secret:
      description:
      - Client Secret associated with client id.
      - Required when using OAuth or OpenID authentication, unless token is specified.
      - If the value is not specified in the task, the value of environment variable C(SN_CLIENTSECRET) will be used instead.
      required: false
      type: str
    token:
      description:
      - Bearer token associated with client id and secret.
      - Can be used in place of client id and secret for OpenID authentication.
      - If the value is not specified in the task, the value of environment variable C(SN_TOKEN) will be used instead.
      required: false
      type: str
    openid_issuer:
      description:
      - The URL for your organization's OpenID Connect provider.
      - Okta, an OpenID provider, supports Single Sign-On with a url like 'https://yourorg.oktapreview.com/oauth2'.
      - Okta supports application-level authentication using a url like 'https://yourorg.oktapreview.com/oauth2/TH151s50m3L0ngSTr1NG'.
      - If the value is not specified in the task, the value of environment variable C(OPENID_ISSUER) will be used instead.
      required: false
      type: str
    openid_scope:
      description:
      - A list of scopes to be included in the access token.
      - Supported scopes for this application are address, email, groups, openid, phone, profile, of which, openid must be one.
      - If the value is not specified in the task, the value of environment variable C(OPENID_SCOPE) will be used instead.
      required: false
      type: list
      elements: str
      default: ['openid']
    openid:
      description:
      - If the result of a previous SNOW method, using OpenID, was registered, supply the C(openid) key, from the result.
      - The C(openid) key contains a dictionary with the bearer token, which, if still valid, can be reused.
      - If the bearer token is no longer valid, the dictionary includes all of the previously supplied C(openid_) fields needed to make a new token request.
      - Any other credentials previously supplied, must be provided again.
      required: false
      type: dict
'''
