#!/usr/local/bin/python3.8
from __future__ import absolute_import, division, print_function
# Copyright 2019-2021 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_system_fortiguard
short_description: Configure FortiGuard services.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.10"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    enable_log:
        description: Enable/Disable logging for task
        required: false
        type: bool
        default: false
    proposed_method:
        description: The overridden method for the underlying Json RPC request
        required: false
        type: str
        choices:
          - update
          - set
          - add
    bypass_validation:
        description: only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    state:
        description: the directive to create, update or delete an object
        type: str
        required: true
        choices:
          - present
          - absent
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    system_fortiguard:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            antispam-cache:
                type: str
                description: 'Enable/disable FortiGuard antispam request caching. Uses a small amount of memory but improves performance.'
                choices:
                    - 'disable'
                    - 'enable'
            antispam-cache-mpercent:
                type: int
                description: 'Maximum percent of FortiGate memory the antispam cache is allowed to use (1 - 15%).'
            antispam-cache-ttl:
                type: int
                description: 'Time-to-live for antispam cache entries in seconds (300 - 86400). Lower times reduce the cache size. Higher times may improve ...'
            antispam-expiration:
                type: int
                description: no description
            antispam-force-off:
                type: str
                description: 'Enable/disable turning off the FortiGuard antispam service.'
                choices:
                    - 'disable'
                    - 'enable'
            antispam-license:
                type: int
                description: no description
            antispam-timeout:
                type: int
                description: 'Antispam query time out (1 - 30 sec, default = 7).'
            auto-join-forticloud:
                type: str
                description: 'Automatically connect to and login to FortiCloud.'
                choices:
                    - 'disable'
                    - 'enable'
            ddns-server-ip:
                type: str
                description: 'IP address of the FortiDDNS server.'
            ddns-server-port:
                type: int
                description: 'Port used to communicate with FortiDDNS servers.'
            load-balance-servers:
                type: int
                description: 'Number of servers to alternate between as first FortiGuard option.'
            outbreak-prevention-cache:
                type: str
                description: 'Enable/disable FortiGuard Virus Outbreak Prevention cache.'
                choices:
                    - 'disable'
                    - 'enable'
            outbreak-prevention-cache-mpercent:
                type: int
                description: 'Maximum percent of memory FortiGuard Virus Outbreak Prevention cache can use (1 - 15%, default = 2).'
            outbreak-prevention-cache-ttl:
                type: int
                description: 'Time-to-live for FortiGuard Virus Outbreak Prevention cache entries (300 - 86400 sec, default = 300).'
            outbreak-prevention-expiration:
                type: int
                description: no description
            outbreak-prevention-force-off:
                type: str
                description: 'Turn off FortiGuard Virus Outbreak Prevention service.'
                choices:
                    - 'disable'
                    - 'enable'
            outbreak-prevention-license:
                type: int
                description: no description
            outbreak-prevention-timeout:
                type: int
                description: 'FortiGuard Virus Outbreak Prevention time out (1 - 30 sec, default = 7).'
            port:
                type: str
                description: 'Port used to communicate with the FortiGuard servers.'
                choices:
                    - '53'
                    - '80'
                    - '8888'
                    - '443'
            sdns-server-ip:
                description: no description
                type: str
            sdns-server-port:
                type: int
                description: 'Port used to communicate with FortiDNS servers.'
            service-account-id:
                type: str
                description: 'Service account ID.'
            source-ip:
                type: str
                description: 'Source IPv4 address used to communicate with FortiGuard.'
            source-ip6:
                type: str
                description: 'Source IPv6 address used to communicate with FortiGuard.'
            update-server-location:
                type: str
                description: 'Signature update server location.'
                choices:
                    - 'any'
                    - 'usa'
            webfilter-cache:
                type: str
                description: 'Enable/disable FortiGuard web filter caching.'
                choices:
                    - 'disable'
                    - 'enable'
            webfilter-cache-ttl:
                type: int
                description: 'Time-to-live for web filter cache entries in seconds (300 - 86400).'
            webfilter-expiration:
                type: int
                description: no description
            webfilter-force-off:
                type: str
                description: 'Enable/disable turning off the FortiGuard web filtering service.'
                choices:
                    - 'disable'
                    - 'enable'
            webfilter-license:
                type: int
                description: no description
            webfilter-timeout:
                type: int
                description: 'Web filter query time out (1 - 30 sec, default = 7).'
            protocol:
                type: str
                description: 'Protocol used to communicate with the FortiGuard servers.'
                choices:
                    - 'udp'
                    - 'http'
                    - 'https'
            proxy-password:
                description: no description
                type: str
            proxy-server-ip:
                type: str
                description: 'IP address of the proxy server.'
            proxy-server-port:
                type: int
                description: 'Port used to communicate with the proxy server.'
            proxy-username:
                type: str
                description: 'Proxy user name.'
            sandbox-region:
                type: str
                description: 'Cloud sandbox region.'
            fortiguard-anycast:
                type: str
                description: 'Enable/disable use of FortiGuards anycast network.'
                choices:
                    - 'disable'
                    - 'enable'
            fortiguard-anycast-source:
                type: str
                description: 'Configure which of Fortinets servers to provide FortiGuard services in FortiGuards anycast network. Default is Fortinet.'
                choices:
                    - 'fortinet'
                    - 'aws'
                    - 'debug'
            interface:
                type: str
                description: 'Specify outgoing interface to reach server.'
            interface-select-method:
                type: str
                description: 'Specify how to select outgoing interface to reach server.'
                choices:
                    - 'auto'
                    - 'sdwan'
                    - 'specify'
            sdns-options:
                description: no description
                type: list
                choices:
                 - include-question-section
            anycast-sdns-server-ip:
                type: str
                description: 'IP address of the FortiGuard anycast DNS rating server.'
            anycast-sdns-server-port:
                type: int
                description: 'Port to connect to on the FortiGuard anycast DNS rating server.'
            persistent-connection:
                type: str
                description: 'Enable/disable use of persistent connection to receive update notification from FortiGuard.'
                choices:
                    - 'disable'
                    - 'enable'
            update-build-proxy:
                type: str
                description: 'Enable/disable proxy dictionary rebuild.'
                choices:
                    - 'disable'
                    - 'enable'
            update-extdb:
                type: str
                description: 'Enable/disable external resource update.'
                choices:
                    - 'disable'
                    - 'enable'
            update-ffdb:
                type: str
                description: 'Enable/disable Internet Service Database update.'
                choices:
                    - 'disable'
                    - 'enable'
            update-uwdb:
                type: str
                description: 'Enable/disable allowlist update.'
                choices:
                    - 'disable'
                    - 'enable'
            videofilter-expiration:
                type: int
                description: no description
            videofilter-license:
                type: int
                description: no description

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: Configure FortiGuard services.
      fmgr_system_fortiguard:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         adom: <your own value>
         system_fortiguard:
            antispam-cache: <value in [disable, enable]>
            antispam-cache-mpercent: <value of integer>
            antispam-cache-ttl: <value of integer>
            antispam-expiration: <value of integer>
            antispam-force-off: <value in [disable, enable]>
            antispam-license: <value of integer>
            antispam-timeout: <value of integer>
            auto-join-forticloud: <value in [disable, enable]>
            ddns-server-ip: <value of string>
            ddns-server-port: <value of integer>
            load-balance-servers: <value of integer>
            outbreak-prevention-cache: <value in [disable, enable]>
            outbreak-prevention-cache-mpercent: <value of integer>
            outbreak-prevention-cache-ttl: <value of integer>
            outbreak-prevention-expiration: <value of integer>
            outbreak-prevention-force-off: <value in [disable, enable]>
            outbreak-prevention-license: <value of integer>
            outbreak-prevention-timeout: <value of integer>
            port: <value in [53, 80, 8888, ...]>
            sdns-server-ip: <value of string>
            sdns-server-port: <value of integer>
            service-account-id: <value of string>
            source-ip: <value of string>
            source-ip6: <value of string>
            update-server-location: <value in [any, usa]>
            webfilter-cache: <value in [disable, enable]>
            webfilter-cache-ttl: <value of integer>
            webfilter-expiration: <value of integer>
            webfilter-force-off: <value in [disable, enable]>
            webfilter-license: <value of integer>
            webfilter-timeout: <value of integer>
            protocol: <value in [udp, http, https]>
            proxy-password: <value of string>
            proxy-server-ip: <value of string>
            proxy-server-port: <value of integer>
            proxy-username: <value of string>
            sandbox-region: <value of string>
            fortiguard-anycast: <value in [disable, enable]>
            fortiguard-anycast-source: <value in [fortinet, aws, debug]>
            interface: <value of string>
            interface-select-method: <value in [auto, sdwan, specify]>
            sdns-options:
              - include-question-section
            anycast-sdns-server-ip: <value of string>
            anycast-sdns-server-port: <value of integer>
            persistent-connection: <value in [disable, enable]>
            update-build-proxy: <value in [disable, enable]>
            update-extdb: <value in [disable, enable]>
            update-ffdb: <value in [disable, enable]>
            update-uwdb: <value in [disable, enable]>
            videofilter-expiration: <value of integer>
            videofilter-license: <value of integer>

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/adom/{adom}/obj/system/fortiguard',
        '/pm/config/global/obj/system/fortiguard'
    ]

    perobject_jrpc_urls = [
        '/pm/config/adom/{adom}/obj/system/fortiguard/{fortiguard}',
        '/pm/config/global/obj/system/fortiguard/{fortiguard}'
    ]

    url_params = ['adom']
    module_primary_key = None
    module_arg_spec = {
        'enable_log': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'proposed_method': {
            'type': 'str',
            'required': False,
            'choices': [
                'set',
                'update',
                'add'
            ]
        },
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'system_fortiguard': {
            'required': False,
            'type': 'dict',
            'revision': {
                '6.0.0': True,
                '6.2.1': True,
                '6.2.3': True,
                '6.2.5': True,
                '6.4.0': True,
                '6.4.2': True,
                '6.4.5': True,
                '7.0.0': True
            },
            'options': {
                'antispam-cache': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'antispam-cache-mpercent': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'antispam-cache-ttl': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'antispam-expiration': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'antispam-force-off': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'antispam-license': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'antispam-timeout': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'auto-join-forticloud': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'ddns-server-ip': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'ddns-server-port': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'load-balance-servers': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'outbreak-prevention-cache': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'outbreak-prevention-cache-mpercent': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'outbreak-prevention-cache-ttl': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'outbreak-prevention-expiration': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'outbreak-prevention-force-off': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'outbreak-prevention-license': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'outbreak-prevention-timeout': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'port': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        '53',
                        '80',
                        '8888',
                        '443'
                    ],
                    'type': 'str'
                },
                'sdns-server-ip': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'sdns-server-port': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'service-account-id': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'source-ip': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'source-ip6': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'update-server-location': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'any',
                        'usa'
                    ],
                    'type': 'str'
                },
                'webfilter-cache': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'webfilter-cache-ttl': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'webfilter-expiration': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'webfilter-force-off': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'webfilter-license': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'webfilter-timeout': {
                    'required': False,
                    'revision': {
                        '6.0.0': True,
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'protocol': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'udp',
                        'http',
                        'https'
                    ],
                    'type': 'str'
                },
                'proxy-password': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'proxy-server-ip': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'proxy-server-port': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'proxy-username': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'sandbox-region': {
                    'required': False,
                    'revision': {
                        '6.2.1': True,
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'fortiguard-anycast': {
                    'required': False,
                    'revision': {
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'fortiguard-anycast-source': {
                    'required': False,
                    'revision': {
                        '6.2.3': True,
                        '6.2.5': True,
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'fortinet',
                        'aws',
                        'debug'
                    ],
                    'type': 'str'
                },
                'interface': {
                    'required': False,
                    'revision': {
                        '6.2.5': True,
                        '6.4.0': False,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'interface-select-method': {
                    'required': False,
                    'revision': {
                        '6.2.5': True,
                        '6.4.0': False,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'choices': [
                        'auto',
                        'sdwan',
                        'specify'
                    ],
                    'type': 'str'
                },
                'sdns-options': {
                    'required': False,
                    'revision': {
                        '6.4.0': True,
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'list',
                    'choices': [
                        'include-question-section'
                    ]
                },
                'anycast-sdns-server-ip': {
                    'required': False,
                    'revision': {
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'str'
                },
                'anycast-sdns-server-port': {
                    'required': False,
                    'revision': {
                        '6.4.2': True,
                        '6.4.5': True,
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'persistent-connection': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'update-build-proxy': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'update-extdb': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'update-ffdb': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'update-uwdb': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'videofilter-expiration': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'type': 'int'
                },
                'videofilter-license': {
                    'required': False,
                    'revision': {
                        '7.0.0': True
                    },
                    'type': 'int'
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'system_fortiguard'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_partial_curd(argument_specs=module_arg_spec)
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
