# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the iosxr_bgp_address_family module
"""


class Bgp_address_familyArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_bgp_address_family module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "str"},
                "address_family": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {
                            "type": "str",
                            "choices": [
                                "ipv4",
                                "ipv6",
                                "l2vpn",
                                "link-state",
                                "vpnv4",
                                "vpnv6",
                            ],
                        },
                        "safi": {
                            "type": "str",
                            "choices": [
                                "flowspec",
                                "mdt",
                                "multicast",
                                "mvpn",
                                "rt-filter",
                                "tunnel",
                                "unicast",
                                "evpn",
                                "mspw",
                                "vpls-vpws",
                                "link-state",
                            ],
                        },
                        "vrf": {"type": "str"},
                        "additional_paths": {
                            "type": "str",
                            "choices": ["send", "receive"],
                        },
                        "advertise_best_external": {"type": "bool"},
                        "aggregate_address": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "value": {"type": "str"},
                                "as_set": {"type": "bool"},
                                "as_confed_set": {"type": "bool"},
                                "summary_only": {"type": "bool"},
                                "route_policy": {"type": "str"},
                            },
                        },
                        "allocate_label": {
                            "type": "dict",
                            "options": {
                                "all": {"type": "bool"},
                                "route_policy": {"type": "str"},
                            },
                        },
                        "as_path_loopcheck_out_disable": {"type": "bool"},
                        "bgp": {
                            "type": "dict",
                            "options": {
                                "attribute_download": {"type": "bool"},
                                "bestpath": {
                                    "type": "dict",
                                    "options": {
                                        "origin_as": {
                                            "type": "dict",
                                            "options": {
                                                "use": {
                                                    "type": "dict",
                                                    "options": {
                                                        "validity": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                                "allow": {
                                                    "type": "dict",
                                                    "options": {
                                                        "invalid": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                            },
                                        }
                                    },
                                },
                                "client_to_client": {
                                    "type": "dict",
                                    "options": {
                                        "reflection": {
                                            "type": "dict",
                                            "options": {
                                                "cluster_id_disable": {
                                                    "type": "dict",
                                                    "options": {
                                                        "cluster_id": {
                                                            "type": "str"
                                                        },
                                                        "disable": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "disable": {"type": "bool"},
                                            },
                                        }
                                    },
                                },
                                "dampening": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "value": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                    },
                                },
                                "label_delay": {
                                    "type": "dict",
                                    "options": {
                                        "delay_second_parts": {"type": "int"},
                                        "delay_ms_parts": {"type": "int"},
                                    },
                                },
                                "import_delay": {
                                    "type": "dict",
                                    "options": {
                                        "delay_second_parts": {"type": "int"},
                                        "delay_ms_parts": {"type": "int"},
                                    },
                                },
                                "origin_as": {
                                    "type": "dict",
                                    "options": {
                                        "validation": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {"type": "bool"},
                                                "signal": {
                                                    "type": "dict",
                                                    "options": {
                                                        "ibgp": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                },
                                            },
                                        }
                                    },
                                },
                                "scan_time": {"type": "int"},
                            },
                        },
                        "default_martian_check_disable": {"type": "bool"},
                        "distance": {
                            "type": "dict",
                            "options": {
                                "routes_external_to_as": {"type": "int"},
                                "routes_internal_to_as": {"type": "int"},
                                "local_routes": {"type": "int"},
                            },
                        },
                        "dynamic_med": {"type": "int"},
                        "maximum_paths": {
                            "type": "dict",
                            "options": {
                                "ibgp": {
                                    "type": "dict",
                                    "options": {
                                        "max_path_value": {"type": "int"},
                                        "order_igp_metric": {"type": "bool"},
                                        "selective_order_igp_metric": {
                                            "type": "bool"
                                        },
                                        "unequal_cost": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "order_igp_metric": {
                                                    "type": "bool"
                                                },
                                                "selective_order_igp_metric": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                    },
                                },
                                "ebgp": {
                                    "type": "dict",
                                    "options": {
                                        "max_path_value": {"type": "int"},
                                        "order_igp_metric": {"type": "bool"},
                                        "selective_order_igp_metric": {
                                            "type": "bool"
                                        },
                                    },
                                },
                                "eibgp": {
                                    "type": "dict",
                                    "options": {
                                        "max_path_value": {"type": "int"},
                                        "order_igp_metric": {"type": "bool"},
                                        "selective_order_igp_metric": {
                                            "type": "bool"
                                        },
                                    },
                                },
                            },
                        },
                        "networks": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "network": {"type": "str"},
                                "backdoor_route_policy": {"type": "str"},
                                "route_policy": {"type": "str"},
                            },
                        },
                        "nexthop": {
                            "type": "dict",
                            "options": {
                                "resolution_prefix_length_minimum": {
                                    "type": "int",
                                    "choices": [0, 32],
                                },
                                "route_policy": {"type": "str"},
                                "trigger_delay_critical": {"type": "int"},
                                "trigger_delay_non_critical": {"type": "int"},
                            },
                        },
                        "optimal_route_reflection": {
                            "type": "dict",
                            "options": {
                                "group_name": {"type": "str"},
                                "primary_address": {"type": "str"},
                                "secondary_address": {"type": "str"},
                            },
                        },
                        "permanent_network_route_policy": {"type": "str"},
                        "retain_local_label": {"type": "int"},
                        "table_policy": {"type": "str"},
                        "update": {
                            "type": "dict",
                            "options": {
                                "limit": {
                                    "type": "dict",
                                    "options": {
                                        "sub_group": {
                                            "type": "dict",
                                            "options": {
                                                "ibgp": {"type": "int"},
                                                "ebgp": {"type": "int"},
                                            },
                                        },
                                        "address_family": {"type": "int"},
                                    },
                                },
                                "wait_install": {"type": "bool"},
                            },
                        },
                        "redistribute": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "protocol": {
                                    "type": "str",
                                    "choices": [
                                        "ospf",
                                        "application",
                                        "eigrp",
                                        "isis",
                                        "static",
                                        "connected",
                                        "lisp",
                                        "mobile",
                                        "rip",
                                        "subscriber",
                                    ],
                                    "required": True,
                                },
                                "id": {"type": "str"},
                                "metric": {"type": "int"},
                                "route_policy": {"type": "str"},
                                "internal": {"type": "bool"},
                                "external": {"type": "bool"},
                                "level": {
                                    "type": "str",
                                    "choices": ["1", "2", "1-inter-area"],
                                },
                                "nssa_external": {"type": "bool"},
                                "external_ospf": {
                                    "type": "int",
                                    "choices": [1, 2],
                                },
                            },
                        },
                        "inter_as_install": {"type": "bool"},
                        "segmented_multicast": {"type": "bool"},
                        "global_table_multicast": {"type": "bool"},
                        "vrf_all_conf": {
                            "type": "dict",
                            "options": {
                                "source_rt_import_policy": {"type": "bool"},
                                "table_policy": {"type": "str"},
                                "label_mode": {
                                    "type": "dict",
                                    "options": {
                                        "per_ce": {"type": "bool"},
                                        "per_vrf": {"type": "bool"},
                                        "route_policy": {"type": "str"},
                                    },
                                },
                            },
                        },
                        "weight": {
                            "type": "dict",
                            "options": {
                                "reset_on_import_disable": {"type": "bool"},
                                "reset_on_import": {"type": "bool"},
                            },
                        },
                        "allow_vpn_default_originate": {"type": "bool"},
                        "label_mode": {
                            "type": "dict",
                            "options": {
                                "per_ce": {"type": "bool"},
                                "per_vrf": {"type": "bool"},
                                "route_policy": {"type": "str"},
                                "per_prefix": {"type": "bool"},
                            },
                        },
                        "mvpn_single_forwarder_selection_all": {
                            "type": "bool"
                        },
                        "mvpn_single_forwarder_selection_highest_ip_address": {
                            "type": "bool"
                        },
                        "route_target_download": {"type": "bool"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
