"""Generated client library for cloudidentity version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudidentity.v1alpha1 import cloudidentity_v1alpha1_messages as messages


class CloudidentityV1alpha1(base_api.BaseApiClient):
  """Generated client library for service cloudidentity version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudidentity.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudidentity.mtls.googleapis.com/'

  _PACKAGE = 'cloudidentity'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-identity.groups', 'https://www.googleapis.com/auth/cloud-identity.groups.readonly', 'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudidentityV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudidentity handle."""
    url = url or self.BASE_URL
    super(CloudidentityV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.customers_userInvitations = self.CustomersUserInvitationsService(self)
    self.customers = self.CustomersService(self)
    self.groups_memberships = self.GroupsMembershipsService(self)
    self.groups = self.GroupsService(self)

  class CustomersUserInvitationsService(base_api.BaseApiService):
    """Service class for the customers_userInvitations resource."""

    _NAME = 'customers_userInvitations'

    def __init__(self, client):
      super(CloudidentityV1alpha1.CustomersUserInvitationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels a UserInvitation sent.

      Args:
        request: (CloudidentityCustomersUserInvitationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/customers/{customersId}/userInvitations/{userInvitationsId}:cancel',
        http_method='POST',
        method_id='cloudidentity.customers.userInvitations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='cancelUserInvitationRequest',
        request_type_name='CloudidentityCustomersUserInvitationsCancelRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve a `UserInvitation` resource.

      Args:
        request: (CloudidentityCustomersUserInvitationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UserInvitation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/customers/{customersId}/userInvitations/{userInvitationsId}',
        http_method='GET',
        method_id='cloudidentity.customers.userInvitations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='CloudidentityCustomersUserInvitationsGetRequest',
        response_type_name='UserInvitation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of UserInvitations.

      Args:
        request: (CloudidentityCustomersUserInvitationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListUserInvitationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/customers/{customersId}/userInvitations',
        http_method='GET',
        method_id='cloudidentity.customers.userInvitations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/userInvitations',
        request_field='',
        request_type_name='CloudidentityCustomersUserInvitationsListRequest',
        response_type_name='ListUserInvitationsResponse',
        supports_download=False,
    )

    def Send(self, request, global_params=None):
      r"""Send UserInvitation to email. if the UserInvitation does not exist for this request, and it is a valid request, a UserInvitation will be created in this request.

      Args:
        request: (CloudidentityCustomersUserInvitationsSendRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Send')
      return self._RunMethod(
          config, request, global_params=global_params)

    Send.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/customers/{customersId}/userInvitations/{userInvitationsId}:send',
        http_method='POST',
        method_id='cloudidentity.customers.userInvitations.send',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:send',
        request_field='sendUserInvitationRequest',
        request_type_name='CloudidentityCustomersUserInvitationsSendRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class CustomersService(base_api.BaseApiService):
    """Service class for the customers resource."""

    _NAME = 'customers'

    def __init__(self, client):
      super(CloudidentityV1alpha1.CustomersService, self).__init__(client)
      self._upload_configs = {
          }

  class GroupsMembershipsService(base_api.BaseApiService):
    """Service class for the groups_memberships resource."""

    _NAME = 'groups_memberships'

    def __init__(self, client):
      super(CloudidentityV1alpha1.GroupsMembershipsService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckTransitiveMembership(self, request, global_params=None):
      r"""Check a potential member for membership in a group.

      Args:
        request: (CloudidentityGroupsMembershipsCheckTransitiveMembershipRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckTransitiveMembershipResponse) The response message.
      """
      config = self.GetMethodConfig('CheckTransitiveMembership')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckTransitiveMembership.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships:checkTransitiveMembership',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.checkTransitiveMembership',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['query'],
        relative_path='v1alpha1/{+parent}/memberships:checkTransitiveMembership',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsCheckTransitiveMembershipRequest',
        response_type_name='CheckTransitiveMembershipResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships',
        http_method='POST',
        method_id='cloudidentity.groups.memberships.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/memberships',
        request_field='membership',
        request_type_name='CloudidentityGroupsMembershipsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships/{membershipsId}',
        http_method='DELETE',
        method_id='cloudidentity.groups.memberships.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Membership) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships/{membershipsId}',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsGetRequest',
        response_type_name='Membership',
        supports_download=False,
    )

    def GetMembershipGraph(self, request, global_params=None):
      r"""Get a membership graph of a member or member/group.

      Args:
        request: (CloudidentityGroupsMembershipsGetMembershipGraphRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('GetMembershipGraph')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetMembershipGraph.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships:getMembershipGraph',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.getMembershipGraph',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['query'],
        relative_path='v1alpha1/{+parent}/memberships:getMembershipGraph',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsGetMembershipGraphRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the `Membership`s within a `Group`.

      Args:
        request: (CloudidentityGroupsMembershipsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'view'],
        relative_path='v1alpha1/{+parent}/memberships',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsListRequest',
        response_type_name='ListMembershipsResponse',
        supports_download=False,
    )

    def Lookup(self, request, global_params=None):
      r"""Looks up the [resource name](https://cloud.google.com/apis/design/resource_names) of a `Membership` by its `EntityKey`.

      Args:
        request: (CloudidentityGroupsMembershipsLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LookupMembershipNameResponse) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships:lookup',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.lookup',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['memberKey_id', 'memberKey_namespace'],
        relative_path='v1alpha1/{+parent}/memberships:lookup',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsLookupRequest',
        response_type_name='LookupMembershipNameResponse',
        supports_download=False,
    )

    def ModifyMembershipRoles(self, request, global_params=None):
      r"""Modifies the `MembershipRole`s of a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsModifyMembershipRolesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ModifyMembershipRolesResponse) The response message.
      """
      config = self.GetMethodConfig('ModifyMembershipRoles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyMembershipRoles.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships/{membershipsId}:modifyMembershipRoles',
        http_method='POST',
        method_id='cloudidentity.groups.memberships.modifyMembershipRoles',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:modifyMembershipRoles',
        request_field='modifyMembershipRolesRequest',
        request_type_name='CloudidentityGroupsMembershipsModifyMembershipRolesRequest',
        response_type_name='ModifyMembershipRolesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a `Membership`.

      Args:
        request: (CloudidentityGroupsMembershipsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships/{membershipsId}',
        http_method='PATCH',
        method_id='cloudidentity.groups.memberships.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='membership',
        request_type_name='CloudidentityGroupsMembershipsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SearchTransitiveGroups(self, request, global_params=None):
      r"""Search transitive groups of a member.

      Args:
        request: (CloudidentityGroupsMembershipsSearchTransitiveGroupsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchTransitiveGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('SearchTransitiveGroups')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchTransitiveGroups.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships:searchTransitiveGroups',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.searchTransitiveGroups',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'query'],
        relative_path='v1alpha1/{+parent}/memberships:searchTransitiveGroups',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsSearchTransitiveGroupsRequest',
        response_type_name='SearchTransitiveGroupsResponse',
        supports_download=False,
    )

    def SearchTransitiveMemberships(self, request, global_params=None):
      r"""Search transitive memberships of a group.

      Args:
        request: (CloudidentityGroupsMembershipsSearchTransitiveMembershipsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchTransitiveMembershipsResponse) The response message.
      """
      config = self.GetMethodConfig('SearchTransitiveMemberships')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchTransitiveMemberships.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}/memberships:searchTransitiveMemberships',
        http_method='GET',
        method_id='cloudidentity.groups.memberships.searchTransitiveMemberships',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/memberships:searchTransitiveMemberships',
        request_field='',
        request_type_name='CloudidentityGroupsMembershipsSearchTransitiveMembershipsRequest',
        response_type_name='SearchTransitiveMembershipsResponse',
        supports_download=False,
    )

  class GroupsService(base_api.BaseApiService):
    """Service class for the groups resource."""

    _NAME = 'groups'

    def __init__(self, client):
      super(CloudidentityV1alpha1.GroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a `Group`.

      Args:
        request: (CloudidentityGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudidentity.groups.create',
        ordered_params=[],
        path_params=[],
        query_params=['initialGroupConfig'],
        relative_path='v1alpha1/groups',
        request_field='group',
        request_type_name='CloudidentityGroupsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a `Group`.

      Args:
        request: (CloudidentityGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}',
        http_method='DELETE',
        method_id='cloudidentity.groups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='CloudidentityGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a `Group`.

      Args:
        request: (CloudidentityGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}',
        http_method='GET',
        method_id='cloudidentity.groups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='CloudidentityGroupsGetRequest',
        response_type_name='Group',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the `Group`s under a customer or namespace.

      Args:
        request: (CloudidentityGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudidentity.groups.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent', 'view'],
        relative_path='v1alpha1/groups',
        request_field='',
        request_type_name='CloudidentityGroupsListRequest',
        response_type_name='ListGroupsResponse',
        supports_download=False,
    )

    def Lookup(self, request, global_params=None):
      r"""Looks up the [resource name](https://cloud.google.com/apis/design/resource_names) of a `Group` by its `EntityKey`.

      Args:
        request: (CloudidentityGroupsLookupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LookupGroupNameResponse) The response message.
      """
      config = self.GetMethodConfig('Lookup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lookup.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudidentity.groups.lookup',
        ordered_params=[],
        path_params=[],
        query_params=['groupKey_id', 'groupKey_namespace'],
        relative_path='v1alpha1/groups:lookup',
        request_field='',
        request_type_name='CloudidentityGroupsLookupRequest',
        response_type_name='LookupGroupNameResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a `Group`.

      Args:
        request: (CloudidentityGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/groups/{groupsId}',
        http_method='PATCH',
        method_id='cloudidentity.groups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='group',
        request_type_name='CloudidentityGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for `Group`s matching a specified query.

      Args:
        request: (CloudidentityGroupsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudidentity.groups.search',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'query', 'view'],
        relative_path='v1alpha1/groups:search',
        request_field='',
        request_type_name='CloudidentityGroupsSearchRequest',
        response_type_name='SearchGroupsResponse',
        supports_download=False,
    )
