require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_VMPARAM_H_)) {
    eval 'sub _MACHINE_VMPARAM_H_ () {1;}' unless defined(&_MACHINE_VMPARAM_H_);
    eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(512*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(8*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(64*1024*1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&SGROWSIZ)) {
	eval 'sub SGROWSIZ () {(128*1024);}' unless defined(&SGROWSIZ);
    }
    if(defined(&PAE)) {
	eval 'sub VM_PHYSSEG_SPARSE () {1;}' unless defined(&VM_PHYSSEG_SPARSE);
    } else {
	eval 'sub VM_PHYSSEG_DENSE () {1;}' unless defined(&VM_PHYSSEG_DENSE);
    }
    eval 'sub VM_PHYSSEG_MAX () {17;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_NFREEPOOL () {1;}' unless defined(&VM_NFREEPOOL);
    eval 'sub VM_FREEPOOL_DEFAULT () {0;}' unless defined(&VM_FREEPOOL_DEFAULT);
    eval 'sub VM_FREEPOOL_DIRECT () {0;}' unless defined(&VM_FREEPOOL_DIRECT);
    eval 'sub VM_NFREELIST () {2;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    eval 'sub VM_FREELIST_ISADMA () {1;}' unless defined(&VM_FREELIST_ISADMA);
    if(defined(&PAE)) {
	eval 'sub VM_NFREEORDER () {10;}' unless defined(&VM_NFREEORDER);
    } else {
	eval 'sub VM_NFREEORDER () {11;}' unless defined(&VM_NFREEORDER);
    }
    unless(defined(&VM_NRESERVLEVEL)) {
	eval 'sub VM_NRESERVLEVEL () {1;}' unless defined(&VM_NRESERVLEVEL);
    }
    unless(defined(&VM_LEVEL_0_ORDER)) {
	if(defined(&PAE) || defined(&PAE_TABLES)) {
	    eval 'sub VM_LEVEL_0_ORDER () {9;}' unless defined(&VM_LEVEL_0_ORDER);
	} else {
	    eval 'sub VM_LEVEL_0_ORDER () {10;}' unless defined(&VM_LEVEL_0_ORDER);
	}
    }
    unless(defined(&KERNLOAD)) {
	eval 'sub KERNLOAD () {(1<<  &PDRSHIFT);}' unless defined(&KERNLOAD);
    }
    eval 'sub VM_MAX_KERNEL_ADDRESS () { &VADDR( &KPTDI+ &NKPDE-1,  &NPTEPG-1);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () { &VADDR( &PTDPTDI,  &PTDPTDI);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub KERNBASE () { &VADDR( &KPTDI, 0);}' unless defined(&KERNBASE);
    eval 'sub UPT_MAX_ADDRESS () { &VADDR( &PTDPTDI,  &PTDPTDI);}' unless defined(&UPT_MAX_ADDRESS);
    eval 'sub UPT_MIN_ADDRESS () { &VADDR( &PTDPTDI, 0);}' unless defined(&UPT_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () { &VADDR( &PTDPTDI, 0);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub SHAREDPAGE () {( &VM_MAXUSER_ADDRESS -  &PAGE_SIZE);}' unless defined(&SHAREDPAGE);
    eval 'sub USRSTACK () { &SHAREDPAGE;}' unless defined(&USRSTACK);
    eval 'sub VM_MAX_ADDRESS () { &VADDR( &PTDPTDI,  &PTDPTDI);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_ADDRESS () {(( &vm_offset_t)0);}' unless defined(&VM_MIN_ADDRESS);
    unless(defined(&VM_KMEM_SIZE_SCALE)) {
	eval 'sub VM_KMEM_SIZE_SCALE () {(3);}' unless defined(&VM_KMEM_SIZE_SCALE);
    }
    unless(defined(&VM_KMEM_SIZE_MIN)) {
	eval 'sub VM_KMEM_SIZE_MIN () {(12* 1024* 1024);}' unless defined(&VM_KMEM_SIZE_MIN);
    }
    unless(defined(&VM_KMEM_SIZE_MAX)) {
	eval 'sub VM_KMEM_SIZE_MAX () {((((( &VM_MAX_KERNEL_ADDRESS -  &VM_MIN_KERNEL_ADDRESS) >> ( &PDRSHIFT - 2)) + 5) / 10) <<  &PDRSHIFT);}' unless defined(&VM_KMEM_SIZE_MAX);
    }
    unless(defined(&VM_INITIAL_PAGEIN)) {
	eval 'sub VM_INITIAL_PAGEIN () {16;}' unless defined(&VM_INITIAL_PAGEIN);
    }
    eval 'sub ZERO_REGION_SIZE () {(64* 1024);}' unless defined(&ZERO_REGION_SIZE);
    unless(defined(&VM_MAX_AUTOTUNE_MAXUSERS)) {
	eval 'sub VM_MAX_AUTOTUNE_MAXUSERS () {384;}' unless defined(&VM_MAX_AUTOTUNE_MAXUSERS);
    }
    eval 'sub SFBUF () {1;}' unless defined(&SFBUF);
    eval 'sub SFBUF_MAP () {1;}' unless defined(&SFBUF_MAP);
    eval 'sub SFBUF_CPUSET () {1;}' unless defined(&SFBUF_CPUSET);
    eval 'sub SFBUF_PROCESS_PAGE () {1;}' unless defined(&SFBUF_PROCESS_PAGE);
}
1;
