require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_ATOMIC_H_)) {
    eval 'sub _MACHINE_ATOMIC_H_ () {1;}' unless defined(&_MACHINE_ATOMIC_H_);
    unless(defined(&_SYS_CDEFS_H_)) {
	die("this\ file\ needs\ sys\/cdefs\.h\ as\ a\ prerequisite");
    }
    if(defined(&_KERNEL)) {
	require 'machine/md_var.ph';
	require 'machine/specialreg.ph';
    }
    unless(defined(&__OFFSETOF_MONITORBUF)) {
	eval 'sub __OFFSETOF_MONITORBUF () {0x180;}' unless defined(&__OFFSETOF_MONITORBUF);
	eval 'sub __mbk {
	    my($void) = @_;
    	    eval q({  &__asm  &__volatile(\\"lock; addl $0,%%fs:%0\\" : \\"+m\\" (* &__OFFSETOF_MONITORBUF) : : \\"memory\\", \\"cc\\"); });
	}' unless defined(&__mbk);
	eval 'sub __mbu {
	    my($void) = @_;
    	    eval q({  &__asm  &__volatile(\\"lock; addl $0,(%%esp)\\" : : : \\"memory\\", \\"cc\\"); });
	}' unless defined(&__mbu);
    }
    if(defined(&KLD_MODULE) || !defined(&__GNUCLIKE_ASM)) {
	eval 'sub ATOMIC_ASM {
	    my($NAME, $TYPE, $OP, $CONS, $V) = @_;
    	    eval q( &void  &atomic_$NAME &_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v);  &void  &atomic_$NAME &_barr_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v));
	}' unless defined(&ATOMIC_ASM);
	eval 'sub ATOMIC_LOAD {
	    my($TYPE) = @_;
    	    eval q( &u_$TYPE  &atomic_load_acq_$TYPE( &volatile  &u_$TYPE * &p));
	}' unless defined(&ATOMIC_LOAD);
	eval 'sub ATOMIC_STORE {
	    my($TYPE) = @_;
    	    eval q( &void  &atomic_store_rel_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v));
	}' unless defined(&ATOMIC_STORE);
    } else {
	if(defined(&SMP) || !defined(&_KERNEL)) {
	    eval 'sub MPLOCKED () {"lock ; ";}' unless defined(&MPLOCKED);
	} else {
	    eval 'sub MPLOCKED () {1;}' unless defined(&MPLOCKED);
	}
	eval 'sub ATOMIC_ASM {
	    my($NAME, $TYPE, $OP, $CONS, $V) = @_;
    	    eval q( &static  &__inline  &void  &atomic_$NAME &_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v){  &__asm  &__volatile( &MPLOCKED $OP : \\"+m\\" (* &p) : $CONS ($V) : \\"cc\\"); }  &static  &__inline  &void  &atomic_$NAME &_barr_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v){  &__asm  &__volatile( &MPLOCKED $OP : \\"+m\\" (* &p) : $CONS ($V) : \\"memory\\", \\"cc\\"); } \'struct __hack\');
	}' unless defined(&ATOMIC_ASM);
	eval 'sub atomic_fcmpset_int {
	    my($dst,$expect,$src) = @_;
    	    eval q({ \'u_char\'  &res;  &__asm  &__volatile( \\"	\\"  &MPLOCKED \\"		\\" \\"	cmpxchgl %3,%1 ;	\\" \\"       sete	%0 ;		\\" \\"# atomic_cmpset_int\\" : \\"=q\\" ( &res), \\"+m\\" (*$dst), \\"+a\\" (*$expect) : \\"r\\" ($src) : \\"memory\\", \\"cc\\"); ( &res); });
	}' unless defined(&atomic_fcmpset_int);
	eval 'sub atomic_testandset_int {
	    my($p,$v) = @_;
    	    eval q({ \'u_char\'  &res;  &__asm  &__volatile( \\"	\\"  &MPLOCKED \\"		\\" \\"	btsl	%2,%1 ;		\\" \\"	setc	%0 ;		\\" \\"# atomic_testandset_int\\" : \\"=q\\" ( &res), \\"+m\\" (*$p) : \\"Ir\\" ($v & 0x1f) : \\"cc\\"); ( &res); });
	}' unless defined(&atomic_testandset_int);
	eval 'sub atomic_testandclear_int {
	    my($p,$v) = @_;
    	    eval q({ \'u_char\'  &res;  &__asm  &__volatile( \\"	\\"  &MPLOCKED \\"		\\" \\"	btrl	%2,%1 ;		\\" \\"	setc	%0 ;		\\" \\"# atomic_testandclear_int\\" : \\"=q\\" ( &res), \\"+m\\" (*$p) : \\"Ir\\" ($v & 0x1f) : \\"cc\\"); ( &res); });
	}' unless defined(&atomic_testandclear_int);
	if(defined(&_KERNEL)) {
	    if(defined(&SMP)) {
		eval 'sub __storeload_barrier () {
		    eval q( &__mbk());
		}' unless defined(&__storeload_barrier);
	    } else {
		eval 'sub __storeload_barrier () {
		    eval q( &__compiler_membar());
		}' unless defined(&__storeload_barrier);
	    }
	} else {
	    eval 'sub __storeload_barrier () {
	        eval q( &__mbu());
	    }' unless defined(&__storeload_barrier);
	}
	eval 'sub ATOMIC_LOAD {
	    my($TYPE) = @_;
    	    eval q( &static  &__inline  &u_$TYPE  &atomic_load_acq_$TYPE( &volatile  &u_$TYPE * &p) {  &u_$TYPE  &res;  &res = * &p;  &__compiler_membar();  &return ( &res); } \'struct __hack\');
	}' unless defined(&ATOMIC_LOAD);
	eval 'sub ATOMIC_STORE {
	    my($TYPE) = @_;
    	    eval q( &static  &__inline  &void  &atomic_store_rel_$TYPE( &volatile  &u_$TYPE * &p,  &u_$TYPE  &v) {  &__compiler_membar(); * &p =  &v; } \'struct __hack\');
	}' unless defined(&ATOMIC_STORE);
	eval 'sub atomic_thread_fence_acq {
	    my($void) = @_;
    	    eval q({  &__compiler_membar(); });
	}' unless defined(&atomic_thread_fence_acq);
	eval 'sub atomic_thread_fence_rel {
	    my($void) = @_;
    	    eval q({  &__compiler_membar(); });
	}' unless defined(&atomic_thread_fence_rel);
	eval 'sub atomic_thread_fence_acq_rel {
	    my($void) = @_;
    	    eval q({  &__compiler_membar(); });
	}' unless defined(&atomic_thread_fence_acq_rel);
	eval 'sub atomic_thread_fence_seq_cst {
	    my($void) = @_;
    	    eval q({  &__storeload_barrier(); });
	}' unless defined(&atomic_thread_fence_seq_cst);
	if(defined(&_KERNEL)) {
	    if(defined(&WANT_FUNCTIONS)) {
	    }
	    eval 'sub atomic_load_acq_64_i386 {
	        my($p) = @_;
    		eval q({  &volatile  &uint32_t * &q;  &uint64_t  &res;  &q = ( &volatile  &uint32_t *)$p;  &__asm  &__volatile( \\"	pushfl ;		\\" \\"	cli ;			\\" \\"	movl	%1,%%eax ;	\\" \\"	movl	%2,%%edx ;	\\" \\"	popfl\\" : \\"=&A\\" ( &res) : \\"m\\" (* &q), \\"m\\" (*( &q + 1)) : \\"memory\\"); ( &res); });
	    }' unless defined(&atomic_load_acq_64_i386);
	    eval 'sub atomic_store_rel_64_i386 {
	        my($p,$v) = @_;
    		eval q({  &volatile  &uint32_t * &q;  &q = ( &volatile  &uint32_t *)$p;  &__asm  &__volatile( \\"	pushfl ;		\\" \\"	cli ;			\\" \\"	movl	%%eax,%0 ;	\\" \\"	movl	%%edx,%1 ;	\\" \\"	popfl\\" : \\"=m\\" (* &q), \\"=m\\" (*( &q + 1)) : \\"A\\" ($v) : \\"memory\\"); });
	    }' unless defined(&atomic_store_rel_64_i386);
	    eval 'sub atomic_swap_64_i386 {
	        my($p,$v) = @_;
    		eval q({  &volatile  &uint32_t * &q;  &uint64_t  &res;  &q = ( &volatile  &uint32_t *)$p;  &__asm  &__volatile( \\"	pushfl ;		\\" \\"	cli ;			\\" \\"	movl	%1,%%eax ;	\\" \\"	movl	%2,%%edx ;	\\" \\"	movl	%4,%2 ;		\\" \\"	movl	%3,%1 ;		\\" \\"	popfl\\" : \\"=&A\\" ( &res), \\"+m\\" (* &q), \\"+m\\" (*( &q + 1)) : \\"r\\" (( &uint32_t)$v), \\"r\\" (( &uint32_t)($v >> 32))); ( &res); });
	    }' unless defined(&atomic_swap_64_i386);
	    eval 'sub atomic_cmpset_64_i586 {
	        my($dst,$expect,$src) = @_;
    		eval q({ \'u_char\'  &res;  &__asm  &__volatile( \\"	\\"  &MPLOCKED \\"		\\" \\"	cmpxchg8b %1 ;		\\" \\"	sete	%0\\" : \\"=q\\" ( &res), \\"+m\\" (*$dst), \\"+A\\" ($expect) : \\"b\\" (( &uint32_t)$src), \\"c\\" (( &uint32_t)($src >> 32)) : \\"memory\\", \\"cc\\"); ( &res); });
	    }' unless defined(&atomic_cmpset_64_i586);
	    eval 'sub atomic_load_acq_64_i586 {
	        my($p) = @_;
    		eval q({  &uint64_t  &res;  &__asm  &__volatile( \\"	movl	%%ebx,%%eax ;	\\" \\"	movl	%%ecx,%%edx ;	\\" \\"	\\"  &MPLOCKED \\"		\\" \\"	cmpxchg8b %1\\" : \\"=&A\\" ( &res), \\"+m\\" (*$p) : : \\"memory\\", \\"cc\\"); ( &res); });
	    }' unless defined(&atomic_load_acq_64_i586);
	    eval 'sub atomic_store_rel_64_i586 {
	        my($p,$v) = @_;
    		eval q({  &__asm  &__volatile( \\"	movl	%%eax,%%ebx ;	\\" \\"	movl	%%edx,%%ecx ;	\\" \\"1:				\\" \\"	\\"  &MPLOCKED \\"		\\" \\"	cmpxchg8b %0 ;		\\" \\"	jne	1b\\" : \\"+m\\" (*$p), \\"+A\\" ($v) : : \\"ebx\\", \\"ecx\\", \\"memory\\", \\"cc\\"); });
	    }' unless defined(&atomic_store_rel_64_i586);
	    eval 'sub atomic_swap_64_i586 {
	        my($p,$v) = @_;
    		eval q({  &__asm  &__volatile( \\"	movl	%%eax,%%ebx ;	\\" \\"	movl	%%edx,%%ecx ;	\\" \\"1:				\\" \\"	\\"  &MPLOCKED \\"		\\" \\"	cmpxchg8b %0 ;		\\" \\"	jne	1b\\" : \\"+m\\" (*$p), \\"+A\\" ($v) : : \\"ebx\\", \\"ecx\\", \\"memory\\", \\"cc\\"); ($v); });
	    }' unless defined(&atomic_swap_64_i586);
	    eval 'sub atomic_cmpset_64 {
	        my($dst,$expect,$src) = @_;
    		eval q({  &if (( &cpu_feature &  &CPUID_CX8) == 0) ( &atomic_cmpset_64_i386($dst, $expect, $src));  &else ( &atomic_cmpset_64_i586($dst, $expect, $src)); });
	    }' unless defined(&atomic_cmpset_64);
	    eval 'sub atomic_load_acq_64 {
	        my($p) = @_;
    		eval q({  &if (( &cpu_feature &  &CPUID_CX8) == 0) ( &atomic_load_acq_64_i386($p));  &else ( &atomic_load_acq_64_i586($p)); });
	    }' unless defined(&atomic_load_acq_64);
	    eval 'sub atomic_store_rel_64 {
	        my($p,$v) = @_;
    		eval q({  &if (( &cpu_feature &  &CPUID_CX8) == 0)  &atomic_store_rel_64_i386($p, $v);  &else  &atomic_store_rel_64_i586($p, $v); });
	    }' unless defined(&atomic_store_rel_64);
	    eval 'sub atomic_swap_64 {
	        my($p,$v) = @_;
    		eval q({  &if (( &cpu_feature &  &CPUID_CX8) == 0) ( &atomic_swap_64_i386($p, $v));  &else ( &atomic_swap_64_i586($p, $v)); });
	    }' unless defined(&atomic_swap_64);
	}
    }
    eval 'sub ATOMIC_LOADSTORE {
        my($TYPE) = @_;
	    eval q( &ATOMIC_LOAD($TYPE);  &ATOMIC_STORE($TYPE));
    }' unless defined(&ATOMIC_LOADSTORE);
    undef(&ATOMIC_ASM) if defined(&ATOMIC_ASM);
    undef(&ATOMIC_LOAD) if defined(&ATOMIC_LOAD);
    undef(&ATOMIC_STORE) if defined(&ATOMIC_STORE);
    undef(&ATOMIC_LOADSTORE) if defined(&ATOMIC_LOADSTORE);
    unless(defined(&WANT_FUNCTIONS)) {
	eval 'sub atomic_cmpset_long {
	    my($dst,$expect,$src) = @_;
    	    eval q({ ( &atomic_cmpset_int(( &volatile \'u_int\' *)$dst, $expect, $src)); });
	}' unless defined(&atomic_cmpset_long);
	eval 'sub atomic_fetchadd_long {
	    my($p,$v) = @_;
    	    eval q({ ( &atomic_fetchadd_int(( &volatile \'u_int\' *)$p, $v)); });
	}' unless defined(&atomic_fetchadd_long);
	eval 'sub atomic_testandset_long {
	    my($p,$v) = @_;
    	    eval q({ ( &atomic_testandset_int(( &volatile \'u_int\' *)$p, $v)); });
	}' unless defined(&atomic_testandset_long);
	eval 'sub atomic_testandclear_long {
	    my($p,$v) = @_;
    	    eval q({ ( &atomic_testandclear_int(( &volatile \'u_int\' *)$p, $v)); });
	}' unless defined(&atomic_testandclear_long);
	if(defined(&__GNUCLIKE_ASM)) {
	    eval 'sub atomic_swap_int {
	        my($p,$v) = @_;
    		eval q({  &__asm  &__volatile( \\"	xchgl	%1,%0 ;		\\" \\"# atomic_swap_int\\" : \\"+r\\" ($v), \\"+m\\" (*$p)); ($v); });
	    }' unless defined(&atomic_swap_int);
	    eval 'sub atomic_swap_long {
	        my($p,$v) = @_;
    		eval q({ ( &atomic_swap_int(( &volatile \'u_int\' *)$p, $v)); });
	    }' unless defined(&atomic_swap_long);
	} else {
	}
	eval 'sub atomic_set_acq_char () { &atomic_set_barr_char;}' unless defined(&atomic_set_acq_char);
	eval 'sub atomic_set_rel_char () { &atomic_set_barr_char;}' unless defined(&atomic_set_rel_char);
	eval 'sub atomic_clear_acq_char () { &atomic_clear_barr_char;}' unless defined(&atomic_clear_acq_char);
	eval 'sub atomic_clear_rel_char () { &atomic_clear_barr_char;}' unless defined(&atomic_clear_rel_char);
	eval 'sub atomic_add_acq_char () { &atomic_add_barr_char;}' unless defined(&atomic_add_acq_char);
	eval 'sub atomic_add_rel_char () { &atomic_add_barr_char;}' unless defined(&atomic_add_rel_char);
	eval 'sub atomic_subtract_acq_char () { &atomic_subtract_barr_char;}' unless defined(&atomic_subtract_acq_char);
	eval 'sub atomic_subtract_rel_char () { &atomic_subtract_barr_char;}' unless defined(&atomic_subtract_rel_char);
	eval 'sub atomic_set_acq_short () {\'atomic_set_barr_short\';}' unless defined(&atomic_set_acq_short);
	eval 'sub atomic_set_rel_short () {\'atomic_set_barr_short\';}' unless defined(&atomic_set_rel_short);
	eval 'sub atomic_clear_acq_short () {\'atomic_clear_barr_short\';}' unless defined(&atomic_clear_acq_short);
	eval 'sub atomic_clear_rel_short () {\'atomic_clear_barr_short\';}' unless defined(&atomic_clear_rel_short);
	eval 'sub atomic_add_acq_short () {\'atomic_add_barr_short\';}' unless defined(&atomic_add_acq_short);
	eval 'sub atomic_add_rel_short () {\'atomic_add_barr_short\';}' unless defined(&atomic_add_rel_short);
	eval 'sub atomic_subtract_acq_short () {\'atomic_subtract_barr_short\';}' unless defined(&atomic_subtract_acq_short);
	eval 'sub atomic_subtract_rel_short () {\'atomic_subtract_barr_short\';}' unless defined(&atomic_subtract_rel_short);
	eval 'sub atomic_set_acq_int () { &atomic_set_barr_int;}' unless defined(&atomic_set_acq_int);
	eval 'sub atomic_set_rel_int () { &atomic_set_barr_int;}' unless defined(&atomic_set_rel_int);
	eval 'sub atomic_clear_acq_int () { &atomic_clear_barr_int;}' unless defined(&atomic_clear_acq_int);
	eval 'sub atomic_clear_rel_int () { &atomic_clear_barr_int;}' unless defined(&atomic_clear_rel_int);
	eval 'sub atomic_add_acq_int () { &atomic_add_barr_int;}' unless defined(&atomic_add_acq_int);
	eval 'sub atomic_add_rel_int () { &atomic_add_barr_int;}' unless defined(&atomic_add_rel_int);
	eval 'sub atomic_subtract_acq_int () { &atomic_subtract_barr_int;}' unless defined(&atomic_subtract_acq_int);
	eval 'sub atomic_subtract_rel_int () { &atomic_subtract_barr_int;}' unless defined(&atomic_subtract_rel_int);
	eval 'sub atomic_cmpset_acq_int () { &atomic_cmpset_int;}' unless defined(&atomic_cmpset_acq_int);
	eval 'sub atomic_cmpset_rel_int () { &atomic_cmpset_int;}' unless defined(&atomic_cmpset_rel_int);
	eval 'sub atomic_fcmpset_acq_int () { &atomic_fcmpset_int;}' unless defined(&atomic_fcmpset_acq_int);
	eval 'sub atomic_fcmpset_rel_int () { &atomic_fcmpset_int;}' unless defined(&atomic_fcmpset_rel_int);
	eval 'sub atomic_set_acq_long () {\'atomic_set_barr_long\';}' unless defined(&atomic_set_acq_long);
	eval 'sub atomic_set_rel_long () {\'atomic_set_barr_long\';}' unless defined(&atomic_set_rel_long);
	eval 'sub atomic_clear_acq_long () {\'atomic_clear_barr_long\';}' unless defined(&atomic_clear_acq_long);
	eval 'sub atomic_clear_rel_long () {\'atomic_clear_barr_long\';}' unless defined(&atomic_clear_rel_long);
	eval 'sub atomic_add_acq_long () {\'atomic_add_barr_long\';}' unless defined(&atomic_add_acq_long);
	eval 'sub atomic_add_rel_long () {\'atomic_add_barr_long\';}' unless defined(&atomic_add_rel_long);
	eval 'sub atomic_subtract_acq_long () {\'atomic_subtract_barr_long\';}' unless defined(&atomic_subtract_acq_long);
	eval 'sub atomic_subtract_rel_long () {\'atomic_subtract_barr_long\';}' unless defined(&atomic_subtract_rel_long);
	eval 'sub atomic_cmpset_acq_long () {\'atomic_cmpset_long\';}' unless defined(&atomic_cmpset_acq_long);
	eval 'sub atomic_cmpset_rel_long () {\'atomic_cmpset_long\';}' unless defined(&atomic_cmpset_rel_long);
	eval 'sub atomic_fcmpset_acq_long () {\'atomic_fcmpset_long\';}' unless defined(&atomic_fcmpset_acq_long);
	eval 'sub atomic_fcmpset_rel_long () {\'atomic_fcmpset_long\';}' unless defined(&atomic_fcmpset_rel_long);
	eval 'sub atomic_readandclear_int {
	    my($p) = @_;
    	    eval q( &atomic_swap_int($p, 0));
	}' unless defined(&atomic_readandclear_int);
	eval 'sub atomic_readandclear_long {
	    my($p) = @_;
    	    eval q( &atomic_swap_long($p, 0));
	}' unless defined(&atomic_readandclear_long);
	eval 'sub atomic_set_8 () { &atomic_set_char;}' unless defined(&atomic_set_8);
	eval 'sub atomic_set_acq_8 () { &atomic_set_acq_char;}' unless defined(&atomic_set_acq_8);
	eval 'sub atomic_set_rel_8 () { &atomic_set_rel_char;}' unless defined(&atomic_set_rel_8);
	eval 'sub atomic_clear_8 () { &atomic_clear_char;}' unless defined(&atomic_clear_8);
	eval 'sub atomic_clear_acq_8 () { &atomic_clear_acq_char;}' unless defined(&atomic_clear_acq_8);
	eval 'sub atomic_clear_rel_8 () { &atomic_clear_rel_char;}' unless defined(&atomic_clear_rel_8);
	eval 'sub atomic_add_8 () { &atomic_add_char;}' unless defined(&atomic_add_8);
	eval 'sub atomic_add_acq_8 () { &atomic_add_acq_char;}' unless defined(&atomic_add_acq_8);
	eval 'sub atomic_add_rel_8 () { &atomic_add_rel_char;}' unless defined(&atomic_add_rel_8);
	eval 'sub atomic_subtract_8 () { &atomic_subtract_char;}' unless defined(&atomic_subtract_8);
	eval 'sub atomic_subtract_acq_8 () { &atomic_subtract_acq_char;}' unless defined(&atomic_subtract_acq_8);
	eval 'sub atomic_subtract_rel_8 () { &atomic_subtract_rel_char;}' unless defined(&atomic_subtract_rel_8);
	eval 'sub atomic_load_acq_8 () { &atomic_load_acq_char;}' unless defined(&atomic_load_acq_8);
	eval 'sub atomic_store_rel_8 () { &atomic_store_rel_char;}' unless defined(&atomic_store_rel_8);
	eval 'sub atomic_set_16 () {\'atomic_set_short\';}' unless defined(&atomic_set_16);
	eval 'sub atomic_set_acq_16 () {\'atomic_set_acq_short\';}' unless defined(&atomic_set_acq_16);
	eval 'sub atomic_set_rel_16 () {\'atomic_set_rel_short\';}' unless defined(&atomic_set_rel_16);
	eval 'sub atomic_clear_16 () {\'atomic_clear_short\';}' unless defined(&atomic_clear_16);
	eval 'sub atomic_clear_acq_16 () {\'atomic_clear_acq_short\';}' unless defined(&atomic_clear_acq_16);
	eval 'sub atomic_clear_rel_16 () {\'atomic_clear_rel_short\';}' unless defined(&atomic_clear_rel_16);
	eval 'sub atomic_add_16 () {\'atomic_add_short\';}' unless defined(&atomic_add_16);
	eval 'sub atomic_add_acq_16 () {\'atomic_add_acq_short\';}' unless defined(&atomic_add_acq_16);
	eval 'sub atomic_add_rel_16 () {\'atomic_add_rel_short\';}' unless defined(&atomic_add_rel_16);
	eval 'sub atomic_subtract_16 () {\'atomic_subtract_short\';}' unless defined(&atomic_subtract_16);
	eval 'sub atomic_subtract_acq_16 () {\'atomic_subtract_acq_short\';}' unless defined(&atomic_subtract_acq_16);
	eval 'sub atomic_subtract_rel_16 () {\'atomic_subtract_rel_short\';}' unless defined(&atomic_subtract_rel_16);
	eval 'sub atomic_load_acq_16 () {\'atomic_load_acq_short\';}' unless defined(&atomic_load_acq_16);
	eval 'sub atomic_store_rel_16 () {\'atomic_store_rel_short\';}' unless defined(&atomic_store_rel_16);
	eval 'sub atomic_set_32 () { &atomic_set_int;}' unless defined(&atomic_set_32);
	eval 'sub atomic_set_acq_32 () { &atomic_set_acq_int;}' unless defined(&atomic_set_acq_32);
	eval 'sub atomic_set_rel_32 () { &atomic_set_rel_int;}' unless defined(&atomic_set_rel_32);
	eval 'sub atomic_clear_32 () { &atomic_clear_int;}' unless defined(&atomic_clear_32);
	eval 'sub atomic_clear_acq_32 () { &atomic_clear_acq_int;}' unless defined(&atomic_clear_acq_32);
	eval 'sub atomic_clear_rel_32 () { &atomic_clear_rel_int;}' unless defined(&atomic_clear_rel_32);
	eval 'sub atomic_add_32 () { &atomic_add_int;}' unless defined(&atomic_add_32);
	eval 'sub atomic_add_acq_32 () { &atomic_add_acq_int;}' unless defined(&atomic_add_acq_32);
	eval 'sub atomic_add_rel_32 () { &atomic_add_rel_int;}' unless defined(&atomic_add_rel_32);
	eval 'sub atomic_subtract_32 () { &atomic_subtract_int;}' unless defined(&atomic_subtract_32);
	eval 'sub atomic_subtract_acq_32 () { &atomic_subtract_acq_int;}' unless defined(&atomic_subtract_acq_32);
	eval 'sub atomic_subtract_rel_32 () { &atomic_subtract_rel_int;}' unless defined(&atomic_subtract_rel_32);
	eval 'sub atomic_load_acq_32 () { &atomic_load_acq_int;}' unless defined(&atomic_load_acq_32);
	eval 'sub atomic_store_rel_32 () { &atomic_store_rel_int;}' unless defined(&atomic_store_rel_32);
	eval 'sub atomic_cmpset_32 () { &atomic_cmpset_int;}' unless defined(&atomic_cmpset_32);
	eval 'sub atomic_cmpset_acq_32 () { &atomic_cmpset_acq_int;}' unless defined(&atomic_cmpset_acq_32);
	eval 'sub atomic_cmpset_rel_32 () { &atomic_cmpset_rel_int;}' unless defined(&atomic_cmpset_rel_32);
	eval 'sub atomic_fcmpset_32 () { &atomic_fcmpset_int;}' unless defined(&atomic_fcmpset_32);
	eval 'sub atomic_fcmpset_acq_32 () { &atomic_fcmpset_acq_int;}' unless defined(&atomic_fcmpset_acq_32);
	eval 'sub atomic_fcmpset_rel_32 () { &atomic_fcmpset_rel_int;}' unless defined(&atomic_fcmpset_rel_32);
	eval 'sub atomic_swap_32 () { &atomic_swap_int;}' unless defined(&atomic_swap_32);
	eval 'sub atomic_readandclear_32 () { &atomic_readandclear_int;}' unless defined(&atomic_readandclear_32);
	eval 'sub atomic_fetchadd_32 () { &atomic_fetchadd_int;}' unless defined(&atomic_fetchadd_32);
	eval 'sub atomic_testandset_32 () { &atomic_testandset_int;}' unless defined(&atomic_testandset_32);
	eval 'sub atomic_testandclear_32 () { &atomic_testandclear_int;}' unless defined(&atomic_testandclear_32);
	eval 'sub atomic_set_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_set_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_set_ptr);
	eval 'sub atomic_set_acq_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_set_acq_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_set_acq_ptr);
	eval 'sub atomic_set_rel_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_set_rel_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_set_rel_ptr);
	eval 'sub atomic_clear_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_clear_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_clear_ptr);
	eval 'sub atomic_clear_acq_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_clear_acq_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_clear_acq_ptr);
	eval 'sub atomic_clear_rel_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_clear_rel_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_clear_rel_ptr);
	eval 'sub atomic_add_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_add_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_add_ptr);
	eval 'sub atomic_add_acq_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_add_acq_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_add_acq_ptr);
	eval 'sub atomic_add_rel_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_add_rel_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_add_rel_ptr);
	eval 'sub atomic_subtract_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_subtract_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_subtract_ptr);
	eval 'sub atomic_subtract_acq_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_subtract_acq_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_subtract_acq_ptr);
	eval 'sub atomic_subtract_rel_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_subtract_rel_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_subtract_rel_ptr);
	eval 'sub atomic_load_acq_ptr {
	    my($p) = @_;
    	    eval q( &atomic_load_acq_int(( &volatile \'u_int\' *)($p)));
	}' unless defined(&atomic_load_acq_ptr);
	eval 'sub atomic_store_rel_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_store_rel_int(( &volatile \'u_int\' *)($p), ($v)));
	}' unless defined(&atomic_store_rel_ptr);
	eval 'sub atomic_cmpset_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_cmpset_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_cmpset_ptr);
	eval 'sub atomic_cmpset_acq_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_cmpset_acq_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_cmpset_acq_ptr);
	eval 'sub atomic_cmpset_rel_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_cmpset_rel_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_cmpset_rel_ptr);
	eval 'sub atomic_fcmpset_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_fcmpset_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_fcmpset_ptr);
	eval 'sub atomic_fcmpset_acq_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_fcmpset_acq_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_fcmpset_acq_ptr);
	eval 'sub atomic_fcmpset_rel_ptr {
	    my($dst, $old, $new) = @_;
    	    eval q( &atomic_fcmpset_rel_int(( &volatile \'u_int\' *), , ($new)));
	}' unless defined(&atomic_fcmpset_rel_ptr);
	eval 'sub atomic_swap_ptr {
	    my($p, $v) = @_;
    	    eval q( &atomic_swap_int(( &volatile \'u_int\' *), ($v)));
	}' unless defined(&atomic_swap_ptr);
	eval 'sub atomic_readandclear_ptr {
	    my($p) = @_;
    	    eval q( &atomic_readandclear_int(( &volatile \'u_int\' *)($p)));
	}' unless defined(&atomic_readandclear_ptr);
    }
    if(defined(&_KERNEL)) {
	eval 'sub mb () {
	    eval q( &__mbk());
	}' unless defined(&mb);
	eval 'sub wmb () {
	    eval q( &__mbk());
	}' unless defined(&wmb);
	eval 'sub rmb () {
	    eval q( &__mbk());
	}' unless defined(&rmb);
    } else {
	eval 'sub mb () {
	    eval q( &__mbu());
	}' unless defined(&mb);
	eval 'sub wmb () {
	    eval q( &__mbu());
	}' unless defined(&wmb);
	eval 'sub rmb () {
	    eval q( &__mbu());
	}' unless defined(&rmb);
    }
}
1;
