function datatableRemoveEmptyRow(table){$("tbody tr.emptyRow",$(table)).remove()}function datatableAddEmptyRow(table,empty_str){var columns=$("thead th",$(table)).filter(function(){return $(this).css("display")!="none"}).length;$("tbody",$(table)).html('<tr class="emptyRow"><td colspan="'+columns+'"><i>'+empty_str+"</i></td></tr>")}function datatableGetNumDisplayedItems(table){return $("tr:not(.emptyRow)",$(table)).length-1}function datatableIsEmpty(table){return datatableGetNumDisplayedItems(table)==0}function datatableGetByForm(form){return $("table",$("#dt-top-details",$(form)).parent())}function datatableUndoAddRow(new_row,empty_str,bt_to_enable,callback_str){if(bt_to_enable)$(bt_to_enable).removeAttr("disabled");var form=$(new_row).closest("form");$(new_row).remove();aysUpdateForm(form);var dt=datatableGetByForm(form);if(datatableIsEmpty(dt))datatableAddEmptyRow(dt,empty_str);if(callback_str)window[callback_str](new_row)}function datatableForEachRow(table,callbacks){$("tr:not(:first)",table).each(function(row_i){if(typeof callbacks==="function"){callbacks.bind(this)(row_i)}else{var i;for(i=0;i<callbacks.length;i++)callbacks[i].bind(this)(row_i)}})}function datatableAddButtonCallback(td_idx,label,bs_class,callback_str,link){$("td:nth-child("+td_idx+")",$(this)).append('<a href="'+link+'" class="add-on btn" style="padding:0.2em;" onclick="'+callback_str+'" role="button"><span class="label '+bs_class+'">'+label+"</span></a>")}function datatableAddDeleteButtonCallback(td_idx,callback_str,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-danger",callback_str,"javascript:void(0)")}function datatableAddActionButtonCallback(td_idx,callback_str,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-info",callback_str,"javascript:void(0)")}function datatableAddLinkButtonCallback(td_idx,link,label){datatableAddButtonCallback.bind(this)(td_idx,label,"label-info","",link)}function datatableMakeSelectUnique(tr_obj,added_rows_prefix,options){options=paramsExtend({on_change:$.noop,selector_fn:function(obj){return obj.find("select").first()}},options);function datatableForeachSelectOtherThan(this_select,added_rows_prefix,selector_fn,callback){$("[id^="+added_rows_prefix+"]").each(function(){var other=selector_fn($(this));if(other[0]!=this_select[0])callback(other)})}function datatableOptionChangeStatus(option_obj,enable){if(enable){option_obj.removeAttr("disabled")}else{var select_obj=option_obj.closest("select");var should_reset=select_obj.val()==option_obj.val();option_obj.attr("disabled","disabled");if(should_reset){var new_val=select_obj.find("option:not([disabled])").first().val();select_obj.val(new_val);select_obj.attr("data-old-val",new_val)}}}function datatableOnSelectEntryChange(added_rows_prefix,selector_fn,change_callback){var old_value=$(this).attr("data-old-val")||"";var new_value=$(this).val()||"";var others=[];if(old_value==new_value)old_value="";datatableForeachSelectOtherThan($(this),added_rows_prefix,selector_fn,function(other){datatableOptionChangeStatus(other.find("option[value='"+old_value+"']"),true);datatableOptionChangeStatus(other.find("option[value='"+new_value+"']"),false);others.push(other)});change_callback($(this),old_value,new_value,others,datatableOptionChangeStatus);$(this).attr("data-old-val",new_value)}function datatableOnAddSelectEntry(select_obj,added_rows_prefix,selector_fn){select_obj.val("");datatableForeachSelectOtherThan(select_obj,added_rows_prefix,selector_fn,function(other){other.trigger("change")});var new_sel=select_obj.find("option:not([disabled])").first();var new_val=new_sel.val();select_obj.val(new_val);select_obj.trigger("change")}var select=options.selector_fn(tr_obj);select.on("change",function(){datatableOnSelectEntryChange.bind(this)(added_rows_prefix,options.selector_fn,options.on_change)});select.on("remove",function(){$(this).val("").trigger("change")});datatableOnAddSelectEntry(select,added_rows_prefix,options.selector_fn)}function datatableOrderedInsert(table,td_idx,to_insert,to_insert_val,cmp_fn){var cmp_fn=cmp_fn||function(a,b){return b-a};var inserted=false;datatableForEachRow(table,function(){if(inserted)return;var tr=$(this);var cmp_val=parseInt($("td:nth-child("+td_idx+")",tr).html());if(!isNaN(cmp_val)&&cmp_fn(cmp_val,to_insert_val)<0){tr.before(to_insert);inserted=true}});if(!inserted)$(table).append(to_insert)}function datatableIsLastPage(table){var lastpage=$("#dt-bottom-details .pagination li:nth-last-child(3)",$(table));return!(lastpage.length==1&&lastpage.hasClass("active")==false)}function aysHandleForm(form_selector,options){if(!form_selector)form_selector="form";if(form_selector==="form"){form_selector='form:not([data-ays-ignore="true"])'}var default_options={submit_selector:'button[type="submit"]:not([data-ays-ignore="true"])',on_dirty_callback:$.noop,on_clean_callback:$.noop,handle_submit_buttons:true,handle_datatable:false,handle_tabs:false,disable_on_dirty:"",ays_options:{}};var o=$.extend(true,{},default_options,options);o.form_selector=form_selector;$(function(){$(o.form_selector).areYouSure(o.ays_options);if(o.handle_submit_buttons)$(o.form_selector).find(o.submit_selector).attr("disabled","disabled");$(o.form_selector).on("dirty.areYouSure",function(){if(o.handle_submit_buttons)$(this).find(o.submit_selector).removeAttr("disabled");if(o.handle_datatable){$(this).find("a.dropdown-toggle").attr("disabled","disabled");$(this).find("ul.pagination a").css("pointer-events","none").css("cursor","default")}if(o.handle_tabs){$(".nav-tabs").find("a").each(function(){if(!$(this).closest("li").hasClass("active"))$(this).removeAttr("data-toggle").closest("li").addClass("disabled")})}$(o.disable_on_dirty).addClass("disabled");o.on_dirty_callback.bind(this)()});$(o.form_selector).on("clean.areYouSure",function(){if(o.handle_submit_buttons)$(this).find(o.submit_selector).attr("disabled","disabled");if(o.handle_datatable){$(this).find("a.dropdown-toggle").removeAttr("disabled");$(this).find("ul.pagination a").css("pointer-events","").css("cursor","")}if(o.handle_tabs){$(".nav-tabs").find("a").each(function(){$(this).attr("data-toggle","tab").closest("li").removeClass("disabled")})}$(o.disable_on_dirty).removeClass("disabled");o.on_clean_callback.bind(this)()})})}function aysResetForm(form_selector){$(form_selector).trigger("reinitialize.areYouSure")}function aysUpdateForm(form_selector){$(form_selector).trigger("rescan.areYouSure")}function aysRecheckForm(form_selector){$(form_selector).trigger("checkform.areYouSure")}function aysGetDirty(form_selector,fields_selector){fields_selector=fields_selector||":input:not(input[type=submit]):not(input[type=button])";var getValue=function($field){if($field.hasClass("ays-ignore")||$field.hasClass("aysIgnore")||$field.attr("data-ays-ignore")||$field.attr("name")===undefined){return null}if($field.is(":disabled")){return"ays-disabled"}var val;var type=$field.attr("type");if($field.is("select")){type="select"}switch(type){case"checkbox":case"radio":val=$field.is(":checked");break;case"select":val="";$field.find("option").each(function(o){var $option=$(this);if($option.is(":selected")){val+=$option.val()}});break;default:val=$field.val()}return val};var isFieldDirty=function($field){var origValue=$field.data("ays-orig");var curValue=getValue($field);var dirty=undefined!==origValue&&origValue!=curValue;return{dirty:dirty,origValue:origValue,curValue:curValue}};var l=[];$(form_selector).find(fields_selector).each(function(){var dirty_status=isFieldDirty($(this));if(dirty_status.dirty){dirty_status.input=$(this);l.push(dirty_status)}});return l}function is_good_ipv4(ipv4){if(/^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$/.test(ipv4)){return true}else{return false}}function is_good_ipv6(ipv6){if(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\:){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ipv6)){return true}else{return false}}function isNumeric(value){return/^\d+$/.test(value)}function is_mac_address(what){return/^([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})$/.test(what)}function is_network_mask(what,optional_mask){var elems=what.split("/");var mask=null;var ip_addr;if(elems.length!=2){if(!optional_mask)return null;else ip_addr=what}else{ip_addr=elems[0];if(!isNumeric(elems[1]))return null;mask=parseInt(elems[1]);if(mask<0)return null}if(is_good_ipv4(ip_addr)){if(mask===null)mask=32;else if(mask>32)return null;return{type:"ipv4",address:ip_addr,mask:mask}}else if(is_good_ipv6(elems[0])){if(mask===null)mask=128;else if(mask>128)return false;return{type:"ipv6",address:ip_addr,mask:mask}}return null}function fbits(bits){var sizes=["bps","Kbit/s","Mbit/s","Gbit/s","Tbit/s"];if(bits<.005)return"0";var bits_log1000=Math.log(bits)/Math.log(1e3);var i=parseInt(Math.floor(bits_log1000));if(i<0||isNaN(i)){i=0}else if(i>=sizes.length){return"> "+sizes[sizes.length-1]}if(i<=1){return Math.round(bits/Math.pow(1e3,i)*100)/100+" "+sizes[i]}else{var ret=parseFloat(bits/Math.pow(1e3,i)).toFixed(2);if(ret%1==0)ret=Math.round(ret);return ret+" "+sizes[i]}}function fbits_from_bytes(bytes){return fbits(bytes*8)}function fpackets(pps){var sizes=["pps","Kpps","Mpps","Gpps","Tpps"];if(pps<.005)return"0";var res=scaleValue(pps,sizes,1e3);return Math.round(res[0]*100)/100+" "+res[1]}function fflows(fps){var sizes=["fps","Kfps","Mfps","Gfps","Tfps"];if(fps<.005)return"0";var res=scaleValue(fps,sizes,1e3);return Math.round(res[0]*100)/100+" "+res[1]}function fint(value){var x=Math.round(value);return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g,",")}function fdate(when){var epoch=when*1e3;var d=new Date(epoch);return d}function capitaliseFirstLetter(string){return string.charAt(0).toUpperCase()+string.slice(1)}String.prototype.startsWith=function(string){return this.indexOf(string)===0};function get_trend(actual,before){if(before===undefined||actual==before){return'<i class="fa fa-minus"></i>'}else{return'<i class="fa fa-arrow-up"></i>'}}function getOSIcon(name){var icon="";if(name.search("Linux")!=-1||name.search("Ubuntu")!=-1)icon="<i class='fa fa-linux fa-lg'></i> ";else if(name.search("Android")!=-1)icon="<i class='fa fa-android fa-lg'></i> ";else if(name.search("Windows")!=-1||name.search("Win32")!=-1||name.search("MSIE")!=-1)icon="<i class='fa fa-windows fa-lg'></i> ";else if(name.search("iPhone")!=-1||name.search("iPad")!=-1||name.search("OS X")!=-1)icon="<i class='fa fa-apple fa-lg'></i> ";return icon}function abbreviateString(str,len){if(!str)return"";if(str.length<len)return str;return str.substring(0,len)+"..."}function bytesToSize(bytes){var precision=2;var kilobyte=1024;var megabyte=kilobyte*1024;var gigabyte=megabyte*1024;var terabyte=gigabyte*1024;if(bytes>=0&&bytes<kilobyte)return bytes.toFixed(precision)+" Bytes";else if(bytes>=kilobyte&&bytes<megabyte)return(bytes/kilobyte).toFixed(precision)+" KB";else if(bytes>=megabyte&&bytes<gigabyte)return(bytes/megabyte).toFixed(precision)+" MB";else if(bytes>=gigabyte&&bytes<terabyte)return(bytes/gigabyte).toFixed(precision)+" GB";else if(bytes>=terabyte)return(bytes/terabyte).toFixed(precision)+" TB";else return bytes.toFixed(precision)+" Bytes"}String.prototype.capitalizeSingleWord=function(){var uc=this.toUpperCase();if(uc=="ASN"||uc=="OS")return uc;else return this.charAt(0).toUpperCase()+this.slice(1)};String.prototype.capitalize=function(){var res=this.split(" ");for(var i in res){res[i]=res[i].capitalizeSingleWord()}return res.join(" ")};function drawTrend(current,last,withColor){if(current==last){return'<i class="fa fa-minus"></i>'}else if(current>last){return'<i class="fa fa-arrow-up"'+withColor+"></i>"}else{return'<i class="fa fa-arrow-down"></i>'}}function toggleAllTabs(enabled){if(enabled===true)$("#historical-tabs-container").find("li").removeClass("disabled").find("a").attr("data-toggle","tab");else $("#historical-tabs-container").find("li").addClass("disabled").find("a").removeAttr("data-toggle")}function disableAllDropdownsAndTabs(){$("select").each(function(){$(this).prop("disabled",true)});toggleAllTabs(false)}function enableAllDropdownsAndTabs(){$("select").each(function(){$(this).prop("disabled",false)});toggleAllTabs(true)}function capitalize(s){return s&&s[0].toUpperCase()+s.slice(1)}function addCommas(nStr){nStr+="";var x=nStr.split(".");var x1=x[0];var x2=x.length>1?"."+x[1]:"";var rgx=/(\d+)(\d{3})/;while(rgx.test(x1)){x1=x1.replace(rgx,"$1"+","+"$2")}return x1+x2}function scaleValue(val,sizes,scale){if(val==0)return[0,sizes[0]];var i=parseInt(Math.floor(Math.log(val)/Math.log(scale)));if(i<0||isNaN(i)){i=0}else if(i>=sizes.length)i=sizes.length-1;return[val/Math.pow(scale,i),sizes[i]]}function formatValue(val){var sizes=["","K","M","G","T"];var res=scaleValue(val,sizes,1e3);return Math.round(res[0])+res[1]}function formatPackets(n){return addCommas(n.toFixed(0))+" Pkts"}function formatFlows(n){return addCommas(n.toFixed(0))+" Flows"}function fmillis(value){var x=Math.round(value);var res=scaleValue(x,["ms","s"],1e3);return res[0]+" "+res[1]}function bytesToVolume(bytes){var sizes=["Bytes","KB","MB","GB","TB"];if(bytes==0)return"0 Bytes";var res=scaleValue(bytes,sizes,1024);return res[0].toFixed(2)+" "+res[1]}function bytesToVolumeAndLabel(bytes){var sizes=["Bytes","KB","MB","GB","TB"];if(bytes==0)return"0 Bytes";var i=parseInt(Math.floor(Math.log(bytes)/Math.log(1024)));return[(bytes/Math.pow(1024,i)).toFixed(2),sizes[i]]}function bitsToSize(bits,factor){factor=factor||1e3;var sizes=["bit/s","kbit/s","Mbit/s","Gbit/s","Tbit/s"];if(bits==0)return"0 bps";var res=scaleValue(bits,sizes,factor);return res[0].toFixed(2)+" "+res[1]}function secondsToTime(seconds){if(seconds<1){return"< 1 sec"}var days=Math.floor(seconds/86400);var hours=Math.floor(seconds/3600-days*24);var minutes=Math.floor(seconds/60-days*1440-hours*60);var sec=seconds%60;var msg="",msg_array=[];if(days>0){years=Math.floor(days/365);if(years>0){days=days%365;msg=years+" year";if(years>1){msg+="s"}msg_array.push(msg);msg=""}msg=days+" day";if(days>1){msg+="s"}msg_array.push(msg);msg=""}if(hours>0){if(hours<10){msg="0"}msg+=hours+":"}if(minutes<10){msg+="0"}msg+=minutes+":";if(sec<10){msg+="0"}msg+=sec;msg_array.push(msg);return msg_array.join(", ")}Date.prototype.format=function(format){var o={"M+":this.getMonth()+1,"d+":this.getDate(),"h+":this.getHours(),"m+":this.getMinutes(),"s+":this.getSeconds(),"q+":Math.floor((this.getMonth()+3)/3),S:this.getMilliseconds()};if(/(y+)/.test(format))format=format.replace(RegExp.$1,(this.getFullYear()+"").substr(4-RegExp.$1.length));for(var k in o)if(new RegExp("("+k+")").test(format))format=format.replace(RegExp.$1,RegExp.$1.length==1?o[k]:("00"+o[k]).substr((""+o[k]).length));return format};function epoch2Seen(epoch){var d=new Date(epoch*1e3);var tdiff=Math.floor((new Date).getTime()/1e3-epoch);return d.format("dd/MM/yyyy hh:mm:ss")+" ["+secondsToTime(tdiff)+" ago]"}function graphGetXAxisTicksFormat(diff_epoch){var tickFormat;if(diff_epoch<=86400){tickFormat="%H:%M:%S"}else if(diff_epoch<=2*86400){tickFormat="%b %e, %H:%M:%S"}else{tickFormat="%b %e"}return tickFormat}function paramsExtend(defaults,override){return $.extend({},defaults,override)}function paramsToForm(form,params){form=$(form);for(var k in params){if(params.hasOwnProperty(k)){var input=$('<input type="hidden" name="'+k+'" value="'+params[k]+'">');input.appendTo(form)}}return form}function paramsPairsEncode(params){var i=0;var res={};for(var k in params){res["key_"+i]=k;res["val_"+i]=params[k];i=i+1}return res}jQuery.fn.extend({disable:function(state){return this.each(function(){var $this=$(this);if($this.is("input, button, textarea, select"))this.disabled=state;else $this.toggleClass("disabled",state)})}});function hostkey2hostInfo(host_key){var info;var hostinfo=[];host_key=host_key.replace(/____/g,":");host_key=host_key.replace(/___/g,"/");host_key=host_key.replace(/__/g,".");info=host_key.split("@");return info}function handle_tab_state(nav_object,default_tab){$("a",nav_object).click(function(e){e.preventDefault()});$(" > li > a",nav_object).on("shown.bs.tab",function(e){var id=$(e.target).attr("href").substr(1);if(history.replaceState){history.replaceState(null,null,"#"+id)}else{window.location.hash=id}});var hash=window.location.hash;if(!hash)hash="#"+default_tab;$('a[href="'+hash+'"]',nav_object).tab("show")}String.prototype.sformat=function(){var args=arguments;return this.replace(/{(\d+)}/g,function(match,number){return typeof args[number]!="undefined"?args[number]:match})};if(typeof String.prototype.contains==="undefined"){String.prototype.contains=function(s){return this.indexOf(s)!==-1}}function makeFindHostBeforeSubmitCallback(http_prefix){return function(form,data){if(data.type=="mac"){form.attr("action",http_prefix+"/lua/mac_details.lua")}else if(data.type=="snmp"){form.attr("action",http_prefix+"/lua/pro/enterprise/snmp_interface_details.lua");$("<input>").attr({type:"hidden",id:"snmp_port_idx",name:"snmp_port_idx",value:data.snmp_port_idx}).appendTo(form)}else{form.attr("action",http_prefix+"/lua/host_details.lua")}return true}}function tstampToDateString(html_tag,format,tdiff){tdiff=tdiff||0;var timestamp=parseInt(html_tag.html())+tdiff;var localized=d3.time.format(format)(new Date(timestamp*1e3));html_tag.html(localized).removeClass("hidden");return localized}function cleanCustomHostUrl(host){return host.replace(/^http:\/\//gi,"").replace(/^https:\/\//gi,"").replace(/^www\./gi,"").replace(/[^0-9a-zA-Z\.\/_-]/gi,"")}function parseQuery(queryString){var query={};var pairs=(queryString[0]==="?"?queryString.substr(1):queryString).split("&");for(var i=0;i<pairs.length;i++){var pair=pairs[i].split("=");query[decodeURIComponent(pair[0])]=decodeURIComponent(pair[1]||"")}return query}function getHistoryParameters(params){var cur_params=parseQuery(window.location.search);var new_params=$.extend(cur_params,params);var new_query="?"+$.param(new_params,true);var baseUrl=[location.protocol,"//",location.host,location.pathname].join("");return baseUrl+new_query}var schema_2_label={};var data_2_label={};var graph_i18n={};function initLabelMaps(_schema_2_label,_data_2_label,_graph_i18n){schema_2_label=_schema_2_label;data_2_label=_data_2_label;graph_i18n=_graph_i18n}function getSerieLabel(schema,serie){var data_label=serie.label;var new_label=data_2_label[data_label];if(schema=="top:local_senders"||schema=="top:local_receivers"){return serie.tags.host}else if(schema.startsWith("top:")){if(serie.tags.protocol)return serie.tags.protocol;else if(serie.tags.category)return serie.tags.category;else if(serie.tags.device&&serie.tags.if_index){if(serie.tags.if_index!=serie.ext_label)return serie.ext_label+" ("+serie.tags.if_index+")";else return serie.ext_label}else if(serie.tags.device&&serie.tags.port)return serie.tags.port;else if(serie.tags.profile)return serie.tags.profile}else if(data_label!="bytes"){if(serie.tags.protocol)return serie.tags.protocol+" ("+new_label+")";else if(serie.tags.category)return serie.tags.category+" ("+new_label+")";else if(serie.tags.device&&serie.tags.if_index)return serie.ext_label+" ("+new_label+")";else if(serie.tags.device&&serie.tags.port)return serie.tags.port+" ("+new_label+")"}else{if(serie.tags.protocol)return serie.tags.protocol;else if(serie.tags.category)return serie.tags.category;else if(serie.tags.profile)return serie.tags.profile;else if(data_label=="bytes"){if(schema.contains("volume"))return graph_i18n.traffic_volume;else return graph_i18n.traffic}}if(schema_2_label[schema])return capitaliseFirstLetter(schema_2_label[schema]);if(new_label)return capitaliseFirstLetter(new_label);return capitaliseFirstLetter(data_label)}function getValueFormatter(schema,series){if(series&&series.length&&series[0].label){var label=series[0].label;if(label.contains("bytes")){if(schema.contains("volume"))return[bytesToSize,bytesToSize];else return[fbits_from_bytes,bytesToSize]}else if(label.contains("packets"))return[fpackets,formatPackets];else if(label.contains("flows"))return[formatValue,formatFlows,formatFlows];else if(label.contains("millis"))return[fmillis,fmillis]}return[fint,fint]}function makeFlatLineValues(tstart,tstep,num,data){var t=tstart;var values=[];for(var i=0;i<num;i++){values[i]=[t,data];t+=tstep}return values}function checkSeriesConsinstency(schema_name,count,series){var rv=true;for(var i=0;i<series.length;i++){var data=series[i].data;if(data.length>count){console.error("points mismatch: serie '"+getSerieLabel(schema_name,series[i])+"' has "+data.length+" points, expected "+count);rv=false}else if(data.length<count){series[i].data=upsampleSerie(data,count)}}return rv}function upsampleSerie(serie,num_points){if(num_points<=serie.length)return serie;var res=[];var intervals=num_points/serie.length;function lerp(v0,v1,t){return(1-t)*v0+t*v1}for(var i=0;i<num_points;i++){var index=i/intervals;var prev_i=Math.floor(index);var next_i=Math.min(Math.ceil(index),serie.length-1);var t=index%1;var v=lerp(serie[prev_i],serie[next_i],t);res.push(v)}return res.slice(0,num_points)}function buildTotalSerie(data_series){var series=[];for(var i=0;i<data_series.length;i++)series.push(data_series[i].data);return d3.transpose(series).map(function(x){return x.map(function(g){return g})}).map(function(x){return d3.sum(x)})}function arrayToNvSerie(serie_data,start,step){var values=[];var t=start;for(var i=0;i<serie_data.length;i++){values[i]=[t,serie_data[i]];t+=step}return values}function buildOtherSerie(total_serie,visual_total){if(total_serie.length!==visual_total.length){console.warn("Total/Visual length mismatch: "+total_serie.length+" vs "+visual_total.length);return}var res=[];var max_val=0;for(var i=0;i<total_serie.length;i++){var value=Math.max(0,total_serie[i]-visual_total[i]);max_val=Math.max(max_val,value);res.push(value)}if(max_val>.1)return res}function buildTimeArray(start_time,end_time,step){var arr=[];for(var t=start_time;t<end_time;t+=step)arr.push(t);return arr}function fixTimeRange(chart,params,align_step,actual_step){var diff_epoch=params.epoch_end-params.epoch_begin;var frame,align,tick_step,resolution,fmt="%H:%M:%S";var range_params=[[15,1,"%H:%M:%S",1,1],[60,1,"%H:%M:%S",1,5],[120,1,"%H:%M:%S",10,10],[300,1,"%H:%M:%S",10,30],[600,5,"%H:%M:%S",30,60],[1200,5,"%H:%M:%S",60,120],[3600,10,"%H:%M:%S",60,300],[5400,15,"%H:%M",300,900],[10800,30,"%H:%M",300,900],[21600,60,"%H:%M",3600,1800],[43200,120,"%H:%M",3600,3600],[86400,240,"%H:%M",3600,7200],[172800,480,"%a, %H:%M",3600,14400],[604800,1800,"%Y-%m-%d",86400,86400],[1209600,3600,"%Y-%m-%d",86400,172800],[2678400,7200,"%Y-%m-%d",86400,259200],[15768e3,43200,"%Y-%m-%d",2678400,1314e3],[31622400,86400,"%Y-%m-%d",2678400,2678400]];for(var i=0;i<range_params.length;i++){var range=range_params[i];if(diff_epoch<=range[0]){frame=range[0];resolution=range[1];fmt=range[2];align=range[3];tick_step=range[4];break}}resolution=Math.max(actual_step,resolution);if(align){align=align_step&&frame!=86400?Math.max(align,align_step):1;params.epoch_begin-=params.epoch_begin%align;params.epoch_end-=params.epoch_end%align;diff_epoch=params.epoch_end-params.epoch_begin;params.limit=Math.ceil(diff_epoch/resolution);params.epoch_end+=Math.ceil(diff_epoch/params.limit)*params.limit-diff_epoch;chart.xAxis.tickValues(buildTimeArray(params.epoch_begin,params.epoch_end,tick_step));chart.align=align}chart.xAxis.tickFormat(function(d){return d3.time.format(fmt)(new Date(d*1e3))})}function findActualStep(raw_step,tstart){if(typeof supported_steps==="object"){if(supported_steps[raw_step]){var retention=supported_steps[raw_step].retention;if(retention){var now_ts=Date.now()/1e3;var delta=now_ts-tstart;for(var i=0;i<retention.length;i++){var partial=raw_step*retention[i].aggregation_dp;var tframe=partial*retention[i].retention_dp;delta-=tframe;if(delta<=0)return partial}}}}return raw_step}function has_initial_zoom(){return typeof parseQuery(window.location.search).epoch_begin!=="undefined"}var current_zoom_level=history.state?history.state.zoom_level:0;function fixJumpButtons(epoch_end){var duration=$("#btn-jump-time-ahead").data("duration");if((epoch_end+duration)*1e3>$.now())$("#btn-jump-time-ahead").addClass("disabled");else $("#btn-jump-time-ahead").removeClass("disabled")}function showQuerySlow(){$("#query-slow-alert").show()}function hideQuerySlow(){$("#query-slow-alert").hide()}function attachStackedChartCallback(chart,schema_name,chart_id,zoom_reset_id,params,step,align_step,show_all_smooth,initial_range,ts_table_shown){var pending_chart_request=null;var pending_table_request=null;var d3_sel=d3.select(chart_id);var $chart=$(chart_id);var $zoom_reset=$(zoom_reset_id);var $graph_zoom=$("#graph_zoom");var max_interval=findActualStep(step,params.epoch_begin)*8;var initial_interval=params.epoch_end-params.epoch_begin;var is_max_zoom=initial_interval<=max_interval;var url=http_prefix+"/lua/get_ts.lua";var first_load=true;var first_time_loaded=true;var manual_trigger_cmp_serie=false;var datetime_format="dd/MM/yyyy hh:mm:ss";var max_over_total_ratio=3;var query_timer=null;var seconds_before_query_slow=6;var query_completed=0;var query_was_aborted=false;chart.is_zoomed=current_zoom_level>0||has_initial_zoom();var spinner=$('<i class="chart-loading-spinner fa fa-spinner fa-lg fa-spin"></i>');$chart.parent().css("position","relative");var chart_colors_full=["#69B87F","#94CFA4","#B3DEB6","#E5F1A6","#FFFCC6","#FEDEA5","#FFB97B","#FF8D6D","#E27B85"];var chart_colors_min=["#7CC28F","#FCD384","#FD977B"];var update_chart_data=function(new_data){d3_sel.datum([]).call(chart);d3_sel.datum(new_data).transition().call(chart);nv.utils.windowResize(chart.update);spinner.remove()};function isLegendDisabled(key,default_val){if(typeof localStorage!=="undefined"){var val=localStorage.getItem("chart_series.disabled."+key);if(val!=null)return val==="true"}return default_val}chart.legend.dispatch.on("legendClick",function(d,i){if(d.legend_key.indexOf("ago")!=-1)manual_trigger_cmp_serie=true;if(typeof localStorage!=="undefined")localStorage.setItem("chart_series.disabled."+d.legend_key,!d.disabled?true:false)});chart.dispatch.on("zoom",function(e){var cur_zoom=[params.epoch_begin,params.epoch_end];var t_start=Math.floor(e.xDomain[0]);var t_end=Math.ceil(e.xDomain[1]);var old_zoomed=chart.is_zoomed;var is_user_zoom=typeof e.is_user_zoom!=="undefined"?e.is_user_zoom:true;chart.is_zoomed=true;if(chart.updateStackedChart(t_start,t_end,false,is_user_zoom)){if(is_user_zoom||e.push_state){current_zoom_level+=1;var url=getHistoryParameters({epoch_begin:t_start,epoch_end:t_end});history.pushState({zoom_level:current_zoom_level,range:[t_start,t_end]},"",url)}chart.fixChartButtons()}else chart.is_zoomed=old_zoomed});function updateZoom(zoom,is_user_zoom,force){var t_start=zoom[0];var t_end=zoom[1];chart.updateStackedChart(t_start,t_end,false,is_user_zoom,null,force);chart.fixChartButtons()}$chart.on("dblclick",function(event){var delta=zoom_out_value;if((params.epoch_end+delta/2)*1e3<=$.now())delta/=2;$("#period_begin").data("DateTimePicker").date(new Date((params.epoch_begin-delta)*1e3));$("#period_end").data("DateTimePicker").date(new Date((params.epoch_end+delta)*1e3));updateChartFromPickers()});$zoom_reset.on("click",function(){if(current_zoom_level){history.go(-current_zoom_level)}});window.addEventListener("popstate",function(e){var zoom=initial_range;if(e.state){zoom=e.state.range;current_zoom_level=e.state.zoom_level}else current_zoom_level=0;updateZoom(zoom,true,true)});chart.fixChartButtons=function(){if(current_zoom_level>0||has_initial_zoom()){$graph_zoom.find(".btn-warning:not(.custom-zoom-btn)").addClass("initial-zoom-sel").removeClass("btn-warning");$graph_zoom.find(".custom-zoom-btn").css("visibility","visible");var zoom_link=$graph_zoom.find(".custom-zoom-btn input");var link=zoom_link.val().replace(/&epoch_begin=.*/,"");link+="&epoch_begin="+params.epoch_begin+"&epoch_end="+params.epoch_end;zoom_link.val(link)}else{$graph_zoom.find(".initial-zoom-sel").addClass("btn-warning");$graph_zoom.find(".custom-zoom-btn").css("visibility","hidden");chart.is_zoomed=false}fixJumpButtons(params.epoch_end);if(current_zoom_level>0)$zoom_reset.show();else $zoom_reset.hide()};function checkQueryCompleted(){var flows_dt=$("#chart1-flows");var wait_num_queries=ts_table_shown&&$("#chart1-flows").css("display")!=="none"?2:1;query_completed+=1;if(query_completed>=wait_num_queries){if(query_timer){clearInterval(query_timer);query_timer=null}hideQuerySlow()}}chart.queryWasAborted=function(){return query_was_aborted};chart.abortQuery=function(){query_was_aborted=true;if(pending_chart_request){pending_chart_request.abort();chart.noData(i18n.query_was_aborted);update_chart_data([])}if(pending_table_request)pending_table_request.abort();if(query_timer){clearInterval(query_timer);query_timer=null}hideQuerySlow()};chart.tableRequestCompleted=function(){checkQueryCompleted();pending_table_request=null};var old_start,old_end,old_interval;chart.updateStackedChart=function(tstart,tend,no_spinner,is_user_zoom,on_load_callback,force_update){if(tstart)params.epoch_begin=tstart;if(tend)params.epoch_end=tend;var cur_interval=params.epoch_end-params.epoch_begin;var actual_step=findActualStep(step,params.epoch_begin);max_interval=actual_step*6;if(cur_interval<max_interval){if(is_max_zoom&&cur_interval<old_interval&&!force_update){old_interval=cur_interval;return false}var epoch=params.epoch_begin+(params.epoch_end-params.epoch_begin)/2;var new_end=Math.floor(epoch+max_interval/2);if(new_end*1e3>=Date.now()){params.epoch_begin=params.epoch_end-max_interval}else{params.epoch_begin=Math.floor(epoch-max_interval/2);params.epoch_end=Math.floor(epoch+max_interval/2)}is_max_zoom=true;chart.zoomType(null)}else if(cur_interval>max_interval){is_max_zoom=false;chart.zoomType("x")}old_interval=cur_interval;if(!first_load||has_initial_zoom()||force_update)align_step=null;fixTimeRange(chart,params,align_step,actual_step);if(first_load)initial_range=[params.epoch_begin,params.epoch_end];if(old_start==params.epoch_begin&&old_end==params.epoch_end)return false;old_start=params.epoch_begin;old_end=params.epoch_end;if(pending_table_request)pending_table_request.abort();if(pending_chart_request)pending_chart_request.abort();else if(!no_spinner)spinner.appendTo($chart.parent());$("#period_begin").data("DateTimePicker").date(new Date(params.epoch_begin*1e3));$("#period_end").data("DateTimePicker").maxDate(new Date($.now())).date(new Date(Math.min(params.epoch_end*1e3,$.now())));if(query_timer)clearInterval(query_timer);query_timer=setInterval(showQuerySlow,seconds_before_query_slow*1e3);query_completed=0;query_was_aborted=false;chart.noData(i18n.no_data_available);hideQuerySlow();pending_chart_request=$.get(url,params,function(data){if(data&&data.error)chart.noData(data.error);if(!data||!data.series||!data.series.length||!checkSeriesConsinstency(schema_name,data.count,data.series)){update_chart_data([]);return}var res=[];var series=data.series;var total_serie;var color_i=0;var chart_colors=series.length<=chart_colors_min.length?chart_colors_min:chart_colors_full;for(var j=0;j<series.length;j++){var values=[];var serie_data=series[j].data;var t=data.start;for(var i=0;i<serie_data.length;i++){values[i]=[t,serie_data[i]];t+=data.step}var label=getSerieLabel(schema_name,series[j]);var legend_key=schema_name+":"+label;res.push({key:label,yAxis:series[j].axis||1,values:values,type:series[j].type||"area",color:chart_colors[color_i++],legend_key:legend_key,disabled:isLegendDisabled(legend_key,false)})}var visual_total=buildTotalSerie(series);var has_full_data=false;if(data.additional_series&&data.additional_series.total){total_serie=data.additional_series.total;var other_serie=buildOtherSerie(total_serie,visual_total);if(other_serie){res.push({key:graph_i18n.other,yAxis:1,values:arrayToNvSerie(other_serie,data.start,data.step),type:"area",color:chart_colors[color_i++],legend_key:"other",disabled:isLegendDisabled("other",false)});has_full_data=true}}else{total_serie=visual_total;has_full_data=!schema_name.startsWith("top:")}var past_serie=null;if(data.additional_series){for(var key in data.additional_series){if(key=="total"){continue}var serie_data=upsampleSerie(data.additional_series[key],data.count);var ratio_over_total=d3.max(serie_data)/d3.max(visual_total);var values=arrayToNvSerie(serie_data,data.start,data.step);var is_disabled=isLegendDisabled(key,false);past_serie=serie_data;if((first_time_loaded||!manual_trigger_cmp_serie)&&ratio_over_total>max_over_total_ratio)is_disabled=true;res.push({key:capitaliseFirstLetter(key),yAxis:1,values:values,type:"line",classed:"line-dashed line-animated",color:"#7E91A0",legend_key:key,disabled:is_disabled})}}if(!data.no_trend&&has_full_data&&total_serie.length>=3){var num_smoothed_points=Math.max(Math.floor(total_serie.length/5),3);var smooth_functions={trend:[graph_i18n.trend,"#62ADF6",smooth,num_smoothed_points],ema:["EMA","#F96BFF",exponentialMovingAverageArray,{periods:num_smoothed_points}],sma:["SMA","#A900FF",simpleMovingAverageArray,{periods:num_smoothed_points}],rsi:["RSI cur vs past","#00FF5D",relativeStrengthIndexArray,{periods:num_smoothed_points}]};function add_smoothed_serie(fn_to_use){var options=smooth_functions[fn_to_use];var smoothed;if(fn_to_use=="rsi"){if(!past_serie)return;var delta_serie=[];for(var i=0;i<total_serie.length;i++){delta_serie[i]=total_serie[i]-past_serie[i]}smoothed=options[2](delta_serie,options[3])}else smoothed=options[2](total_serie,options[3]);var max_val=d3.max(smoothed);if(max_val>0){var aligned;if(fn_to_use!="ema"&&fn_to_use!="sma"&&fn_to_use!="rsi"){var scale=d3.max(total_serie)/max_val;var scaled=$.map(smoothed,function(x){return x*scale});aligned=upsampleSerie(scaled,data.count)}else{var remaining=data.count-smoothed.length;var to_fill=remaining<num_smoothed_points?remaining:num_smoothed_points;for(var i=0;i<to_fill;i++)smoothed.splice(0,0,smoothed[0]);aligned=upsampleSerie(smoothed,data.count)}if(fn_to_use=="rsi")chart.yDomainRatioY2(1);res.push({key:options[0],yAxis:fn_to_use!="rsi"?1:2,values:arrayToNvSerie(aligned,data.start,data.step),type:"line",classed:"line-animated",color:options[1],legend_key:fn_to_use,disabled:isLegendDisabled(fn_to_use,false)})}}if(show_all_smooth){for(fn_to_use in smooth_functions)add_smoothed_serie(fn_to_use)}else add_smoothed_serie("trend")}var formatter1=getValueFormatter(schema_name,series.filter(function(d){return d.axis!=2}));var value_formatter=formatter1[0];var tot_formatter=formatter1[1];var stats_formatter=formatter1[2]||value_formatter;chart.yAxis1.tickFormat(value_formatter);chart.yAxis1_formatter=value_formatter;var second_axis_series=series.filter(function(d){return d.axis==2});var formatter2=getValueFormatter(schema_name,second_axis_series);var value_formatter2=formatter2[0];chart.yAxis2.tickFormat(value_formatter2);chart.yAxis2_formatter=value_formatter2;var stats_table=$("#ts-chart-stats");var stats=data.statistics;if(stats){if(stats.average){var values=makeFlatLineValues(data.start,data.step,data.count,stats.average);res.push({key:graph_i18n.avg,yAxis:1,values:values,type:"line",classed:"line-dashed line-animated",color:"#AC9DDF",legend_key:"avg",disabled:isLegendDisabled("avg",true)})}var total_cell=stats_table.find(".graph-val-total");var average_cell=stats_table.find(".graph-val-average");var min_cell=stats_table.find(".graph-val-min");var max_cell=stats_table.find(".graph-val-max");var perc_cell=stats_table.find(".graph-val-95percentile");if(stats.total||total_cell.is(":visible"))total_cell.show().find("span").html(tot_formatter(stats.total));if(stats.average||average_cell.is(":visible"))average_cell.show().find("span").html(stats_formatter(stats.average));if(stats.min_val||min_cell.is(":visible"))min_cell.show().find("span").html(stats_formatter(stats.min_val)+" @ "+new Date(res[0].values[stats.min_val_idx][0]*1e3).format(datetime_format));if(stats.max_val||max_cell.is(":visible"))max_cell.show().find("span").html(stats_formatter(stats.max_val)+" @ "+new Date(res[0].values[stats.max_val_idx][0]*1e3).format(datetime_format));if(stats["95th_percentile"]||perc_cell.is(":visible")){perc_cell.show().find("span").html(stats_formatter(stats["95th_percentile"]));var values=makeFlatLineValues(data.start,data.step,data.count,stats["95th_percentile"]);res.push({key:graph_i18n["95_perc"],yAxis:1,values:values,type:"line",classed:"line-dashed line-animated",color:"#476DFF",legend_key:"95perc",disabled:isLegendDisabled("95perc",true)})}}stats_table.show();var enabled_series=res.filter(function(d){return d.disabled!==true});if(second_axis_series.length>0||enabled_series.length==0){for(var i=0;i<res.length;i++)res[i].disabled=false}if(second_axis_series.length>0){chart.legend.updateState(false)}update_chart_data(res);first_time_loaded=false}).fail(function(xhr,status,error){if(xhr.statusText=="abort"){return}console.error("Error while retrieving the timeseries data ["+status+"]: "+error);chart.noData(error);update_chart_data([])}).always(function(data,status,xhr){checkQueryCompleted();pending_chart_request=null});if(first_load){first_load=false;$(function(){var flows_dt=$("#chart1-flows").data("datatable");if(flows_dt)pending_table_request=flows_dt.pendingRequest})}else{var flows_dt=$("#chart1-flows");if(ts_table_shown){updateGraphsTableView(null,params);if($("#chart1-flows").css("display")!=="none")pending_table_request=flows_dt.data("datatable").pendingRequest}}if(typeof on_load_callback==="function")on_load_callback(chart);return true}}var graph_old_view=null;var graph_old_has_nindex=null;var graph_old_nindex_query=null;function tsQueryToTags(ts_query){return ts_query.split(",").reduce(function(params,value){var pos=value.indexOf(":");if(pos!=-1){var k=value.slice(0,pos);var v=value.slice(pos+1);params[k]=v}return params},{})}function recheckGraphTableEntries(){var table_view=graph_table_views;var tdiff=graph_params.epoch_end-graph_params.epoch_begin;var reset_selection=false;$("#chart1-flows").show();$("#graphs-table-selector").show();for(view_id in table_view){var view=table_view[view_id];var elem=$("#"+view.html_id);if(tdiff<=view.min_step){if(graph_old_view.id===view_id)reset_selection=true;elem.hide()}else elem.show()}var items_ul=$("#graphs-table-active-view").closest(".btn-group").find("ul:first");items_ul.find("li.dropdown-header").each(function(idx,e){var next_item=$(e).nextAll("li").filter(function(idx,e){return $(e).css("display")!=="none"||!$(e).attr("data-view-id")}).first();var divider=$(e).nextAll(".divider").first();if(!next_item.attr("data-view-id")){$(e).hide();divider.hide()}else{$(e).show();divider.show()}});if(reset_selection){var first_view=items_ul.find("li[data-view-id]").filter(function(idx,e){return $(e).css("display")!=="none"}).first();if(first_view.length)setActiveGraphsTableView(first_view.attr("data-view-id"));else{$("#chart1-flows").hide();$("#graphs-table-selector").hide()}return false}return true}function updateGraphsTableView(view,graph_params,has_nindex,nindex_query,per_page){if(view)graph_old_view=view;if(!recheckGraphTableEntries(graph_params)){return}if(view){graph_old_has_nindex=has_nindex;graph_old_nindex_query=nindex_query}else{view=graph_old_view;has_nindex=graph_old_has_nindex;nindex_query=graph_old_nindex_query}var graph_table=$("#chart1-flows");nindex_query=nindex_query+"&begin_time_clause="+graph_params.epoch_begin+"&end_time_clause="+graph_params.epoch_end;var nindex_buttons="";var params_obj=tsQueryToTags(graph_params.ts_query);if(!params_obj.host){nindex_buttons+='<div class="btn-group"><button class="btn btn-link dropdown-toggle" data-toggle="dropdown">';nindex_buttons+="IP Version";nindex_buttons+='<span class="caret"></span></button><ul class="dropdown-menu" role="menu">';nindex_buttons+='<li><a href="#" onclick="return onGraphMenuClick(null, 4)">4</a></li>';nindex_buttons+='<li><a href="#" onclick="return onGraphMenuClick(null, 6)">6</a></li>';nindex_buttons+="</span></div>"}nindex_buttons+='<div class="btn-group pull-right"><button class="btn btn-link dropdown-toggle" data-toggle="dropdown">';nindex_buttons+="Explorer";nindex_buttons+='<span class="caret"></span></button><ul class="dropdown-menu" role="menu">';nindex_buttons+='<li><a href="'+http_prefix+"/lua/enterprise/nindex_topk.lua"+nindex_query+'">Top-K</a></li>';nindex_buttons+='<li><a href="'+http_prefix+"/lua/enterprise/nindex.lua"+nindex_query+'">Flows</a></li>';nindex_buttons+="</span></div>";if(view.columns){var url=http_prefix+(view.nindex_view?"/lua/enterprise/get_nindex_flows.lua":"/lua/enterprise/get_ts_table.lua");var columns=view.columns.map(function(col){return{title:col[1],field:col[0],css:{textAlign:col[2],width:col[3]},hidden:col[4]?true:false}});columns.push({title:i18n.actions,field:"drilldown",css:{width:"1%","white-space":"nowrap","text-align":"center"}});var old_dt=graph_table.data("datatable");if(old_dt&&old_dt.pendingRequest)old_dt.pendingRequest.abort();graph_table.removeData("datatable");graph_table.html("");graph_table.datatable({title:"",url:url,perPage:per_page,noResultsMessage:function(){if(ts_chart.queryWasAborted())return i18n.query_was_aborted;else return i18n.no_results_found},post:function(){var params=$.extend({},graph_params);delete params.ts_compare;delete params.initial_point;params.limit=1;params.detail_view=view.id;return params},loadingYOffset:40,columns:columns,buttons:view.nindex_view?[nindex_buttons]:[],tableCallback:function(){var data=this.resultset;ts_chart.tableRequestCompleted();if(!data){return}if(data.currentPage>1)graph_table.data("has_interaction",true);var stats_div=$("#chart1-flows-stats");var has_drilldown=data&&data.data.some(function(row){return row.drilldown});if(!has_drilldown)$("table td:last-child, th:last-child",graph_table).remove();if(data&&data.stats&&data.stats.loading_time){$("#flows-load-time").html(data.stats.loading_time);$("#flows-processed-records").html(data.stats.num_records_processed);stats_div.show()}else stats_div.hide()},rowCallback:function(row,row_data){if(typeof row_data.tags==="object"&&(params_obj.category&&row_data.tags.category===params_obj.category||params_obj.protocol&&row_data.tags.protocol===params_obj.protocol)){row.addClass("info")}return row}})}}function draw_processes_graph(http_prefix,graph_div_id,host){var links;var nodes={};var url=http_prefix+"/lua/get_processes_graph_data.lua?host="+host;d3.json(url,function(error,json){if(error)return console.warn(error);links=json;var _link;links.forEach(function(link){if(link.source_pid==-1){_link=http_prefix+"/lua/host_details.lua?host="+link.source}else{_link=http_prefix+"/lua/process_details.lua?pid="+link.source_pid+"&pid_name="+link.source_name+"&host="+host+"&page=flows"}link.source=nodes[link.source]||(nodes[link.source]={name:link.source_name,num:link.source,link:_link,type:link.source_type,pid:link.source_pid});if(link.target_pid==-1){_link=http_prefix+"/lua/host_details.lua?host="+link.target}else{_link=http_prefix+"/lua/process_details.lua?pid="+link.target_pid+"&pid_name="+link.target_name+"&host="+host+"&page=flows"}link.target=nodes[link.target]||(nodes[link.target]={name:link.target_name,num:link.target,link:_link,type:link.target_type,pid:link.target_pid})});var width=960,height=500,arrow_size=6;var color=d3.scale.category10();color["proc"]="red";color["host"]="lightsteelblue";var force=d3.layout.force().nodes(d3.values(nodes)).links(links).size([width,height]).linkDistance(120).charge(-400).on("tick",tick).start();var svg=d3.select("#"+graph_div_id).append("svg").attr("id","ebpf_graph").attr("width",width).attr("height",height);svg.append("defs").selectAll("marker").data(["proc2proc","proc2host","host2proc","host2host"]).enter().append("marker").attr("id",function(d){return d}).attr("viewBox","0 -5 10 10").attr("refX",15).attr("refY",-1.5).attr("markerWidth",arrow_size).attr("markerHeight",arrow_size).attr("orient","auto").append("path").attr("d","M0,-5L10,0L0,5");var path=svg.append("g").selectAll("path").data(force.links()).enter().append("path").attr("class",function(d){return"link "+d.type}).attr("marker-end",function(d){return"url(#"+d.type+")"});var circle=svg.append("g").selectAll("circle").data(force.nodes()).enter().append("circle").attr("class","ebpf_circle").attr("r",8).style("fill",function(d){return color[d.type]}).call(force.drag).on("dblclick",function(d){window.location.href=d.link});var text=svg.append("g").selectAll("text").data(force.nodes()).enter().append("text").attr("class","ebpf_text").attr("x",12).attr("y",".31em").text(function(d){if(d.pid>=0)return d.name+" [pid: "+d.pid+"]";else{return d.name}});function tick(){path.attr("d",linkArc);circle.attr("transform",transform);text.attr("transform",transform)}function linkArc(d){var dx=d.target.x-d.source.x,dy=d.target.y-d.source.y,dr=Math.sqrt(dx*dx+dy*dy);return"M"+d.source.x+","+d.source.y+"A"+dr+","+dr+" 0 0,1 "+d.target.x+","+d.target.y}function transform(d){return"translate("+d.x+","+d.y+")"}})}function makeUniqueValidator(items_function){return function(field){var cmp_name=field.val();var count=0;if(!cmp_name)return true;items_function(field).each(function(){var name=$(this).val();if(name==cmp_name)count=count+1});return count==1}}function memberValueValidator(input){var member=input.val();if(member==="")return true;return is_mac_address(member)||is_network_mask(member,true)}function makePasswordPatternValidator(pattern){return function passwordPatternValidator(input){if(!input.val())return true;return $(input).val().match(pattern)}}function passwordMatchValidator(input){var other_input=$(input).closest("form").find("[data-passwordmatch]").not(input);if(!input.val()||!other_input.val())return true;return other_input.val()===input.val()}function poolnameValidator(input){if(!input.val())return true;return $(input).val().match(/^[a-z0-9_]*$/)}function passwordMatchRecheck(form){var items=$(form).find("[data-passwordmatch]");var not_empty=0;items.each(function(){if($(this).val()!="")not_empty++});if(not_empty==items.length)items.trigger("input")}function hostOrMacValidator(input){var host=input.val();if(host==="")return true;return is_mac_address(host)||is_good_ipv4(host)||is_good_ipv6(host)}
//# sourceMappingURL=ntop.min.js.map