CC=gcc
INSTALL=install
SBINDIR=/sbin
USRSBINDIR=/usr/sbin
INCDIR=/usr/include/ploop
LIBDIR=/usr/lib
ifeq "$(shell uname -m)" "x86_64"
LIBDIR=/usr/lib64
endif
LOCKDIR=/var/lock/ploop
MANDIR=/usr/share/man
MAN8DIR=$(MANDIR)/man8
DEBUG=yes

CFLAGS += -I. -I../include -Wall -fno-strict-aliasing -Wstrict-prototypes \
	-Werror -D_GNU_SOURCE -D_LARGEFILE64_SOURCE -D_FILE_OFFSET_BITS=64
CFLAGS += $(if $(DEBUG),-g -O0 -DDEBUG,-O2)
CFLAGS += $(RPM_OPT_FLAGS)

LDFLAGS += $(if $(DEBUG),-g -rdynamic,)

export CFLAGS CC

ifeq ($(strip $(V)),)
	E = @echo
	Q = @
else
	E = @\#
	Q =
endif
export E Q

%.o: %.c
	$(E) "  CC      " $@
	$(Q) $(CC) $(CFLAGS) -c $< -o $@

.depend:
	$(E) "  DEP     " $@
	$(Q) $(CC) $(CFLAGS) -M $^ > $@
