/*
 * 	sam_attributes.h - SAM-FS file system file attribute definitions.
 *
 *	Description:
 *	    Defines file attributes and structure for the SAM file
 *	    system. This structures resides in the file and directory
 *	    inode. It is also in the .user and .group attributes files.
 *	    There is 1 copy defined for global attributes.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Revision$
 */

#ifdef sun
#pragma ident "$Revision$"
#endif


#ifndef	_SAM_FS_ATTRIBUTES_H
#define	_SAM_FS_ATTRIBUTES_H

#include <sam/fs/ino.h>

typedef struct	sam_file_attr	{
	ushort_t				/* Change flags: */
#if	defined(_BIT_FIELDS_HTOL)
		c_damaged   : 1,		/* Set/clear damaged flag */
		c_direct    : 1,		/* Enable/disable direct access */
		c_nodrop    : 1,		/* Enable/disable nodrop status */
		c_noarch    : 1,		/* Enable/disable noarchive status */

		c_stageall  : 1,		/* Enable/disable stageall */
		c_migrate   : 1,		/* Enable/disable immediate archive */
		c_inherit   : 1,		/* Change directory inherit attribute mode */
		c_release   : 1,		/* Change directory inherit attribute mode */

		c_bof_online: 1,		/* Change beg. of file left on-line status */
		c_cs_use    : 1,		/* Change whether checksum is used */
		c_cs_gen    : 1,		/* Change whether checksum is generated */
		c_cs_val    : 1,		/* Change whether checksum is valid */

		unused	    : 4;
#else	/* defined(_BIT_FIELDS_HTOL) */
		unused	    : 4,

		c_cs_val    : 1,		/* Change whether checksum is valid */
		c_cs_gen    : 1,		/* Change whether checksum is generated */
		c_cs_use    : 1,		/* Change whether checksum is used */
		c_bof_online: 1,		/* Change beg. of file left on-line status */

		c_release   : 1,		/* Change directory inherit attribute mode */
		c_inherit   : 1,		/* Change directory inherit attribute mode */
		c_migrate   : 1,		/* Enable/disable immediate archive */
		c_stageall  : 1,		/* Enable/disable stageall */

		c_noarch    : 1,		/* Enable/disable noarchive status */
		c_nodrop    : 1,		/* Enable/disable nodrop status */
		c_direct    : 1,		/* Enable/disable direct access */
		c_damaged   : 1;		/* Set/clear damaged flag */
#endif  /* defined(_BIT_FIELDS_HTOL) */

	uchar_t		attr;			/* Attribute mode */
	ino_st_t	status;			/* File status flags--see fs/ino.h */
} sam_file_attr_t;

/*
 * Local Variables:
 * eval:(hgc-c-mode)
 * tab-width:4
 * End:
 */

#endif	/* _SAM_FS_ATTRIBUTES_ */
