/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _XCIN_H
#define _XCIN_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <iconv.h>
#include <ctype.h>

#include <X11/Xmd.h>
#define CARD32BIT CARD32

/* #define DEBUG */
/* #define DEBUGMODE */
#define MAX_AUX 2
#define MAXCANDIDATES   40
#define LOCALE_NAME "zh_TW"

/*
 * header files for SunIM library
 */
#include "SunIM.h"

#include "le_proc.h"
#include "xmlconf.h"
#include "debugInfo.h"
#include "charcode.h"
#include "gen_inp.h"
#include "keymap.h"
#include "key_event.h"

/*
 * define If method prototype
 */
Bool if_xcin_OpenIF(iml_if_t *);
Bool if_xcin_CloseIF(iml_if_t *);
Bool if_xcin_GetIFValue(iml_if_t *, IMArgList, int);
Bool if_xcin_SetIFValue(iml_if_t *, IMArgList, int);
Bool if_xcin_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_xcin_CloseDesktop(iml_desktop_t *);
Bool if_xcin_CreateSC(iml_session_t *, IMArgList, int);
Bool if_xcin_DestroySC(iml_session_t *);
Bool if_xcin_GetSCValue(iml_session_t *, IMArgList, int);
Bool if_xcin_SetSCValue(iml_session_t *, IMArgList, int);
IMText* if_xcin_ResetSC(iml_session_t *);
void if_xcin_SetSCFocus(iml_session_t *);
void if_xcin_UnsetSCFocus(iml_session_t *);
void if_xcin_SendEvent(iml_session_t *, IMInputEvent *ev); 

/* Non IF Functions */
void init_objects();
void free_objects();


IMText *make_preedit_imtext(iml_session_t *);

int UTFCHARLen(UTFCHAR *);
int UTFCHARCpy(UTFCHAR *, UTFCHAR *);


#define TAB_ENC "utf-8"

/***************** Section 1 ********************/

                                                                                                                            

/***************** Section 2 ***********************************/


/***************** Section 3 ***********************************/


/***************** Section 4 ***********************/


/*=============== objenc_t ============================*/
typedef struct 
{
    char objname[50];
    char encoding[50];
    char objloadname[100];
} objenc_t;


// ================= misc 
#define MODULE_ID_SIZE 20
#define SYSCIN_VERSION  "20000210"

#define INP_MODE_SELKEYSHIFT 0x00000020 /* selkey shift mode on. */ // gen_inp.h

#define MCCH_ONEPG              0 // module.h

// xcintool.h
#define XCINMSG_NORMAL           0              /* normal               */
#define XCINMSG_WARNING          1              /* warning              */
#define XCINMSG_IWARNING         2              /* internal warnning    */
#define XCINMSG_ERROR           -1              /* error                */
#define XCINMSG_IERROR          -2              /* internal error       */
#define XCINMSG_EMPTY            3              /* pure message printed */





typedef struct
{
    UTFCHAR name[10];
    char file[30];
    int n_preedit;
} IMEntry;

/* data per desktop (keep track of all application running on desktop) */
typedef struct 
{
    iml_session_t *auxproxy_session;
    int aux_start[3];
    int wordcount;
}   MyDataPerDesktop;


/* data per session (per application basis) */
typedef struct {
    int status_start;
    int preedit_start;
    int luc_start;
    int luc_commit;
    int conv_on;

    IMText **luc_candidates;
    IMText **luc_labels;

    UTFCHAR *conversion_string;         /* reversed */
    UTFCHAR *preedit_string;            /* underlined */

    int luc_top;
    int luc_nchoices;
    int luc_current_candidate;          /* index of current candidate */
    int luc_type;                       /* Clinet or IM Master */
    int max_candidates;

    UTFCHAR *preedit_buf;               /* preedit */
    IMFeedbackList *preedit_feedback;   /* feedback for preedit */
    int caret_pos;

    IMFeedbackList *luc_fbs_reverse;
    IMFeedbackList *luc_fbs_normal;

    UTFCHAR *commit_buf;	            /* commit */

    UTFCHAR *on_string;
    int cur_im;                         /* current input styles */
        
/* START XCIN */
    gen_inp_conf_t* cf;
    gen_inp_iccf_t* iccf;
    inpinfo_t* inpinfo;
/* END XCIN */
    char *tabenc;                        /* encoding that needed in tab */

    langim *inputstyles;
    imnodes *imnode;

}   MyDataPerSession;


enum 
{
    SAMPLE_AUX_PANEL = 0,
    SAMPLE_AUX_DICT = 1
};

#endif      // end of #define _XCIN_H


