/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "xcin.h"

//extern IMEntry imentries[];
extern int key2code(int);

/*** Private handling functions ***/
Bool key_backspace_preedit(iml_session_t* s, int i)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    if (i > 0) 
    {
        session_data->preedit_buf[i-session_data->imnode->n_preedit] = 0;
        session_data->iccf->keystroke[i/session_data->imnode->n_preedit-1] = 0;   
        preedit_draw(s);
        session_data->inpinfo = match_keystroke( session_data->cf, session_data->inpinfo, session_data->iccf );
        if ( session_data->inpinfo->n_mcch > 0 )
            lookup_draw(s); 
        else
            lookup_end(s);
        
        /* Prevent the luc window from appearing when preedit buffer is empty */
        if( i-1 == 0)
        {
            lookup_end(s);
            memset(session_data->luc_candidates, 0, MAXCANDIDATES * sizeof(IMText));
        }
        return True;
    } 
    else 
        return False;
}

Bool key_escape_preedit(iml_session_t* s, int i)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    if (i > 0)
    {
        lookup_end(s);
                    
        session_data->preedit_buf[0] = 0;
        session_data->iccf->keystroke[0] = 0;   
        preedit_draw(s);
        memset(session_data->luc_candidates, 0, MAXCANDIDATES * sizeof(IMText));
       
        return True;
    }
        return False;
}

Bool key_convert_az(iml_session_t* s, IMKeyEventStruct* k)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    UTFCHAR key[2];

    if(k->keyChar >= 'A' && k->keyChar <= 'z') {
        key[0] = (UTFCHAR) tolower(k->keyChar);
        key[1] = 0;
        commit(s, &key);
        return True;
    }
    else {
        switch(k->keyChar)
        {
            case '<':
            case ',':
                key[0] = 0xff0c; /* , */
                break;
            case '>':
            case '.':
                key[0] = 0x3002; /* . */
                break;
            case '?':
            case '/':
                key[0] = 0xff1f; /* ? */
                break;
            case ':':
            case ';':
                key[0] = 0xff1a; /* : */
                break;
            case '\"':
            case '\'':
                key[0] = 0xff1b; /* ; */
                break;
            case '{':
            case '[':
                key[0] = 0x300e; /* [ */
                break;
            case '}':
            case ']':
                key[0] = 0x300f; /* ] */
                break;
            case '(':
                key[0] = 0xff08; /* ( */
                break;
            case ')':
                key[0] = 0xff09; /* ) */
                break;
            case '!':
                key[0] = 0xff01; /* ! */
                break;
            default:
                return False;
        }
        key[1] = 0;
        commit(s, key);
        return True;
    }
}

/*** Event handling ***/
/* Event key list for look up candidate */
Bool keylist_luc( iml_session_t* s, IMKeyEventStruct* k)
{
    int index;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    
    /* Used to commit char in the luc window using number keys 1-9 */
    if(k->keyChar >= '0' && k->keyChar <= '9')
    {
        index = k->keyChar - '1';
        
        if(k->keyChar == '0') return True;
        
        /* Catching out of range choices */
        if ( index >= session_data->inpinfo->n_mcch )
            return True;
        if(lookup_commit(s, index))
            return True;
    }
    else if ((k->modifier & IM_SHIFT_MASK && (k->keyCode == IM_VK_P || k->keyCode == IM_VK_LESS)) ||
             k->keyCode == IM_VK_UP || k->keyCode == IM_VK_LEFT) 
    {
            lookup_prev(s);
            lookup_draw(s);
            return True;
    } 
    else if ((k->modifier & IM_SHIFT_MASK && (k->keyCode == IM_VK_N || k->keyCode == IM_VK_GREATER)) ||
              k->keyCode == IM_VK_DOWN || k->keyCode == IM_VK_RIGHT) 
    {
            lookup_next(s);
            lookup_draw(s);
            return True;
    }
    else if (k->keyCode == IM_VK_ESCAPE)
        return key_escape_preedit(s, UTFCHARLen(session_data->preedit_buf));
    
    else if (k->keyCode == IM_VK_BACK_SPACE){
        /* if numbers are keyname, then set unlock candidate */
        if ((UTFCHAR)UTF8toUnicode((wchar_t)session_data->cf->header.
                    keyname[key2code('1')].wch))
            session_data->luc_commit = False;
        return key_backspace_preedit(s, UTFCHARLen(session_data->preedit_buf));
    }    
    else if(k->keyCode == IM_VK_SPACE){
            lookup_next(s);
            lookup_draw(s);
            return True;
    }
    else if(k->keyCode == IM_VK_ENTER){
        if(lookup_commit(s, 0))
            return True;
    }

    /* check if numbers are keyname, if not then process further */
    /* XXX fix in v.2 on not only checking '1' */
    if (!(UTFCHAR)UTF8toUnicode((wchar_t)session_data->cf->header.
                    keyname[key2code('1')].wch))
        return False;
    else
        return True;
}

Bool keylist_chgtab(iml_session_t* s, int index)
{
    FILE* fp;
    char filename[256];

    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

    session_data->imnode = fetchIMpos(session_data->inputstyles, index); 
    if(session_data->imnode != NULL){
        session_data->cur_im = index;
        session_data->cf->inp_ename = session_data->imnode->id;
            
        sprintf(filename, "%s/%s.tab", session_data->inputstyles->path, session_data->imnode->id);   
        if ( (fp = fopen( filename, "r" )) == NULL )
            printf("*** XCIN: File could not be opened.\n");
        else
        {
            gen_inp_xim_end(session_data->cf, session_data->inpinfo);
            gen_inp_xim_init( session_data->cf, session_data->iccf, session_data->inpinfo );
            ccode_info( &(session_data->cf->ccinfo) );
            loadtab( session_data->cf, fp, session_data->tabenc ); 
        }
        fclose(fp);
        //session_data->on_string = imentries[session_data->cur_im].name;
        {
            char *name;
            if(session_data->imnode->name)
                name = session_data->imnode->name;
            else
                name = session_data->cf->inp_cname;
            
            utf8_to_utf16(name, (char *)session_data->on_string, strlen(name)); 
        }

        status_draw(s);
        
        session_data->preedit_buf[0] = 0;
        session_data->iccf->keystroke[0] = 0;
        preedit_draw(s);
        lookup_end(s);
        
        return True;
    }
    return False;               
}

/*
 * The most important function as it bridges the IIIMF core code to original xcin functions
 * which are located in other files
 */ 
Bool receive_keylist( iml_session_t* s, IMKeyListEvent* keylist) 
{
    
    int i;
    int index;

    IMKeyEventStruct *k = (IMKeyEventStruct *) keylist->keylist;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

    i = UTFCHARLen(session_data->preedit_buf);

#ifdef  DEBUG
    printf("*** receive_keylist( ) ***\n");
    printf("    iml_session_t() keycode=%x,keychar=%c, state=%x\n", k->keyCode, k->keyChar, k->modifier);
    printf("    Preedit Buffer Size[%d]\n", i);
    printf("    Preedit Buffer[%s]\n", session_data->preedit_buf[i]);

    printf("    session_data->inpinfo->ename =[%s]\n", session_data->inpinfo->inp_ename);
    printf("    session_data->inpinfo->n_selkey=[%u] \t session_data->cf->header.n_selkey=[%d]\n", session_data->inpinfo->n_selkey, session_data->cf->header.n_selkey );

#endif
    
    /* This portion of the code will fill the buffer with the keyboard input */
    if(session_data->luc_start && session_data->luc_commit)
        if(keylist_luc(s, k)) return True;

    /* change IM using ctrl-alt-[num] */    
    if (k->modifier & IM_CTRL_MASK && k->modifier & IM_ALT_MASK && (k->keyChar >= '1' && k->keyChar <= '9'))
    {
        index = k->keyChar - '1';
        if(keylist_chgtab(s, index)) return True;
    }
    /* change IM using Ctrl-Shift */
    else if ((k->keyCode == IM_VK_CONTROL && k->modifier & IM_SHIFT_MASK) ||
             (k->keyCode == IM_VK_SHIFT   && k->modifier & IM_CTRL_MASK))
    {
        if(session_data->imnode->next == NULL)
            session_data->cur_im = 0;
        else
            session_data->cur_im++;
                
        if(keylist_chgtab(s, session_data->cur_im)) return True;
    }
    else if (k->keyCode == IM_VK_SPACE && i > 0 && session_data->luc_start )
    {
        session_data->luc_commit = True;
        lookup_draw(s);
    }
    else if (k->keyCode == IM_VK_BACK_SPACE)
        return key_backspace_preedit(s, i);

    else if (k->keyCode == IM_VK_ESCAPE)
        return key_escape_preedit(s, i);
    /* if it is SHIFT'ed with inputs and it is not in preedit mode*/
    else if ((k->modifier & IM_SHIFT_MASK) &&
            k->keyChar >= '!' && k->keyChar <= '~' && i == 0)
    {
        return key_convert_az(s, k);
    }
    /* if it is not SHIFT'ed */
    else if (k->keyChar >= '!' && k->keyChar <= '~' 
                    && !(k->modifier & IM_CTRL_MASK & k->modifier & IM_ALT_MASK))
    {
        if(i<INP_CODE_LENGTH){
            /* Following section are assignment to preedit with correct keyname and actual keystroke for search
               immentries[].n_preedit specify how many character are stored into wch_t
               because orginial xcin push two single bytes into one wch_t (which only suppose to store one char)
               we need to seperate out the case of one char and two or more char.
               TODO: redo and make a new struture for keyname
            */ 
            UTFCHAR buf; int j;
            if (session_data->imnode->n_preedit == 1) {
                buf = (UTFCHAR)UTF8toUnicode((wchar_t)session_data->cf->header.keyname[key2code(k->keyChar)].wch);
                /* check if buf is there, otherwise don't ignore it if it is not in preedit mode yet and pass to committed area. i.e. some input styles on , and . characters */
                if (buf){
                    session_data->preedit_buf[i] = buf;
                    session_data->preedit_buf[i+session_data->imnode->n_preedit] = 0;
                    session_data->iccf->keystroke[i/session_data->imnode->n_preedit] = (char)k->keyChar;
                    session_data->iccf->keystroke[i/session_data->imnode->n_preedit+1] = 0;
                }
                else if (session_data->preedit_buf[0] == 0)
                    return False;
            } else {
                for(j=0; j<session_data->imnode->n_preedit; j++) {
                    buf =             
                      (UTFCHAR)UTF8toUnicode((wchar_t)session_data->cf->header.keyname[key2code(k->keyChar)].s[j]);
                   if (buf){
                       session_data->preedit_buf[i+j] = buf;
                        session_data->preedit_buf[i+session_data->imnode->n_preedit] = 0;
                        session_data->iccf->keystroke[i/session_data->imnode->n_preedit] = (char)k->keyChar;
                        session_data->iccf->keystroke[i/session_data->imnode->n_preedit+1] = 0;
                   }
                   else if (session_data->preedit_buf[0] == 0)
                       return False;
                }
            }
        }
        session_data->inpinfo = match_keystroke( session_data->cf, session_data->inpinfo, session_data->iccf );
                  
        /* This is to fix the label area issue (eg. 1 choice = 1 label instad of 1 choice = 2 label */ 
        if ( session_data->inpinfo->n_mcch > 0 )
            lookup_draw(s);
        else
            if(session_data->luc_start == True){
                lookup_end(s);
                memset(session_data->luc_candidates, 0, MAXCANDIDATES * sizeof(IMText));
            }

        /* lock candidate if the preedit char is endkey */
        if (strchr(session_data->cf->header.endkey, k->keyChar) && i > 0 )
        {
            session_data->luc_commit = True;
            if ( session_data->inpinfo->n_mcch > 0 )
                lookup_draw(s);
        }

        /* lock candidate if numbers are not keyname */
        /* XXX fix in v.2 on not only checking '1' */
        UTFCHAR buf = (UTFCHAR)UTF8toUnicode((wchar_t)session_data->cf->header.keyname[key2code('1')].wch);
        if (!buf)
        {
            session_data->luc_commit = True;
            if ( session_data->inpinfo->n_mcch > 0 )
                lookup_draw(s);
        }

    }
    /* if it is still in preedit mode, do not pass any other key event out */
    else if(i > 0)
        return True;
    /* if it is not in preedit mode, pass it on */
    else 
        return False;
    
    preedit_draw(s);

#ifdef  DEBUG
    printf("    keycode=%x,keychar=%x, state=%x\n", k->keyCode, k->keyChar, k->modifier);
#endif
    return True;
}

