#include "xcin.h"


int isDebugMode()
{
#ifdef DEBUGMODE
    return 1;
#else
    return 0;
#endif
}

void debug(const char *format, ...)
{
    if(!isDebugMode()) return;

    va_list args;
    va_start(args, format);
    vfprintf(stderr, format, args);
    fprintf(stderr, "\n");
    va_end(args);
}

/*
 * Print debug information for struct gen_inp_conf_t
 */
void printConfInfo( char* function, gen_inp_conf_t* cf )
{
    if(!isDebugMode()) return;
    
    printf("\n*** %s: cf->inp_cname:<%s>\n", function, cf->inp_cname );
    printf("*** %s: cf->inp_ename:<%s>\n", function, cf->inp_ename ); 
    printf("*** %s: cf->tabfn:<%s>\n", function, cf->tabfn );
    printf("*** %s: cf->mode:<%d>\n", function, cf->mode );

    printf("*** %s: cf->header.version:<%s>\n", function, cf->header.version );
    printf("*** %s: cf->header.encoding:<%s>\n", function, cf->header.encoding );
    printf("*** %s: cf->header.icode_mode:<%c>\n", function, cf->header.icode_mode );
    printf("*** %s: cf->header.n_icode:<%d>\n", function, cf->header.n_icode );
    printf("*** %s: cf->header.n_selkey:<%c>\n", function, cf->header.n_selkey );

    printf("*** %s: cf->ccinfo.total_char:<%d>\n", function, cf->ccinfo.total_char );

    printf("*** %s: cf->modesc:<%c>\n", function, cf->modesc );
    printf("*** %s: cf->disable_sel_list:<%s>\n", function, cf->disable_sel_list );
    printf("*** %s: cf->n_kremap:<%d>\n", function, cf->n_kremap );
    printf("*** %s: cf->kremap:<Refer to kremap_t>\n", function );

    printf("*** %s: cf->ic1:<Refer to cf->ic1 again after memory has been allocated>\n", function ); 
    printf("*** %s: cf->ic2:<Refer to cf->ic2 again after memory has been allocated>\n", function );
    printf("*** %s: cf->ichar:<Refer to cf->ichar again after memory has been allocated>\n", function );
}


void printICInfo( char* function, gen_inp_conf_t* cf )
{
    if(!isDebugMode()) return;

    printf("\n*** %s: cf->ic1[0]:<%u>\n", function, cf->ic1[0] );
    printf("*** %s: cf->ic2[0]:<%u>\n", function, cf->ic2 );
    printf("*** %s: cf->icidx[0]:<%hd>\n", function, cf->icidx[0] );
    printf("*** %s: cf->ichar[0]:<%hd>\n", function, cf->ichar[0] );
}



