/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "xcin.h"

char *class_names[] = 
{
    "com.redhat.xcin.Panel",
    "com.redhat.xcin.Aux"
};

/*
 * String at the lower left corner of the screen telling user whether the converstation is off
 */
/*UTFCHAR off_string[] = { 0x82f1, 0x6578, 0 };*/
UTFCHAR off_string[] = { 0 };


void conversion_on( iml_session_t* s )
{
#ifdef DEBUG
    printf("*** conversion_on() ***\n");
#endif

    iml_inst *lp;
    iml_inst *rrv = NULL;

    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
//    int aux_int_data[] = {2};
    session_data->conv_on = True;

    lp = s->If->m->iml_make_start_conversion_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    if (session_data->preedit_start == False)
    {
        lp = s->If->m->iml_make_preedit_done_inst(s);
        s->If->m->iml_link_inst_tail(&rrv, lp);
        session_data->preedit_start = True;
    }
    lp = s->If->m->iml_execute(s, &rrv);

    status_draw(s);
}

void conversion_off( iml_session_t* s ) 
{
#ifdef DEBUG
    printf("*** conversion_off ***\n");
#endif

    iml_inst *lp;
    iml_inst *rrv = NULL;
 
//    int aux_int_data[] = {3};

    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    session_data->conv_on = False;

    /* if preedit exists, commit the string */
    /* REVIEW: commit seems not a proper behaviour, please review
               commit(s);*/
    
    /* clear the preedit string if the conversion is off */
    session_data->preedit_buf[0] = 0;            

    if (session_data->luc_start == True) 
        lookup_end(s);

    if (session_data->preedit_start == True) 
    {
        lp = s->If->m->iml_make_preedit_done_inst(s);
        s->If->m->iml_link_inst_tail(&rrv, lp);
        session_data->preedit_start = False;
        session_data->caret_pos = -1;
    }
    lp = s->If->m->iml_make_end_conversion_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    s->If->m->iml_execute(s, &rrv);

    status_draw(s);	
}


IMFeedbackList* create_feedback( iml_session_t* s, int size )
{
    int i;
    IMFeedbackList *feedback;
    IMFeedback *fb;

#ifdef  DEBUG
    printf("\n### create_feedback( ) ###\n\n");
#endif

    if (s) 
    {
        feedback = (IMFeedbackList *) s->If->m->iml_new(s, sizeof(IMFeedbackList) * size);
    } 
    else 
    {
        feedback = (IMFeedbackList *) calloc(1, sizeof(IMFeedbackList) * size);
    }

    for (i = 0; i < size; i++) 
    {
        IMFeedbackList *fbl = &feedback[i];
        fbl->count_feedbacks = 1;

        if (s) 
        {
            fb = fbl->feedbacks = (IMFeedback *) s->If->m->iml_new(s, sizeof(IMFeedback) * 4);
        } 
        else 
        {
            fb = fbl->feedbacks = (IMFeedback *) calloc(1, sizeof(IMFeedback) * 4);
        }

        memset(fbl->feedbacks, 0, sizeof(IMFeedback) * 4);
    }
    return feedback;
}

void set_feedback( IMFeedbackList* fbl, int normalfeedback )
{
#ifdef  DEBUG
    printf("\n### set_feedback( ) ###\n\n");
#endif

    if (normalfeedback == IMUnderline) 
    {
        set_feedback_private(fbl,
            IMUnderline,
            IM_RGB_COLOR(0, 0, 255),            /* FG: blue */
            IM_RGB_COLOR(255, 255, 255),        /* BG: white */
            IM_RGB_COLOR(0, 0, 255));
    } 
    else if (normalfeedback == IMReverse) 
    {
        set_feedback_private(fbl,
            IMReverse,
            IM_RGB_COLOR(255, 255, 255),        /* FG: white */
            IM_RGB_COLOR(0, 0, 255),            /* BG: blue */
            -1);
    } 
    else 
    {
        set_feedback_private(fbl,
            IMNormal,
            -1,
            -1,
            -1);
    }
}

void set_feedback_private( IMFeedbackList* fbl, int normalfeedback, int fg, int bg, int underline )
{
    int count = 0;
    IMFeedback *fb;

#ifdef  DEBUG
    printf("\n### set_feedback_private( ) ###\n\n");
#endif

    fb = &fbl->feedbacks[count];
    IM_FEEDBACK_TYPE(fb) = IM_DECORATION_FEEDBACK;
    IM_FEEDBACK_VALUE(fb) = normalfeedback;
    count++;

    IM_FEEDBACK_COUNT(fbl) = count;
}

void status_draw( iml_session_t* s )
{
    int len;
    iml_inst *lp;
    iml_inst *rrv = NULL;
    UTFCHAR *str;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));

    int aux_int_data_convon[] = {2};
    int aux_int_data_convoff[] = {3};

    memset(p, 0, sizeof(IMText));
    p->encoding = UTF16_CODESET;

#ifdef  DEBUG
    printf("\n### status_draw( ) ###\n\n");
#endif

    if (session_data->conv_on) 
    {
        str = session_data->on_string;
        aux_draw(desktop_data->auxproxy_session, SAMPLE_AUX_PANEL, 1, aux_int_data_convon, 0, NULL);
    } 
    else 
    {
        str = off_string;
        aux_draw(desktop_data->auxproxy_session, SAMPLE_AUX_PANEL, 1, aux_int_data_convoff, 0, NULL);
    }

    len = UTFCHARLen(str);
    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (len + 1));

    UTFCHARCpy(p->text.utf_chars, str);

    p->char_length = len;

    p->feedback = create_feedback(s, p->char_length);

    if (session_data->status_start == False) 
    {
        lp = s->If->m->iml_make_status_start_inst(s);
        s->If->m->iml_link_inst_tail(&rrv, lp);
        session_data->status_start = True;
    }

    lp = s->If->m->iml_make_status_draw_inst(s, p);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    s->If->m->iml_execute(s, &rrv);
}


void aux_draw( iml_session_t* s, int class_name_id, int count_integers, int *integers, int count_strings, UTFCHAR ** strings )
{
    iml_inst *lp;
    int i;
    int len = 7;
    IMText *lts, *lt;
    IMAuxDrawCallbackStruct *aux;
    MyDataPerDesktop *desktop_data;

#ifdef  DEBUG
    printf("\n### aux_draw( ) ###\n\n");
#endif

    if (!s) return;

    desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

    if (desktop_data->aux_start[class_name_id] == False) 
    {
        printf("AUX is not started.\n");
        return;
    }

    aux = (IMAuxDrawCallbackStruct *) s->If->m->iml_new(s, sizeof(IMAuxDrawCallbackStruct));
    memset(aux, 0, sizeof(IMAuxDrawCallbackStruct));

    aux->aux_name = class_names[class_name_id];

    aux->count_integer_values = count_integers;
    if (aux->count_integer_values) 
    {
        aux->integer_values = (int *) s->If->m->iml_new(s, sizeof(int) * aux->count_integer_values);
        for (i = 0; i < aux->count_integer_values; i++) 
        {
            aux->integer_values[i] = integers[i];
        }
    }
    aux->count_string_values = count_strings;

    if (aux->count_string_values) 
    {
        aux->string_values = lts = (IMText *)
        s->If->m->iml_new(s, sizeof(IMText) * aux->count_string_values);
        memset(aux->string_values, 0, sizeof(IMText) * aux->count_string_values);
        aux->string_values->encoding = UTF16_CODESET;

        for (i = 0, lt = lts; i < aux->count_string_values; i++, lt++) 
        {
            len = UTFCHARLen(strings[i]);
            lt->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (len + 1));
            lt->char_length = len + 1;
            UTFCHARCpy(lt->text.utf_chars, strings[i]);
        }
    }

    lp = s->If->m->iml_make_aux_draw_inst(s, aux);
    s->If->m->iml_execute(s, &lp);
}

/* initialize single imtext */
IMText* init_imtext(iml_session_t* s, UTFCHAR text){
    IMText *label;
    int k;
    
    label = (IMText *) s->If->m->iml_new2(s, sizeof(IMText));
    memset(label, 0, sizeof(IMText));
    label->encoding = UTF16_CODESET;
    label->char_length = 1;
    label->text.utf_chars = (UTFCHAR *) s->If->m->iml_new2(s, sizeof(UTFCHAR) * (label->char_length + 1));
    memset(label->text.utf_chars, 0, sizeof(UTFCHAR));

    label->text.utf_chars[0] = (UTFCHAR)text;
    label->feedback = create_feedback(0, label->char_length);
    for (k = 0; k < label->char_length; k++) 
    {
        set_feedback_private(&label->feedback[k],
            IMNormal,
            IM_RGB_COLOR(0, 0, 0),
            IM_RGB_COLOR(192, 192, 192),
            -1);
    }   

    return label;
}

void lookup_draw( iml_session_t* s )
{
    IMLookupStartCallbackStruct *start;
    iml_inst *lp;
    wch_t *pmcch;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    int i, k, j=0;

    IMLookupDrawCallbackStruct *draw;
    IMText **candidates;
    IMText **labels;
    IMText *label;
    int max_len=0;

    
    if (session_data->luc_candidates == NULL) 
    {
        session_data->luc_candidates = (IMText **) s->If->m->iml_new2(s, MAXCANDIDATES * sizeof(IMText));
        memset(session_data->luc_candidates, 0, MAXCANDIDATES * sizeof(IMText));
    }
    candidates = session_data->luc_candidates;

    if (session_data->luc_labels == NULL)
    {
        session_data->luc_labels = (IMText **) s->If->m->iml_new2(s, MAXCANDIDATES * sizeof(IMText));
        memset(session_data->luc_labels, 0, MAXCANDIDATES * sizeof(IMText));
    }
    labels = session_data->luc_labels;

    j = 0; pmcch = session_data->inpinfo->mcch;
    for (i = 0; i < session_data->inpinfo->n_mcch; i++, j++){
        candidates[j] = init_imtext(s, (UTFCHAR)(UTF8toUnicode(pmcch->wch)));
        pmcch++;
    }

    session_data->max_candidates = j-1;

    /* set empty label */
    label = init_imtext(s, (UTFCHAR)0x20);

    /* set number labels */
    j =0;
    for (i = '1'; i <= '9'; i++, j++) 
        labels[j] = init_imtext(s, (UTFCHAR)i);

    /* lookup start */
    if (session_data->luc_start == False) 
    {
        session_data->luc_top = 0;
        start = (IMLookupStartCallbackStruct *) s->If->m->iml_new(s, sizeof(IMLookupStartCallbackStruct));
        memset(start, 0, sizeof(IMLookupStartCallbackStruct));

        start->whoIsMaster = IMIsMaster;

        start->IMPreference = (LayoutInfo *) s->If->m->iml_new(s, sizeof(LayoutInfo));

        start->IMPreference->choice_per_window = session_data->luc_nchoices;
        start->IMPreference->ncolumns = 1;
        start->IMPreference->nrows = 9;
        start->IMPreference->drawUpDirection = DrawUpHorizontally;
        start->IMPreference->whoOwnsLabel = IMOwnsLabel;

        lp = s->If->m->iml_make_lookup_start_inst(s, start);
        s->If->m->iml_execute(s, &lp);
        session_data->luc_start = True;
    }
    
    /* lookup draw */
    draw = (IMLookupDrawCallbackStruct *) s->If->m->iml_new(s, sizeof(IMLookupDrawCallbackStruct));
    memset(draw, 0, sizeof(IMLookupDrawCallbackStruct));
    draw->index_of_first_candidate = 0;
    draw->index_of_last_candidate = 8;
    draw->n_choices = draw->index_of_last_candidate - draw->index_of_first_candidate + 1;

    draw->title = (IMText *) NULL;

    draw->choices = (IMChoiceObject *) s->If->m->iml_new(s, draw->n_choices * sizeof(IMChoiceObject));
    memset(draw->choices, 0, draw->n_choices * sizeof(IMChoiceObject));

    for (i = 0; i < draw->n_choices; i++) 
    {
        IMText *vt;		/* for value */
        IMText *lt;		/* for label */

        vt = draw->choices[i].value = candidates[i + session_data->luc_top];
        /* if it is ready to commit, use numbers for label, otherwise empty */
        if(session_data->luc_commit == True)
            lt = draw->choices[i].label = labels[i];
        else
            lt = draw->choices[i].label = label;

        if(vt->char_length != NULL)
            if (max_len < vt->char_length)
                max_len = vt->char_length;

        if (i + session_data->luc_top == session_data->max_candidates) 
        {
            draw->index_of_first_candidate = 0;
            draw->index_of_last_candidate = i;
            draw->n_choices = i + 1;
            break;
        }

    }

    draw->max_len = max_len;
    draw->index_of_current_candidate = session_data->luc_current_candidate;

    lp = s->If->m->iml_make_lookup_draw_inst(s, draw);
    s->If->m->iml_execute(s, &lp);
}

void lookup_next(iml_session_t * s)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    session_data->luc_top += session_data->luc_nchoices;
    session_data->luc_current_candidate = 0;
    if (session_data->luc_top > session_data->max_candidates) 
    {
        session_data->luc_top = 0;
    }
}

void lookup_prev(iml_session_t * s)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    session_data->luc_top -= session_data->luc_nchoices;
    session_data->luc_current_candidate = 0;
    if (session_data->luc_top < 0) 
    {
        int p = session_data->max_candidates % session_data->luc_nchoices;
        session_data->luc_top = session_data->max_candidates - p;
    }
}

void commit(iml_session_t * s, UTFCHAR *output)
{
    int len, i;
    iml_inst *lp;
    iml_inst *rrv = NULL;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    memset(p, 0, sizeof(IMText));
    p->encoding = UTF16_CODESET;
    
    len = UTFCHARLen(output);
    
    if (len == 0) {
        /* no preedit */
        return;
    }
    lp = s->If->m->iml_make_preedit_erase_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);
    
    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (len + 1));
    UTFCHARCpy(p->text.utf_chars, output);
    p->char_length = len;
    p->feedback = create_feedback(s, p->char_length);
    
    lp = s->If->m->iml_make_commit_inst(s, p);
    s->If->m->iml_link_inst_tail(&rrv, lp);
    s->If->m->iml_execute(s, &rrv);
    
}

Bool lookup_commit(iml_session_t * s, int index)
{
    int i;
    iml_inst *lp;
    iml_inst *rrv = NULL;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    IMText **candidates = session_data->luc_candidates;
    
    index += session_data->luc_top;
    
    if(session_data->luc_candidates == NULL || candidates[index] == NULL)
        return False;

    lp = s->If->m->iml_make_lookup_done_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);
    session_data->luc_current_candidate = 0;

    lp = s->If->m->iml_make_preedit_erase_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    lp = s->If->m->iml_make_commit_inst(s, candidates[index]);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    lp = s->If->m->iml_make_lookup_done_inst(s);
    s->If->m->iml_link_inst_tail(&rrv, lp);

    s->If->m->iml_execute(s, &rrv);

    i = UTFCHARLen(session_data->preedit_buf);
    
    /* Empty the buffer so that alphabet will not appear after commiting character */
    session_data->preedit_buf[0] = 0;
    session_data->iccf->keystroke[0] = 0;
    preedit_draw(s);
    
    /* Empty candidates so that next commit won't grab the previous one */
    /* TODO: see if it impacts the preformance */
    memset(session_data->luc_candidates, 0, MAXCANDIDATES * sizeof(IMText));

    session_data->luc_start = False;
    session_data->luc_commit = False;

    return True;
}

Bool lookup_end(iml_session_t *s)
{
    iml_inst *lp;
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    
    if (session_data->luc_start == True) {
        lp = s->If->m->iml_make_lookup_done_inst(s);
        s->If->m->iml_execute(s, &lp);
        session_data->luc_start = False;
        session_data->luc_commit = False;
        return True;
    } else
        return False;
}

/*
 * This function perform the actual output onto the screen
 */
void preedit_draw( iml_session_t* s )
{
    iml_inst *lp;
    iml_inst *rrv = NULL;

#ifdef  DEBUG
    printf("\n### preedit_draw( ) ###\n\n");
#endif

    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    IMText *p = make_preedit_imtext(s);

    if (session_data->preedit_start == False)
    {
        lp = s->If->m->iml_make_preedit_start_inst(s);
        s->If->m->iml_link_inst_tail(&rrv, lp);
        session_data->preedit_start = True;
    }

    /* the magic line tt makes the preedit works like a charm
     * w/o the line the buffer still can be filled and display after the conversion is off
     */
    lp = s->If->m->iml_make_preedit_draw_inst(s, p);
                
    s->If->m->iml_link_inst_tail(&rrv, lp);
    s->If->m->iml_execute(s, &rrv);
}

IMText* make_preedit_imtext( iml_session_t * s )
{
    int len;
    int i;

#ifdef  DEBUG
    printf("\n### make_preedit_imtext( ) ###\n\n");
#endif

    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    IMText *p = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
    memset(p, 0, sizeof(IMText));

    p->encoding = UTF16_CODESET;
    len = UTFCHARLen(session_data->preedit_buf);
    p->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * (len + 1));
    UTFCHARCpy(p->text.utf_chars, session_data->preedit_buf);
    p->char_length = len;

    p->feedback = create_feedback(s, p->char_length);

    for (i = 0; i < p->char_length; i++)
    {
        set_feedback(&p->feedback[i], get_feedback(&session_data->preedit_feedback[i]));
#ifdef DEBUG        
        printf("   p->text.utf_chars[i]: 0x%x[%d %d]\n\n", 
          p->text.utf_chars[i], get_feedback(&p->feedback[i]), get_feedback(&session_data->preedit_feedback[i]));
#endif
    }
    return p;
}

int get_feedback( IMFeedbackList* fbl )
{
#ifdef  DEBUG
    printf("\n### get_feedback( ) ###\n\n"); 
#endif

    /* returns IM_DECORATION_FEEDBACK */
    IMFeedback *fb = &fbl->feedbacks[0];
    return IM_FEEDBACK_VALUE(fb);
}

