/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "support.h"
#include "iiim-properties.h"
#include "iiimcf.h" 

LanguageID *setget_langstr_to_lang_id (gchar *);

static IIIMProps *iiim_props;

/*
 * set/get iiim_props
 */
void util_set_iiimprops (IIIMProps *iiimprops)
{
  iiim_props = iiimprops;
}

IIIMProps *util_get_iiimprops ()
{
  return iiim_props;
}

/*
 * get use engine list
 * If user preference is NULL, then return available list
 */
GSList *util_get_use_engine_list (gchar *lang_id, GSList *available_list)
{
  GSList *lang_list = iiim_props->l_languages->langs;
  GSList *lp;
  GSList *engines = NULL;
  GSList *ret;

  for (lp = lang_list; lp; lp = g_slist_next (lp))
    {
      LanguageID *lid = (LanguageID *)lp->data;
      if (!strcmp (lang_id, lid->id) && lid->engines != NULL)
	{
	  engines = lid->engines;
	  break;
	}
    }
  if (engines == NULL)
    {
      ret = available_list;
    }
  else
    {
      ret = engines;
    }
  return ret;
}

/*
 * Activate widget
 */
void util_activate (GtkWidget *parent, gchar *s)
{
  GtkWidget *w = lookup_widget (parent, s);
  gtk_widget_set_sensitive (w, TRUE);
}

/*
 * Deactivate widget
 */
void util_deactivate (GtkWidget *parent, gchar *s)
{
  GtkWidget *w = lookup_widget (parent, s);
  gtk_widget_set_sensitive (w, FALSE);
}

/*
 * make lang_id list from List UI model
 */
GSList *util_store_to_lang_id_list (GtkListStore *store)
{
  GSList *list = NULL;
  GtkTreeIter iter;
  GtkTreeModel *model = GTK_TREE_MODEL (store);
  gboolean valid;

  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid)
    {
      gchar *str_data;
      gtk_tree_model_get (model, &iter, 0, &str_data, -1);
      list = g_slist_append (list, setget_langstr_to_lang_id (str_data));
      valid = gtk_tree_model_iter_next (model, &iter);
    }
  return list;
}

/*
 * convert List model to list
 */
GSList *util_store_to_list (GtkListStore *store)
{
  GSList *list = NULL;
  GtkTreeIter iter;
  GtkTreeModel *model = GTK_TREE_MODEL (store);
  gboolean valid;

  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid)
    {
      gchar *str_data;
      gtk_tree_model_get (model, &iter, 0, &str_data, -1);
      list = g_slist_append (list, str_data);
      valid = gtk_tree_model_iter_next (model, &iter);
    }
  return list;
}

void util_message (GtkWidget *w, gchar *msg)
{
  GtkWidget *dialog;

  dialog = gtk_message_dialog_new (GTK_WINDOW (w),
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_ERROR,
				   GTK_BUTTONS_CLOSE,
				   msg);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

void util_free_hotkeys (Hotkeys *hotkeys)
{
  if (hotkeys != NULL && hotkeys->hotkeys != NULL)
    {
      g_slist_free (hotkeys->hotkeys);
      g_free (hotkeys);
    }
}

Hotkeys *util_list_to_hotkeys (GSList *list)
{
  GSList *lp;
  Hotkeys *hotkeys = g_new0(Hotkeys, 1);
  GSList *hk = NULL;

  for (lp = list; lp; lp = g_slist_next (lp))
    {
      hk = g_slist_append (hk, lp->data);
    }
  hotkeys->hotkeys = hk;
  return hotkeys;
}
