/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "support.h"
#include "iiim-properties.h"

struct MiscSetting {
  gboolean list_enabled;
  gboolean cycle_enabled;
};
static struct MiscSetting misc_setting;
static GtkWidget *dialog = NULL;

void misc_initialize (GtkWidget *widget, IIIMProps *iiim_props)
{
  dialog = widget;

  misc_setting.list_enabled = iiim_props->b_lang_list_enabled;
  misc_setting.cycle_enabled = iiim_props->b_misc_hotkey_enabled;
}

void util_free_hotkeys (Hotkeys *);
Hotkeys *util_list_to_hotkeys (GSList *);
GSList *util_store_to_list (GtkListStore *);
void misc_update_properties (IIIMProps *iiim_props)
{
  /* popup menu lang switch hotkey */
  GtkWidget *list = lookup_widget (dialog, "popupHotkeyList");
  GSList *key_list =
    util_store_to_list ((GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list)));
  util_free_hotkeys (iiim_props->l_lang_list_hotkey);
  iiim_props->l_lang_list_hotkey = util_list_to_hotkeys (key_list);

  /* cycle lang switch hotkey */
  list = lookup_widget (dialog, "langswitchHotkeyList");
  key_list =
    util_store_to_list ((GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list)));
  util_free_hotkeys (iiim_props->l_cycle_lang_hotkey);
  iiim_props->l_cycle_lang_hotkey = util_list_to_hotkeys (key_list);

  /* reverse cycle lang switch hotkey */
  list = lookup_widget (dialog, "reverseLangswitchHotkeyList");
  key_list =
    util_store_to_list ((GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list)));
  util_free_hotkeys (iiim_props->l_reverse_cycle_lang_hotkey);
  iiim_props->l_reverse_cycle_lang_hotkey = util_list_to_hotkeys (key_list);

  iiim_props->b_lang_list_enabled = misc_setting.list_enabled;
  iiim_props->b_misc_hotkey_enabled = misc_setting.cycle_enabled;
}

/* --------- */
void misc_enable_list_toggled (GtkToggleButton *button, gpointer user_data)
{
  misc_setting.list_enabled = gtk_toggle_button_get_active (button);
}

void misc_enable_cycle_toggled (GtkToggleButton *button, gpointer user_data)
{
  misc_setting.cycle_enabled = gtk_toggle_button_get_active (button);
}

void util_activate (GtkWidget *, gchar *);
void util_deactivate (GtkWidget *, gchar *);

/* --------- */
void misc_list_hotkey_clicked (GtkTreeView *treeview, gpointer user_data)
{
  util_activate (GTK_WIDGET (treeview), "popupHotkeyRemoveButton");
}

void hkc_popup_dialog (GtkWidget *);
void misc_add_list_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "popupHotkeyList");
  hkc_popup_dialog (list);
}

void misc_remove_list_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "popupHotkeyList");
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;

  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);

  if (!gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path))
    {
      util_deactivate (GTK_WIDGET (button), "popupHotkeyRemoveButton");
    }
}

/* --------- */
void misc_cycle_hotkey_clicked (GtkTreeView *treeview, gpointer user_data)
{
  util_activate (GTK_WIDGET  (treeview), "langswitchHotkeyRemoveButton");
}

void misc_add_cycle_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "langswitchHotkeyList");
  hkc_popup_dialog (list);
}

void misc_remove_cycle_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "langswitchHotkeyList");
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;

  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);

  if (!gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path))
    {
      util_deactivate (GTK_WIDGET (button), "langswitchHotkeyRemoveButton");
    }
}

/* --------- */
void misc_reverse_cycle_hotkey_clicked (GtkTreeView *treeview, gpointer user_data)
{
  util_activate (GTK_WIDGET  (treeview), "reverseLangswitchHotkeyRemoveButton");
}

void misc_add_reverse_cycle_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "reverseLangswitchHotkeyList");
  hkc_popup_dialog (list);
}

void misc_remove_reverse_cycle_hotkey_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list = lookup_widget (GTK_WIDGET (button), "reverseLangswitchHotkeyList");
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;

  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);

  if (!gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path))
    {
      util_deactivate (GTK_WIDGET (button), "reverseLangswitchHotkeyRemoveButton");
    }
}

