
#ifndef __GIMLET_H__
#define __GIMLET_H__

/* compatible with iiim-properties.h */
#define IIIM_KEY_DIR "/desktop/input_methods"

#define KEY_ENABLE_IM IIIM_KEY_DIR "/enable"                       /* enable/disable entire IM */
#define KEY_ENABLE_STATUS IIIM_KEY_DIR "/status"                   /* show the status info on panel or application */
#define KEY_STATUS_PLACEMENT IIIM_KEY_DIR "/status_placement"      /* where to place the status area */
#define KEY_ON_OFF_POLICY IIIM_KEY_DIR  "/on_off_policy"           /* activate IM when switching or not*/
#define KEY_LANG_SWITCH_POLICY IIIM_KEY_DIR "/lang_switch_policy"  /* apply the switched LE to entire desktop or just for current IC */
#define KEY_LANG_LAST_SELECTION IIIM_KEY_DIR "/language_last_selection"
#define KEY_REMEMBER_LAST_LE IIIM_KEY_DIR "/remember_last_le"

/* each entry of the list contains language name (short name) 
 * and related le names, the sequence of le name indidate the 
 * priority. */
#define KEY_LANG_TO_USE_LIST IIIM_KEY_DIR "/languages_use" 

/* each entry of the list contains language name (short name) 
 * and the localized name. */
#define KEY_LANG_TO_SAVE_LIST IIIM_KEY_DIR "/languages_save"

/* saved position (rootX and rootY) for iiim-panel standard alone window, used in CDE env */
#define KEY_PANEL_SAVED_POSITION_X IIIM_KEY_DIR "/panel_saved_position_x"
#define KEY_PANEL_SAVED_POSITION_Y IIIM_KEY_DIR "/panel_saved_position_y"

/* X properties */
#define SWITCHER "_IIIM_SWITCHER"
#define SWITCHER_LANGUAGE SWITCHER "_CURRENT_INPUT_LANGUAGE"
#define SWITCHER_CLIENT SWITCHER "_CURRENT_CLIENT"
#define SWITCHER_STATUS SWITCHER "_STATUS_TEXT"
#define SWITCHER_CONVERSION SWITCHER "_SET_CONVERSION_MODE"

/* value string in gconf registry */
#define V_TRUE "True"
#define V_FALSE "False"

#define V_DESKTOP_DEFAULT "DesktopDefault"
#define V_PANEL           "Panel"
#define V_ATTACH_FRAME    "AttachFrame"
#define V_NONE            "None"

typedef enum {
  ON_DESKTOP_PANEL,
  ATTACH_TO_APP_FRAME,
  NONE
} IMStatusPlacement;

typedef struct _GimletWindow GimletWindow;

struct _GimletWindow
{
  GtkWidget	*applet;
  GtkWidget	*about_dialog;
  GtkTooltips	*tooltips;

  GtkWidget *drawing_area;
  GtkWidget *status_label;
  GtkWidget *lang_menu;
  GtkWidget *help_menu;

  /* input method settings */
  gboolean im_enabled;
  gboolean status_enabled;
  IMStatusPlacement status_placement;

  /* fix me, the next ones should be per client */
  GdkWindow *last_client;
  gchar *current_iiim_lang;

  gboolean conversion_mode;
  gboolean le_list_changed;
};

extern GimletWindow *gimlet;
#endif /* __GIMLET_H__ */
