/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.sym.xml;

import com.sun.g11n.vkb.*;
import com.sun.g11n.vkb.sym.*;
import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import static com.sun.g11n.vkb.Main.*;
import static com.sun.g11n.vkb.sym.xml.XMLSymbol.*;
import static com.sun.g11n.vkb.XMLUtil.*;

/**
 *
 * @author naoyuki
 */
public class XMLCustomLayoutManager {
    
    private DocumentBuilder docBuilder;
    private String SYSTEM_DIR;
    private String USER_DIR;
    private String SUFFIX;
    
    //private ResourceBundle idmap;
    
    private XMLCustomLayoutManager() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = factory.newDocumentBuilder();
            SYSTEM_DIR = getSystemConfigDir();
            USER_DIR = getUserConfigDir();
            SUFFIX = getLayoutFileSuffix();
        } catch(Exception e) {
            e.printStackTrace();
            error("XML DocumentBuilder is not found.");
        }
        //idmap = ResourceBundle.getBundle("com.sun.g11n.vkb.sym.vkb-symbol-id");
    }
    
    private static XMLCustomLayoutManager layoutSaver;
    public static XMLCustomLayoutManager getInstance() {
        if (layoutSaver == null) {
            layoutSaver = new XMLCustomLayoutManager();
        }
        return layoutSaver;
    }
    private static String normalize(String name) {
        return name.replaceAll(" ", "_").replaceAll("/", "_").toLowerCase();
    }
    
    private class SourceHolder {
        private String srcCandidate;
        private Map<String, KeyModel> keyMap;
        SourceHolder(Map<String, KeyModel> keyMap, String srcCandidate) {
            Map<String, KeyModel> keyMapCopy = new HashMap<String, KeyModel>();
            keyMapCopy.putAll(keyMap);
            this.keyMap = keyMapCopy;
            this.srcCandidate = srcCandidate;
        }
        String getSource() {
            return srcCandidate;
        }
        Map<String, KeyModel> getKeyMap() {
            return keyMap;
        }
    }
    private Map<String, SourceHolder> customKeyMap;
    public void setCustomDict(String name, Map<String, KeyModel> customKeyMap, String srcName) {
        if (this.customKeyMap == null) {
            this.customKeyMap = new HashMap<String, SourceHolder>();
        }
        this.customKeyMap.put(name, new SourceHolder(customKeyMap, srcName));
    }
    
    /*
     * create new id from sourceName
     */
    private String getCustomID(String sourceName) {
        VKBManager manager = VKBManager.getInstance();
        String sourceID = manager.getSymbolID(sourceName);
        return manager.createSymbolID(sourceID);
    }
    
    public boolean save(KeyViewSet keyViewSet, String name, boolean system) {
        String dirname = system ? SYSTEM_DIR : USER_DIR;
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String fullPath = dirname + File.separator + normalize(name) + SUFFIX;
        Document document = docBuilder.newDocument();
        Element root = document.createElement(ROOT);
        document.appendChild(root);
        Element layout = document.createElement(LAYOUT);
        writeTextAttr(layout, TYPE, name);
        writeTextAttr(layout, CUSTOM, TRUE);
        String sourceName = keyViewSet.getSymbolName();

        String newID = getCustomID(sourceName);
        VKBManager.getInstance().registerSymbolID(name, newID);

        writeTextAttr(layout, ID, newID);
        
        for (;;) {
            if (customKeyMap != null && customKeyMap.containsKey(sourceName)) {
                SourceHolder holder = customKeyMap.get(sourceName);
                Map<String, KeyModel> keyMap = holder.getKeyMap();
                for (KeyModel model : keyMap.values()) {
                    Element elm = document.createElement(KEY);
                    writeTextAttr(elm, SYMBOL, model.getName());
                    writeText(document, elm, STR1, model.getLabel(0));
                    writeText(document, elm, STR2, model.getLabel(1));
                    writeText(document, elm, STR3, model.getLabel(2));
                    writeText(document, elm, STR4, model.getLabel(3));
                    writeInt(document, elm, CODE, model.getCode());
                    layout.appendChild(elm);
                }
                sourceName = holder.getSource();
            } else {
                break;
            }
        }
        writeTextAttr(layout, SOURCE, sourceName);
        root.appendChild(layout);
        
        for (KeyView view : keyViewSet.getKeyViews()) {
            if (view.isModified()) {
                Element elm = document.createElement(KEY);
                KeyModel model = view.getModel();
                writeTextAttr(elm, SYMBOL, model.getName());
                writeText(document, elm, STR1, model.getLabel(0));
                writeText(document, elm, STR2, model.getLabel(1));
                writeText(document, elm, STR3, model.getLabel(2));
                writeText(document, elm, STR4, model.getLabel(3));
                writeInt(document, elm, CODE, model.getCode());
                layout.appendChild(elm);
            }
        }

        // write out to xml file
        XMLUtil.setPrettyPrint(true);
        String xmlStr = toXMLString(root);
        return writeOut(fullPath, xmlStr);
    }
    
    public void saveNonUseList(List<Symbol> nonUseSymList) {
        String fullPath = USER_DIR + File.separator + getUserConfigFile();
        File dir = new File(USER_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        Document document = docBuilder.newDocument();
        Element root = document.createElement(CONFIG_ROOT);
        document.appendChild(root);
        Element nulist = document.createElement(NON_USE_LIST);
        for (Symbol sym : nonUseSymList) {
            writeText(document, nulist, TYPE, sym.getDescription());
        }
        root.appendChild(nulist);
        XMLUtil.setPrettyPrint(true);
        String xmlStr = toXMLString(root);
        writeOut(fullPath, xmlStr);
    }

    private boolean writeOut(String path, String xmlStr) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            OutputStreamWriter osw = new OutputStreamWriter(fos, "UTF-8");
            osw.write(xmlStr);
            osw.close();
        } catch(IOException e) {
            error("Writing file \"" + path + "\" has problem.");
            return false;
        }
        return true;
    }
}
