/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.iiim;

import java.util.*;
import com.sun.g11n.vkb.*;
import static java.awt.event.KeyEvent.*;
/**
 *
 * @author naoyuki
 */
public class IIIMInterface_Impl implements IMInterface {

    @Override public void sendText(String text) {
        // call native method here
        sendIIIMText(text);
    }
    
    @Override public void sendKeyEvent(int code, int ch, int modifier, long time_stamp) {
        sendIIIMKeyEvent(code, ch, modifier, (int)time_stamp);
    }
    
    @Override public int getKeyCodeFromLabel(String label) {
        Integer code = iiimCodeMap.get(label);
        if (code == null) 
            return -1;
        return code;
    }
    
    @Override public void sendCustomLayoutToIM() {
    // this function is build by small C utility command
    // so that it can be called from start up script
    // like iiimx-settings-init
        
    }
    
    @Override public void syncKeyboard(String id) {
        syncIIIMKeyboard(id);
    }
    
    @Override public void resetSyncKeyboard() {
        resetSyncIIIMKeyboard();
    }
    
    @Override public void invokeNativeHelp() {
        invokeGNOMENativeHelp();
    }
    
    public IIIMInterface_Impl() {
    }
    

    private static Map<String, Integer> iiimCodeMap;
    static {
        //String path = System.getProperty("java.library.path");
        //path = path + ":" + "/usr/lib/iiim";
        //System.setProperty("java.library.path", path);
        //System.loadLibrary("iiimvkb_jni");
        System.load("/usr/lib/iiim/libiiimvkb_jni.so");        
            
        iiimCodeMap = new HashMap<String, Integer>();
        // IIIM uses Java AWT compatible keycode
        iiimCodeMap.put("FK01", VK_F1);
        iiimCodeMap.put("FK02", VK_F2);
        iiimCodeMap.put("FK03", VK_F3);
        iiimCodeMap.put("FK04", VK_F4);
        iiimCodeMap.put("FK05", VK_F5);
        iiimCodeMap.put("FK06", VK_F6);
        iiimCodeMap.put("FK07", VK_F7);
        iiimCodeMap.put("FK08", VK_F8);
        iiimCodeMap.put("FK09", VK_F9);
        iiimCodeMap.put("FK10", VK_F10);
        iiimCodeMap.put("FK11", VK_F11);
        iiimCodeMap.put("FK12", VK_F12);
        iiimCodeMap.put("FK13", VK_F13);
        iiimCodeMap.put("PRSC", VK_PRINTSCREEN);
        iiimCodeMap.put("SCLK", VK_SCROLL_LOCK);
        iiimCodeMap.put("PAUS", VK_PAUSE);
        iiimCodeMap.put("INS", VK_INSERT);
        iiimCodeMap.put("HOME", VK_HOME);
        iiimCodeMap.put("PGUP", VK_PAGE_UP);
        iiimCodeMap.put("END", VK_END);
        iiimCodeMap.put("PGDN", VK_PAGE_DOWN);
        iiimCodeMap.put("UP", VK_UP);
        iiimCodeMap.put("LEFT", VK_LEFT);
        iiimCodeMap.put("DOWN", VK_DOWN);
        iiimCodeMap.put("RGHT", VK_RIGHT);
        iiimCodeMap.put("KPDV", VK_DIVIDE);
        iiimCodeMap.put("KPMU", VK_MULTIPLY);
        iiimCodeMap.put("KPSU", VK_SUBTRACT);
        iiimCodeMap.put("KPAD", VK_ADD);
        iiimCodeMap.put("KPDL", VK_DELETE);
        iiimCodeMap.put("KP1", VK_NUMPAD1);
        iiimCodeMap.put("KP2", VK_NUMPAD2);
        iiimCodeMap.put("KP3", VK_NUMPAD3);
        iiimCodeMap.put("KP4", VK_NUMPAD4);
        iiimCodeMap.put("KP5", VK_NUMPAD5);
        iiimCodeMap.put("KP6", VK_NUMPAD6);
        iiimCodeMap.put("KP7", VK_NUMPAD7);
        iiimCodeMap.put("KP8", VK_NUMPAD8);
        iiimCodeMap.put("KP9", VK_NUMPAD9);
        iiimCodeMap.put("KP0", VK_NUMPAD0);
        iiimCodeMap.put("STOP", VK_STOP);
        iiimCodeMap.put("AGAI", VK_AGAIN);
        iiimCodeMap.put("PROP", VK_PROPS);
        iiimCodeMap.put("UNDO", VK_UNDO);
        //iiimCodeMap.put("FRNT", VK_FRONT);
        iiimCodeMap.put("COPY", VK_COPY);
        //iiimCodeMap.put("OPEN", VK_OPEN);
        iiimCodeMap.put("PAST", VK_PASTE);
        iiimCodeMap.put("FIND", VK_FIND);
        iiimCodeMap.put("CUT", VK_CUT);
        iiimCodeMap.put("HELP", VK_HELP);
        iiimCodeMap.put("COMP", VK_COMPOSE);
        iiimCodeMap.put("HZTG", VK_INPUT_METHOD_ON_OFF);
        iiimCodeMap.put("MENU", VK_CONTEXT_MENU);
        iiimCodeMap.put("BKSP", VK_BACK_SPACE);
        iiimCodeMap.put("TAB", VK_TAB);
        iiimCodeMap.put("RTRN", VK_ENTER);
        iiimCodeMap.put("DELE", VK_DELETE);
        iiimCodeMap.put("ESC", VK_ESCAPE);
    }
    
    private native void sendIIIMText(String text);
    private native void sendIIIMKeyEvent(int code, int ch, int modifier, int time_stamp);
    private native void syncIIIMKeyboard(String id);
    private native void resetSyncIIIMKeyboard();
    private native void invokeGNOMENativeHelp();
    
    public static void main(String[] args) {
        try {
            Class clz = Class.forName("com.sun.g11n.vkb.iiim.IIIMInterface_Impl");
            IMInterface imi = (IMInterface)clz.newInstance();
            for (int i = 0, len = args.length; i < len; i++) {
                imi.sendText(args[i]);
            }
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
}
