/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom.xml;

import com.sun.g11n.vkb.geom.*;
import java.util.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.awt.geom.*;

import com.sun.g11n.vkb.*;
import static com.sun.g11n.vkb.Main.*;
import static com.sun.g11n.vkb.XMLUtil.*;

/**
 *
 * @author naoyuki
 */

/*
 * VKB XML format is
 * <vkbdata predefined="boolean">
 *   <desc>Description</desc>  
 *   <symbol>symbol name</symbol> <!-- OPTION User defined data will have this --> 
 *   <width>width</width>
 *   <height>height</height>
 *   <shape>default shape name</shape>
 *   <section_left>section default left</sction_left>
 *   <row_left>row default left</row_left>
 *   <shapemap>
 *      <shape name="name">
 *      </shape>
 *      <shape name="name">
 *         <cornerRadius>xx</cornerRadius>
 *         <width>width</width>
 *         <height>height</height>
 *         <points>x, y, x, y, ...</points>
 *         <points>x, y, ....</point>
 *      ...
 *      </shape>
 *   </shapemap>
 *   <section>
 *      <top>y</top?
 *      <left>x</left>
 *      <gap>xgap</gap>
 *      <shape>name</shape>
 *      <row>
 *         <top>y</top>
 *         <left>x</left>
 *         <gap>xgap</gap>
 *         <shape>name</shape>
 *         <key>
 *             <top>y</top>
 *             <left>x</left>
 *             <shape>name</shape>
 *             <gap>xgap</gap>
 *             <model>keysymbol</model>
 *         </key>
 *         <key>
 *         ...
 *         </key>
 *      </row>
 *      <row>
 *         <key>
 *         ...
 *         </key>
 *      </row>
 *   </section>
 *   <section>
 *   ...
 *   </section>
 * </vkbdata>
 */
public class XMLGeometryWriter {
    private Set<Geometry> geomSet;
    private File outDir;
    private DocumentBuilder docBuilder;
    
    public XMLGeometryWriter(File dir, GeometryCollection geoms) {
        if (!dir.canWrite()) {
            error("output dir is not writable.");
        }
        outDir = dir;
        geomSet = geoms.getGeometrySet();
        DocumentBuilderFactory facotry = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = facotry.newDocumentBuilder();        
        } catch(Exception e) {
            e.printStackTrace();
            error("XML DocumentBuilder is not found.");
        }
    }
    
    public void writeOut() {
        for (Geometry geom : geomSet) {
            writeOutGeom(geom, true);
        }
    }
    
    /*
     * preset false means the geom is user defined one
     */ 
    public void writeOutGeom(Geometry geom, boolean preset) {
        String prefix;
        if (preset) {
            prefix = PREFIX;
        } else {
            prefix = PREFIX_USER;
        }
        String name = geom.toString();
        if (name != null) {
            name = prefix + name.replace(' ', '_').replace('/', '_').toLowerCase();
            
            // prepare XMLDocument
            Document document = docBuilder.newDocument();
            Element root = document.createElement(ROOT);
            document.appendChild(root);
            // Description
            writeText(document, root, DESC, geom.toString());
            // Width
            writeFloat(document, root, WIDTH, geom.getWidth());
            // Height
            writeFloat(document, root, HEIGHT, geom.getHeight());
            // Default shape
            writeText(document, root, SHAPE, geom.getDefaultShape());
            // Section default left
            writeFloat(document, root, SECTION_LEFT, geom.getSectionLeft());
            // Row default left
            writeFloat(document, root, ROW_LEFT, geom.getRowLeft());
            // Default X Gap
            writeFloat(document, root, GAP, geom.getDefaultGap());
            // Shape Map
            Element smapElm = document.createElement(SHAPEMAP);
            Map<String, KeyShape> shapeMap = geom.getShapeMap();
            Set<String> keySet = shapeMap.keySet();
            for (String key : keySet) {
                Element elm = document.createElement(SHAPE);
                elm.setAttribute(NAME, key);
                KeyShape ks = shapeMap.get(key);
                elm.setAttribute(WIDTH, Float.toString((float)ks.getWidth()));
                elm.setAttribute(HEIGHT, Float.toString((float)ks.getHeight()));
                elm.setAttribute(CORNERRADIUS, Float.toString((float)ks.getCornerRadius()));
                Set<List<Point2D.Float>> pointListSet = ks.getPointSet();
                for (List<Point2D.Float> list : pointListSet) {
                    Element points = document.createElement((POINTS));
                    String pointString = toPString(list);
                    points.appendChild(document.createTextNode(pointString));
                    elm.appendChild(points);
                }
                smapElm.appendChild(elm);
            }
            root.appendChild(smapElm);
            // Section
            Map<String, KeySection> sectionMap = geom.getSectionMap();
            Set<String> sectionNames = sectionMap.keySet();
            for (String sname : sectionNames) {
                Element  sectionElm = document.createElement(SECTION);
                sectionElm.setAttribute(NAME, sname);
                KeySection section = sectionMap.get(sname);
                writeText(document, sectionElm, SHAPE, section.getDefaultShapeName());
                writeFloat(document, sectionElm, TOP, section.getTop());
                writeFloat(document, sectionElm, LEFT, section.getLeft());
                writeFloat(document, sectionElm, GAP, section.getGap());

                List<KeyRow> rowList = section.getRowList();
                for (KeyRow row : rowList) {
                    Element rowElm = document.createElement(ROW);
                    writeFloat(document, rowElm, TOP, row.getTop());
                    writeFloat(document, rowElm, LEFT, row.getLeft());
                    writeFloat(document, rowElm, GAP, row.getGap());
                    writeText(document, rowElm, SHAPE, row.getShapeName());
                    writeText(document, rowElm, COLOR, row.getColor());
                    List<KeyInfo> keyList = row.getKeyInfoList();
                    for (KeyInfo keyInfo : keyList) {
                        Element keyElm = document.createElement(KEY);
                        keyElm.setAttribute(NAME, keyInfo.getLabel());
                        writeTextAttr(keyElm, SHAPE, keyInfo.getShapeName());
                        writeTextAttr(keyElm, COLOR, keyInfo.getColor());
                        writeFloatAttr(keyElm, GAP, keyInfo.getGap());
                        rowElm.appendChild(keyElm);
                    }
                    sectionElm.appendChild(rowElm);                    
                }
                root.appendChild(sectionElm);
            }
            

            XMLUtil.setPrettyPrint(true);
            String geomStr = toXMLString(root);
            try {
                File f = new File(outDir, name + SUFFIX);
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                osw.write(geomStr);
                osw.close();
            } catch(Exception e) {
                e.printStackTrace();
                error("XML output file " + name + " can not be created.");
            }
        } else {
            // if name is null, then that geom is include only geom
            // just ignore it            
        }
    }
    

    static final String PREFIX = "VKB_";
    static final String PREFIX_USER = "VKB_UD_";
    static final String SUFFIX = ".vkx";
    
    static final String ROOT = "vkbdata";
    static final String DESC = "desc";
    static final String WIDTH = "width";
    static final String HEIGHT = "height";
    static final String SHAPEMAP = "shapemap";
    static final String SHAPE = "shape";
    static final String SECTION_LEFT = "section_left";
    static final String ROW_LEFT = "row_left";
    static final String CORNERRADIUS = "cornerRadius";
    static final String NAME = "name";
    static final String SECTION = "section";
    static final String TOP = "top";
    static final String LEFT = "left";
    static final String GAP = "xgap";
    static final String ROW = "row";
    static final String KEY = "key";
    static final String POINTS = "points";
    static final String COLOR = "color";
    
    static final boolean pretty_print = true;
}
