/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom.xml;

import com.sun.g11n.vkb.*;
import com.sun.g11n.vkb.geom.*;
import static com.sun.g11n.vkb.Main.*;

import java.util.*;

/**
 *
 * @author naoyuki
 */
public class XMLGeometry implements Geometry, Comparable {

    private String description;
    void setDescription(String description) {
        this.description = description;
    }
    @Override public String getDescription() {
        return description;
    }
    
    private float width;
    void setWidth(float width) {
        this.width = width;
    }
    @Override public float getWidth() {
        return width;
    }
    
    private float height;
    void setHeight(float height) {
        this.height = height;
    }
    @Override public float getHeight() {
        return height;
    }
    
    private Map<String, KeySection> sectionMap;
    void setSectionMap(Map<String, KeySection> sectionMap) {
        this.sectionMap = sectionMap;
    }
    @Override public Map<String, KeySection> getSectionMap() {
        return sectionMap;
    }
    
    private Map<String, KeyShape> shapeMap;
    void setShapeMap(Map<String, KeyShape> shapeMap) {
        this.shapeMap = shapeMap;
    }
    @Override public Map<String, KeyShape> getShapeMap() {
        return shapeMap;
    }
    
    private KeySection defaultSection;
    void setDeafultSection(KeySection defaultSection) {
        this.defaultSection = defaultSection;
    }
    @Override public KeySection getDefaultSection() {
        Set<String> keys = sectionMap.keySet();
        if (defaultSection == null) {
            defaultSection = sectionMap.get(DEFAULT_SECTION_NAME);
        }
        return defaultSection;
    }
    
    private Collection<KeySection> activeSections;
    void setActiveSections(Collection<KeySection> activeSections) {
        this.activeSections = activeSections;
    }

    @Override public Collection<KeySection> getActiveSections() {
        if (activeSections == null) {
            activeSections = sectionMap.values();
        }
        return activeSections;
    }
    
    private String defaultShapeName;
    void setDefaultShapeName(String defaultShapeName) {
        this.defaultShapeName = defaultShapeName;
    }
    @Override public String getDefaultShape() {
        return defaultShapeName;
    }
    
    private float sectionLeft;
    void setSectionLeft(float sectionLeft) {
        this.sectionLeft = sectionLeft;
    }

    @Override public float getSectionLeft() {
        return sectionLeft;
    }
    
    private float defaultGap;
    void setDefaultGap(float defaultGap) {
        this.defaultGap = defaultGap;
    }
    @Override public float getDefaultGap() {
        return defaultGap;
    }
    
    private float rowLeft;
    void setRowLeft(float rowLeft) {
        this.rowLeft = rowLeft;
    }
    @Override public float getRowLeft() {
        return rowLeft;
    }

    @Override public KeyShape getShape(String name) {
        return shapeMap.get(name);
    }
    
    private float scale;
    @Override public void setScale(float scale) {
        this.scale = scale;
    }
    @Override public float getScale() {
        if (scale == 0) {
            setScale(Main.getDefaultScaleFactor());
        }
        return scale;
    }
    
    @Override public int compareTo(Object g) {
        return toString().compareTo(g.toString());
    }
    
    @Override public String toString() {
        return description;
    }
    
    static final String DEFAULT_SECTION_NAME = "Alpha";
}
