/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom.xkb;

import com.sun.g11n.vkb.*;
import com.sun.g11n.vkb.geom.*;
import java.io.*;
import java.util.*;
import java.awt.geom.Point2D;
import static com.sun.g11n.vkb.geom.xkb.XKBGeometryCollection.*;
import static com.sun.g11n.vkb.Main.error;

/**
 *
 * @author naoyuki
 */
public class XKBParser {
    
    static String parseString(String line, BufferedReader br) throws IOException  {
        while (!line.endsWith(END_STATEMENT_TAG)) {
            String l2 = br.readLine();
            if (l2 == null) {
                error("format error : " + line);
            }
            line = line + " " + l2.trim();
        }
        int s = line.indexOf("\"");
        if (s != -1) {
            int e = line.lastIndexOf("\"");
            if (e != -1 && e > s) {
                return line.substring(s + 1, e);
            }
        }
        return "";
    }
    
    static float parseFloat(String line, BufferedReader br) throws IOException {
        while (!line.endsWith(END_STATEMENT_TAG)) {
            String l2 = br.readLine();
            if (l2 == null) {
                error(line + " : format is wrong.");
            }
            line = line + " " + l2.trim();
        }
        int s = line.indexOf("=");
        if (s != -1) {
            int e = line.lastIndexOf(";");
            if (e != -1 && e > s) {
                String numStr = line.substring(s + 1, e).trim();
                try {
                    return Float.valueOf(numStr);                    
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return 0;
    }    
    
    static boolean parseBoolean(String line, BufferedReader br) throws IOException {
        while (!line.endsWith(END_STATEMENT_TAG)) {
            String l2 = br.readLine();
            if (l2 == null) {
                error("format error : " + line);
            }
            line = line + " " + l2.trim();
        }
        if (line.indexOf("True") != -1) {
            return true;
        }
        return false;
    }
    
    static void parseShape(Map<String, KeyShape> map, String line, BufferedReader br) throws IOException {
        while (!line.endsWith(END_STATEMENT_TAG)) {
            String l2 = br.readLine();
            if (l2 == null) {
                error("shape section does not end correctly");
            }
            line = line + " " + l2.trim();
        }
        
        int s = line.indexOf("\"");
        if (s != -1) {
            int e = line.indexOf("\"", s + 1);
            if (e != -1) {
                String label = line.substring(s + 1, e);
                KeyShape keyShape = new KeyShape(label);
                keyShape.setTypeName(XKBGeometryCollection.curTypeName); // for debug
                int lb = line.indexOf("{");
                if (lb != -1) {
                    int rb = line.lastIndexOf("}");
                    if (rb != -1) {
                        line = line.substring(lb + 1, rb).trim();
                        while ((lb = line.indexOf("{")) != -1) {
                            List<Point2D.Float> plist = new ArrayList<Point2D.Float>();
                            rb = line.indexOf("}");
                            if (rb != -1) {
                                String outline = line.substring(lb + 1, rb);
                                int lsb, rsb;
                                while ((lsb = outline.indexOf("[")) != -1) {
                                    rsb = outline.indexOf("]");
                                    if (rsb != -1) {
                                        String pointsStr = outline.substring(lsb + 1, rsb).trim();
                                        int c = pointsStr.indexOf(",");
                                        if (c != -1) {
                                            String xs = pointsStr.substring(0, c);
                                            String ys = pointsStr.substring(c + 1);
                                            try {
                                                float x = Float.valueOf(xs.trim());
                                                float y = Float.valueOf(ys.trim());
                                                plist.add(new Point2D.Float(x, y));
                                                outline = outline.substring(rsb + 1);
                                            } catch (Exception ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            } else {
                                break;
                            }
                            line = line.substring(rb + 1);
                            keyShape.addOutline(plist);
                        }
                    }
                }
                map.put(label, keyShape);
            }
        }
    }
    
    static void parseOutline(String line, BufferedReader br) throws IOException {
        while (!line.endsWith(END_STATEMENT2_TAG)) {
            line = line + " " + br.readLine().trim();
        }
        // just ignore outline section for now
    }
    
    static String parseIncludeGeom(String line) {
        // include line must completed in one line
        int s = line.indexOf("\"");
        int e = line.indexOf("(");
        return line.substring(s + 1, e);
    }
    
    static String parseIncludeType(String line) {
        int s = line.indexOf("(");
        int e = line.indexOf(")");
        return line.substring(s + 1, e);
        

    }
    
    static void parseSection(Map<String, KeySection> sectionMap, String line, BufferedReader br) throws IOException {
        while (line.indexOf(START_STATEMENT_TAG) == -1) {
            String l2 = br.readLine();
            if (l2 == null) {
                error("section does not end correctrly.");
            }
            line = line + " " + l2.trim();
        }
        int s = line.indexOf("\"");
        int e = line.indexOf("\"", s + 1);
        if (s + 1 > e) {
            error("section has no valid name : " + line);
        }
        String key = line.substring(s + 1, e);
        KeySection value = parseSectionValue(key, line.substring(e + 1).trim(), br);
        sectionMap.put(key, value);
    }
    
    static KeySection parseSectionValue(String name, String line, BufferedReader br) throws IOException {
        if (!line.equals(START_STATEMENT_TAG)) {
            error("start of section is not 'section \"NAME\" {");
        }
        KeySection keySection = new KeySection(name);
        while ((line = br.readLine()) != null) {
            line = line.trim();
            if (line.startsWith(KEY_SHAPE_TAG)) {
                keySection.setShapeName(parseString(line, br));
            } else if (line.startsWith(KEY_GAP_TAG)) {
                keySection.setGap(parseFloat(line, br));
            } else if (line.startsWith(TOP_TAG)) {
                keySection.setTop(parseFloat(line, br));
            } else if (line.startsWith(LEFT_TAG)) {
                keySection.setLeft(parseFloat(line, br));
            } else if (line.startsWith(ROW_VERTICAL_TAG)) {
                keySection.setRowVertical(parseBoolean(line, br));
            } else if (line.startsWith(ROW_TAG)) {
                keySection.addRow(parseRow(line, br));
            } else if (line.startsWith(END_STATEMENT2_TAG)) {
                break;
            }
        }
        return keySection;
    }
    
    static KeyRow parseRow(String line, BufferedReader br) throws IOException {
        if (!line.endsWith(START_STATEMENT_TAG)) {
            error("row in section does not start with 'row {' : " + line);
        }
        KeyRow keyRow = new KeyRow();
        while ((line = br.readLine()) != null) {
            line = line.trim();
            if (line.startsWith(COMMENT_TAG)) {
                continue;
            }
            if (line.startsWith(TOP_TAG)) {
                keyRow.setTop(parseFloat(line, br));
            } else if (line.startsWith(LEFT_TAG)) {
                keyRow.setLeft(parseFloat(line, br));
            } else if (line.startsWith(GAP_TAG)) {
                keyRow.setGap(parseFloat(line, br));
            } else if (line.startsWith(KEYS_TAG)) {
                keyRow.setKeyInfoList(parseKeys(line, br));
            } else if (line.startsWith(KEY_SHAPE_TAG)) {
                keyRow.setShapeName(parseString(line, br));
            } else if (line.startsWith(KEY_COLOR_TAG)) {
                keyRow.setColor(parseString(line, br));
            } else if (line.startsWith(END_STATEMENT2_TAG)) {
                break;
            }
        }
        return keyRow;        
    }
   
    static List<KeyInfo> parseKeys(String line, BufferedReader br) throws IOException {
        while (!line.endsWith(END_STATEMENT2_TAG)) {
            String l2 = br.readLine();
            l2 = l2.trim();
            if (l2.startsWith(COMMENT_TAG)) {
                continue;
            }
            if (l2 == null) {
                error("keys section does not end correctly.");
            }
            line = line + " " + l2;
        }
        int s = line.indexOf(START_STATEMENT_TAG);
        if (s == -1) 
            error ("keys section format is not correct");
        int e = line.lastIndexOf(END_STATEMENT2_TAG);
        if (e <= s)
            error ("keys section format is not correct : " + line);
        
        List<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
        line = line.substring(s + 1, e).trim();
        line = line.replace(',', ' ');
        String token = null;
        for (;;) {
            line = line.trim();
            if (line.length() < 3) {
                break;
            }
            if (line.startsWith(START_STATEMENT_TAG)) {
                e = line.indexOf(END_STATEMENT3_TAG);
                if (e == -1) {
                    error("keys section format is wrong : " + line);
                }
                token = line.substring(1, e);
            } else if (line.startsWith(KEY_LABEL_START_TAG)) {
                e = line.indexOf(KEY_LABEL_END_TAG);
                if (e == -1) {
                    error("keys section format is werong : " + line);
                }
                token = line.substring(0, e + 1);
            }
            KeyInfo keyInfo = parseKeyInfo(token);
            //XKBKeySection.Key key = new XKBKeySection.Key(token);
            line = line.substring(e + 1);
            keyInfoList.add(keyInfo);
        }
        return keyInfoList;
    }
    
    static KeyInfo parseKeyInfo(String tokens) {
        KeyInfo keyInfo = new KeyInfo();
        // search label
        String label = null;
        int s = tokens.indexOf(KEY_LABEL_START_TAG);
        if (s == -1) {
            label = null;
        } else {
            int e = tokens.indexOf(KEY_LABEL_END_TAG);
            if (s >= e) {
                error("keys format is wrong : " + tokens);
            }
            // label does not include '<' and '>'
            label = tokens.substring(s + 1, e);
        }
        keyInfo.setLabel(label);
        // search gap
        StringTokenizer st = new StringTokenizer(tokens);
        float gap = 0;
        for (; st.hasMoreTokens();) {
            try {
                gap = Float.parseFloat(st.nextToken());                    
            } catch (NumberFormatException e) {
            // ignore
            }
        }
        keyInfo.setGap(gap);
        // search color
        String color = null;
        s = tokens.indexOf(COLOR_TAG);
        if (s != -1) {
            int s2 = tokens.indexOf("\"", s);
            if (s2 != -1) {
                int e = tokens.indexOf("\"", s2 + 1);
                if (e != -1) {
                    color = tokens.substring(s2 + 1, e);
                    // get rid of color part for easy parse for shape
                    tokens = tokens.substring(0, s) + " " + tokens.substring(e + 1);
                }
            }
        }
        keyInfo.setColor(color);
        // search shape
        String shapeName = null;
        s = tokens.indexOf("\"");
        if (s != -1) {
            int e = tokens.indexOf("\"", s + 1);
            if (e != -1) {
                shapeName = tokens.substring(s + 1, e);
            }
        }
        keyInfo.setShapeName(shapeName);
        
        return keyInfo;
    }
}
