/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * LayoutListEditor.java
 *
 * Created on 2008/09/09, 16:00
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.*;
import java.util.*;
import javax.swing.*;

import static com.sun.g11n.vkb.L10N.*;

/**
 *
 * @author  naoyuki
 */
public class LayoutListEditor extends javax.swing.JDialog {
    
    /** Creates new form LayoutListEditor */
    public LayoutListEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        init();
    }
    
    public LayoutListEditor(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        init();
    }
    
    private void init() {
        setTitle(_("vkb.layout_list_editor.title"));
        initModel();
        initComponents();
        deleteList = new ArrayList<Symbol>();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nonUseList = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        useList = new javax.swing.JList();
        rightButton = new javax.swing.JButton();
        rightAllButton = new javax.swing.JButton();
        leftButton = new javax.swing.JButton();
        leftAllButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        nonUseList.setModel(nonUseListModel);
        jScrollPane1.setViewportView(nonUseList);

        useList.setModel(useListModel);
        jScrollPane2.setViewportView(useList);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("com/sun/g11n/vkb/vkb-message"); // NOI18N
        rightButton.setText(bundle.getString("vkb.layout_list_editor.move_right")); // NOI18N
        rightButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveRight(evt);
            }
        });

        rightAllButton.setText(bundle.getString("vkb.layout_list_editor.move_all_right")); // NOI18N
        rightAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveAllRight(evt);
            }
        });

        leftButton.setText(bundle.getString("vkb.layout_list_editor.move_left")); // NOI18N
        leftButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveLeft(evt);
            }
        });

        leftAllButton.setText(bundle.getString("vkb.layout_list_editor.move_all_left")); // NOI18N
        leftAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveAllLeft(evt);
            }
        });

        deleteButton.setText(bundle.getString("vkb.layout_list_editor.delete")); // NOI18N
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteLayout(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        jLabel1.setText(bundle.getString("vkb.layout_list_editor.unused")); // NOI18N

        jLabel2.setFont(new java.awt.Font("Dialog", 1, 12));
        jLabel2.setText(bundle.getString("vkb.layout_list_editor.use")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(29, 29, 29)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(rightButton, javax.swing.GroupLayout.DEFAULT_SIZE, 65, Short.MAX_VALUE)
                            .addComponent(rightAllButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(deleteButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(leftButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(leftAllButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addComponent(jLabel1)))
                .addGap(22, 22, 22)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(49, 49, 49)
                        .addComponent(jLabel2)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(rightButton)
                        .addGap(27, 27, 27)
                        .addComponent(rightAllButton)
                        .addGap(31, 31, 31)
                        .addComponent(leftButton)
                        .addGap(28, 28, 28)
                        .addComponent(leftAllButton)
                        .addGap(29, 29, 29)
                        .addComponent(deleteButton)))
                .addContainerGap())
        );

        okButton.setText(bundle.getString("vkb.layout_list_editor.ok")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                process(evt);
            }
        });

        cancelButton.setText(bundle.getString("vkb.layout_list_editor.cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancel(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(107, 107, 107)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(57, 57, 57)
                        .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 76, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(okButton)
                    .addComponent(cancelButton))
                .addContainerGap(30, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private DefaultListModel useListModel = null;
    private DefaultListModel nonUseListModel = null;
    private void initModel() {
        if (useListModel == null) {
            useListModel = new DefaultListModel();
        } else {
            useListModel.clear();
        }
        if (nonUseListModel == null) {
            nonUseListModel = new DefaultListModel();
        } else {
            nonUseListModel.clear();
        }
        
        SymbolCollection symbols = Main.getSymbolCollection();
        Collection<Symbol> activeUserSyms = symbols.getActiveUserSymbolSet();
        for (Symbol symbol : activeUserSyms) {
            useListModel.addElement(symbol);
        }
        Collection<Symbol> userSyms = symbols.getUserSymbolSet();
        for (Symbol symbol : userSyms) {
            if (!activeUserSyms.contains(symbol)) {
                nonUseListModel.addElement(symbol);
            }
        }
    }
    private void moveRight(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveRight
        Object[] selects = nonUseList.getSelectedValues();
        if (selects != null) {
            for (Object obj : selects) {
                if (obj instanceof Symbol) {
                    DefaultListModel model = (DefaultListModel)nonUseList.getModel();
                    model.removeElement(obj);
                    model = (DefaultListModel)useList.getModel();
                    model.addElement(obj);
                }
            }
        }
    }//GEN-LAST:event_moveRight

    private void moveAllRight(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveAllRight
        DefaultListModel nonUseModel = (DefaultListModel)nonUseList.getModel();
        DefaultListModel useModel = (DefaultListModel)useList.getModel();
        Enumeration e = nonUseModel.elements();
        for (; e.hasMoreElements();) {
            Object o = e.nextElement();
            useModel.addElement(o);
        }
        nonUseModel.removeAllElements();
    }//GEN-LAST:event_moveAllRight

    private void moveLeft(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveLeft
        Object[] selects = useList.getSelectedValues();
        if (selects != null) {
            for (Object obj : selects) {
                if (obj instanceof Symbol) {
                    DefaultListModel model = (DefaultListModel)useList.getModel();
                    model.removeElement(obj);
                    model = (DefaultListModel)nonUseList.getModel();
                    model.addElement(obj);
                }
            }
        }
    }//GEN-LAST:event_moveLeft

    private void moveAllLeft(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveAllLeft
        DefaultListModel nonUseModel = (DefaultListModel)nonUseList.getModel();
        DefaultListModel useModel = (DefaultListModel)useList.getModel();
        Enumeration e = useModel.elements();
        for (; e.hasMoreElements();) {
            Object o = e.nextElement();
            nonUseModel.addElement(o);
        }
        useModel.removeAllElements();
    }//GEN-LAST:event_moveAllLeft

    private List<Symbol> deleteList;
    private void deleteLayout(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteLayout
        deleteSelected(nonUseList);
        deleteSelected(useList);
    }//GEN-LAST:event_deleteLayout
    private void deleteSelected(JList list) {
        Object[] objs = list.getSelectedValues();
        for (Object obj : objs) {
            DefaultListModel m = (DefaultListModel)list.getModel();
            m.removeElement(obj);
            deleteList.add((Symbol)obj);
        }
    }
    
    // OK button is pressed
    private void process(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_process
        // delete actual files
        for (Symbol sym : deleteList) {
            if (sym instanceof UserDefinedSymbol) {
                ((UserDefinedSymbol)sym).delete();
            }
        }
        deleteList.clear();
        // save non use list
        List<Symbol> l = new ArrayList<Symbol>();
        for (int i = 0, size = nonUseListModel.size(); i < size; i++) {
            Object obj = nonUseListModel.getElementAt(i);
            if (obj instanceof Symbol) {
                l.add((Symbol)obj);
            }
        }
        VKBManager.getInstance().saveNonUseUserLayoutList(l);
        setVisible(false);
    }//GEN-LAST:event_process

    // Cancel button is pressed
    private void cancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancel
        initModel();
        deleteList.clear();
        setVisible(false);
    }//GEN-LAST:event_cancel
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                LayoutListEditor dialog = new LayoutListEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton deleteButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton leftAllButton;
    private javax.swing.JButton leftButton;
    private javax.swing.JList nonUseList;
    private javax.swing.JButton okButton;
    private javax.swing.JButton rightAllButton;
    private javax.swing.JButton rightButton;
    private javax.swing.JList useList;
    // End of variables declaration//GEN-END:variables
    
}
