/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Key.java
 *
 * Created on 2007/11/30, 15:35
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.geom.KeyShape;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.*;
import java.util.*;


/**
 *
 * @author naoyuki
 */
public class KeyView {

    private KeyShape shape;
    private int fontSize;

    private static Map<Integer, Map<String, Font>> fontStock;
    private static final String HI_FONT = "HI_FONT";
    private static final String LOW_FONT = "LOW_FONT";
    private static final String HI_STRING_FONT = "HI_STRING_FONT";
    private static final String LOW_STRING_FONT = "LOW_STRING_FONT";
    static {
        fontStock = new HashMap<Integer, Map<String, Font>>();
    }
    
    private GeneralPath innerShape;
    private GeneralPath innerShapeShadow;
    private GeneralPath outerShape;
    private GeneralPath outerShapeShadow;
    private GradientPaint innerGradient;
    private GradientPaint outerGradient;
    private Color labelColorHigh;
    private Color labelColorLow;
    float x, y, w, h;
    
    private void updateGradient(float x, float y, float w, float h, boolean mod) {
        Point2D p1 = new Point2D.Float(x, y + h);
        Point2D p2 = new Point2D.Float(x + w, y);
        if (highlight) {
            if (mod) {
                innerGradient = new GradientPaint(p1, Color.LIGHT_GRAY.darker(),
                        p2, Color.DARK_GRAY.darker());
                outerGradient = new GradientPaint(p1, Color.WHITE.darker(),
                        p2, Color.LIGHT_GRAY.darker());
            } else {
                innerGradient = new GradientPaint(p1, Color.LIGHT_GRAY, p2, Color.DARK_GRAY);
                outerGradient = new GradientPaint(p1, Color.WHITE, p2, Color.LIGHT_GRAY);
            }
            labelColorHigh = Color.LIGHT_GRAY;
            labelColorLow= Color.DARK_GRAY;
        } else {
            if (mod) {
                innerGradient = new GradientPaint(p1, Color.LIGHT_GRAY.darker(), 
                        p2, Color.WHITE.darker());
                outerGradient = new GradientPaint(p1, Color.DARK_GRAY.darker(), 
                        p2, Color.LIGHT_GRAY.darker());               
            } else {
                innerGradient = new GradientPaint(p1, Color.LIGHT_GRAY, p2, Color.WHITE);
                outerGradient = new GradientPaint(p1, Color.DARK_GRAY, p2, Color.LIGHT_GRAY);
            }
            labelColorHigh = Color.DARK_GRAY;
            labelColorLow = Color.LIGHT_GRAY;
        }
    }

    private void resetShadow() {
        outerShapeShadow = (GeneralPath)outerShape.clone();        
        innerShapeShadow = (GeneralPath)innerShape.clone();        
    }
    public KeyView(float x, float y, KeyShape shape) {
        this.shape = shape;
        outerShape = shape.getOuterPath(x, y);
        innerShape = shape.getInnerPath(x, y);
        resetShadow();
        this.x = x;
        this.y = y;
        this.w = shape.getWidth();
        this.h = shape.getHeight();
        modified = false;
    }

    private KeyModel model;
    public void setModel(KeyModel model) {
        this.model = model;
        setupSurface();
    }
    
    private boolean modified;
    public void setModified(boolean modified) {
        this.modified = modified;
    }
    /*
     * If this function returns true, then the model this view has needs
     * to be saved as customized layout.
     */ 
    public boolean isModified() {
        return modified;
    }

    /*
     * used for setting appropriate surface to key top
     */
    public void setupSurface() {
        updateGradient(x, y, w, h, !model.isCharacter());
    }
    
    public KeyModel getModel() {
        return model;
    }
    
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public float getX() {
        return (float)outerShape.getBounds().getX();
    }
    public float getShadowX() {
        return (float)outerShapeShadow.getBounds().getX();
    }
    public float getY() {
        return (float)outerShape.getBounds().getY();
    }
    public float getShadowY() {
        return (float)outerShapeShadow.getBounds().getY();
    }
    public float getWidth() {
        return (float)outerShape.getBounds().getWidth();
    }
    public float getHeight() {
        return (float)outerShape.getBounds().getHeight();
    }
    
    public void dragShadow(float x, float y) {
        float tx = x - getShadowX();
        float ty = y - getShadowY();
        AffineTransform at = new AffineTransform();
        at.setToTranslation(tx, ty);
        outerShapeShadow.transform(at);
        innerShapeShadow.transform(at);
    }
    /*
     * make image for this KeyView (for DnD support)
     */
    public void fillDragImage(Image image) {
        Graphics drag_g = image.getGraphics();
        Graphics2D g2 = (Graphics2D)drag_g;
        g2.setStroke(new BasicStroke(3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
        g2.setPaint(outerGradient);
        g2.draw(outerShapeShadow);
        g2.setPaint((innerGradient));
        g2.draw(innerShapeShadow);
        drawLabels(g2, innerShapeShadow);
    }

    // Shape interface implementation
    public boolean contains(float x, float y) {
        return outerShape.contains(x, y);
    }
    public boolean contains(float x, float y, float w, float h) {
        return outerShape.contains(x, y, w, h);
    }
    public boolean contains(Point2D p) {
        return contains((float)p.getX(), (float)p.getY());
    }
    public boolean contains(Rectangle2D r) {
        return contains((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight());
    }
    public Rectangle getBounds() {
        return new Rectangle((int)getX(), (int)getY(), (int)getWidth(), (int)getHeight());
    }
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(getX(), getY(), getWidth(), getHeight());
    }
    private GeneralPath getGeneralPath() {
        GeneralPath gp = new GeneralPath(PathIterator.WIND_EVEN_ODD, 48);
        gp.append(innerShape.getPathIterator(null), false);
        gp.append(outerShape.getPathIterator(null), false);
        return gp;
    }
    public PathIterator getPathIterator(AffineTransform at) {
        return getGeneralPath().getPathIterator(at);
    }
    public PathIterator getPathIterator(AffineTransform at, float flatness) {
        return getGeneralPath().getPathIterator(at, flatness);
    }
    public boolean intersects(float x, float y, float w, float h) {
        return outerShape.intersects(x, y, w, h);
    }
    public boolean intersects(Rectangle2D r) {
        return outerShape.intersects(r);
    }
    
    public void draw(Graphics2D g2) {
        g2.setPaint(outerGradient);
        g2.fill(outerShape);
        g2.setPaint(innerGradient);
        g2.fill(innerShape);
        drawLabels(g2, innerShape);
        if (dragging) {
            g2.setStroke(new BasicStroke(3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));            
            g2.setPaint(outerGradient);
            g2.draw(outerShapeShadow);
            g2.setPaint((innerGradient));
            g2.draw(innerShapeShadow);
            drawLabels(g2, innerShapeShadow);
        }
    }
    
    private static void drawStr(Graphics2D g2, String str, float x, float y, Color c) {
        g2.setColor(Color.WHITE);
        g2.drawString(str, x, y);
        g2.setColor(c);
        g2.drawString(str, x + (float)0.7, y - (float)0.7);
    }
    
    private boolean dragging = false;
    public void setDrag(boolean drag) {
        dragging = drag;
        if (!dragging) {
            // reset shadow shapes
            resetShadow();
        }
    }
    
    private static boolean checkLevelWithModel(int level, KeyModel model) {
        int l = model.getLevel();
        if (level == l) {
            // This method is called only if level's label exist, so
            // if level and current level is euqal, then return true
            return true;
        }
        if (l == 3) {
            switch(level) {
                case 0:
                    if (model.getLabel(3) != null || model.getLabel(2) != null || model.getLabel(1) != null) {
                        return false;
                    }
                    return true;
                case 1:
                    if (model.getLabel(3) != null || model.getLabel(2) != null) {
                        return false;
                    }
                    return true;
                case 2:
                    if (model.getLabel(3) != null) {
                        return false;
                    }
                    return true;
            }
        } 
        if (l == 2 && level == 0) {
            if (model.getLabel(2) != null) {
                return false;
            }
            return true;
        }
        if (l == 1 && level == 0) {
            if (model.getLabel(1) != null) {
                return false;
            }
            return true;
        }
        return false;
    }
    
    private void drawLabels(Graphics2D g2, Shape baseShape) {
        if (model == null)
            return;
        
        Font highFont;
        Font lowFont;
        Font highStrFont;
        Font lowStrFont;
        Map<String, Font> map = fontStock.get(fontSize);
        if (map == null) {
            map = new HashMap<String, Font>();
            map.put(HI_FONT, new Font("SansSerif", Font.BOLD, fontSize));
            map.put(LOW_FONT, new Font("SansSerif", Font.PLAIN, (int)(fontSize * 0.8)));
            map.put(HI_STRING_FONT, new Font("SansSerif", Font.BOLD, (int)(fontSize * 0.65)));
            map.put(LOW_STRING_FONT, new Font("SansSerif", Font.BOLD, (int)(fontSize * 0.6)));
            fontStock.put(fontSize, map);
        }
        highFont = map.get(HI_FONT);
        lowFont = map.get(LOW_FONT);
        highStrFont = map.get(HI_STRING_FONT);
        lowStrFont = map.get(LOW_STRING_FONT);
        
        String g1l1 = model.getLabel(0);
        String g1l2 = model.getLabel(1);
        String g2l1 = model.getLabel(2);
        String g2l2 = model.getLabel(3);
        boolean charKey = model.isCharacter();

        Rectangle2D rect = baseShape.getBounds2D();
        float[] points = getPoints(rect);
        
        if (!charKey) {
            // modifeir, function or control character keys are drawn
            // level independently using g1l1 string
            g2.setFont(highStrFont);
            String[] lines = g1l1.split("\n");
            float x2 = points[0];
            float y2 = points[5];
            float h2 = highStrFont.getSize2D();
            for (String line : lines) {
                drawStr(g2, line, x2, y2, labelColorHigh);
                y2 += h2;
            }
        } else {
            String label;
            if (g1l1 != null) {
                label = normalizeLabel(g1l1);
                if (checkLevelWithModel(0, model)) {
                    g2.setFont(highFont);
                    drawStr(g2, label, points[0], points[3], labelColorHigh);
                } else {
                    g2.setFont(lowFont);
                    drawStr(g2, label, points[0], points[3], labelColorLow);
                }
            }
            if (g1l2 != null) {
                label = normalizeLabel(g1l2);
                if (checkLevelWithModel(1, model)) {
                    g2.setFont(highFont);
                    drawStr(g2, label, points[0], points[5], labelColorHigh);
                } else {
                    g2.setFont(lowFont);
                    drawStr(g2, label, points[0], points[4], labelColorLow);
                }
            }
            if (g2l1 != null) {
                label = normalizeLabel(g2l1);
                if (checkLevelWithModel(2, model)) {
                    g2.setFont(highFont);
                    drawStr(g2, label, points[2], points[3], labelColorHigh);
                } else {
                    g2.setFont(lowFont);
                    drawStr(g2, label, points[1], points[3], labelColorLow);
                }
            }
            if (g2l2 != null) {
                label = normalizeLabel(g2l2);
                if (checkLevelWithModel(3, model)) {
                    g2.setFont(highFont);
                    drawStr(g2, label, points[2], points[5], labelColorHigh);
                } else {
                    g2.setFont(lowFont);
                    drawStr(g2, label, points[1], points[4], labelColorLow);
                }
            }
        }
    }
    
    private String normalizeLabel(String label) {
        if (label != null && label.length() > 1) {
            label = label.substring(0, 1);
        }
        return label;
    }
    
    /*       |  p[0]         p[2]     p[1]
     *    ---+---------------------------------- 
     *       |
     *       |
     *   p[4]|  *(L1/lo)             *(L3/lo)
     *       |
     *   p[5]|  *(L1/hi)    *(L3/hi)
     *       |
     *       |
     *   p[3]|  *(L0/lo/hi) *(L2/hi) *(L2/lo)
     */
    private static float[] getPoints(Rectangle2D rect) {
        float x = (float)rect.getX();
        float y = (float)rect.getY();
        float w = (float)rect.getWidth();
        float h = (float)rect.getHeight();
        float[] points = new float[6];        

        points[0] = (float)(x + w * 0.1);
        points[1] = (float)(x + w * 0.6);
        points[2] = (float)(x + w * 0.4);
        points[3] = (float)(y + h * 0.9);
        points[4] = (float)(y + h * 0.4);
        points[5] = (float)(y + h * 0.6);
        
        return points;
    }
    
    private boolean highlight = false;
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }
    public boolean getHighlight() {
        return highlight;
    }

    public void pressed() {
        if (model == null) {
            return;
        }
        updateHighlight(true);
        model.pressed();
        if (model.hasIdentical()) {
            if (identicalView == null) {
                identicalView = model.getOtherView(this);
            }
            if (identicalView != null) {
                identicalView.updateHighlight(true);
                identicalView.setupSurface();
            }
        }
    }
    private KeyView identicalView = null;
    public void released() {
        if (model == null) {
            return;
        }
        updateHighlight(false);
        model.released();
        if (identicalView != null) {
            identicalView.updateHighlight(false);
        }
    }
    private void updateHighlight(boolean press) {
        if (press) {
            if (model.isModifier()) {
                setHighlight(!getHighlight());
            } else {
                setHighlight(true);
            }
        } else {
            if (!model.isModifier()) {
                setHighlight(false);
            }
        }
    }
    public void clicked() {
        if (model == null) {
            return;
        }        
        model.clicked();
    }
}
