/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * KeyEditor.java
 *
 * Created on 2008/09/01, 17:27
 */

package com.sun.g11n.vkb;

import javax.swing.JFrame;
/**
 *
 * @author  naoyuki
 */
public class KeyEditor extends javax.swing.JDialog {
    
    private String title;
    private KeyView view;
    private KeyModel model;
    
    private static KeyEditor keyEditor;
    public static KeyEditor getInstance() {
        if (keyEditor == null) {
            keyEditor = new KeyEditor(new JFrame(), false);
        }
        return keyEditor;
    }
    /** Creates new form KeyEditor */
    private KeyEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        title = getTitle();
    }
    public void setKeyView(KeyView view) {
        this.view = view;
        model = view.getModel();
        setTitle(title + "[" + model.getName() + "]");
        tf1.setText(model.getLabel(0));
        tf2.setText(model.getLabel(1));
        tf3.setText(model.getLabel(2));
        tf4.setText(model.getLabel(3));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        tf1 = new javax.swing.JTextField();
        tf3 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        tf2 = new javax.swing.JTextField();
        tf4 = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("com/sun/g11n/vkb/vkb-message"); // NOI18N
        setTitle(bundle.getString("vkb.key_editor.title")); // NOI18N

        jPanel2.setLayout(new java.awt.GridLayout(3, 3, 5, 5));
        jPanel2.add(jLabel2);

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText(bundle.getString("vkb.key_editor.no_altgr")); // NOI18N
        jLabel3.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jPanel2.add(jLabel3);

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText(bundle.getString("vkb.key_editor.altgr")); // NOI18N
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jPanel2.add(jLabel1);

        jLabel5.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText(bundle.getString("vkb.key_editor.no_shift")); // NOI18N
        jPanel2.add(jLabel5);
        jPanel2.add(tf1);
        jPanel2.add(tf3);

        jLabel4.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText(bundle.getString("vkb.key_editor.shift")); // NOI18N
        jPanel2.add(jLabel4);
        jPanel2.add(tf2);
        jPanel2.add(tf4);

        okButton.setText(bundle.getString("vkb.key_editor.ok")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                save(evt);
            }
        });

        cancelButton.setText(bundle.getString("vkb.key_editor.cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancel(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(134, 134, 134)
                .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(26, 26, 26)
                .addComponent(cancelButton)
                .addContainerGap(119, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(okButton)
                    .addComponent(cancelButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 357, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private static class S2CResult {
        private int consume; // multiples of 6
        private String converted;
        
        int getConsumeNum() {

            return consume;
        }
        String getConverted() {
            return converted;
        }
        S2CResult(int consume, String converted) {
            if ((consume % 6) != 0) {
                throw new IllegalArgumentException("incorrect S2CResult");
            }
            this.consume = consume;
            this.converted = converted;
        }
    }
    
    private static int four2one(String unistr, int offset) {
        int c4 = Character.digit(unistr.charAt(offset), 16);
        if (c4 == -1) {
            return -1;
        }
        int c3 = Character.digit(unistr.charAt(offset + 1), 16);
        if (c3 == -1) {
            return -1;
        }
        int c2 = Character.digit(unistr.charAt(offset + 2), 16);
        if (c2 == -1) {
            return -1;
        }
        int c1 = Character.digit(unistr.charAt(offset + 3), 16);
        if (c1 == -1) {
            return -1;
        }
        return (c4 << 12) + (c3 << 8) + (c2 << 4) + c1;
    }

    private static S2CResult str2char(String str, int offset) {
        String unistr = str.substring(offset); 
        if (!unistr.startsWith("\\u") || unistr.length() < 6) {
            return null;
        }
        int consume = 0;
        StringBuffer sb = new StringBuffer();
        int skip = 0;
        while (unistr.startsWith("\\u")) {
            int u = four2one(unistr, 2);
            if (u == -1) {
                break;
            }
            
            if (Character.isHighSurrogate((char)u)) {
                // must low surrogate follows
                if (unistr.length() < 12) {
                    // illegal surrogate - not append u
                    break;
                }
                int ul = four2one(unistr, 8);
                if (Character.isLowSurrogate((char)ul)) {
                    sb.append((char)u);
                    sb.append((char)ul);
                    skip = 12;
                }
            } else {
                sb.append((char)u);
                skip = 6;
            }
            consume += skip;
            unistr = unistr.substring(skip);
        }
        return new S2CResult(consume, sb.toString());
    }
    
    /*
     * convert '\' 'u' 'X' 'X' 'X' 'X' sequence in string to one character
     */
    private String handleUnicodeEscape(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0, len = str.length(); i < len; i++) {
            char c = str.charAt(i);
            if (c == '\\') {
                S2CResult r = str2char(str, i);
                if (r != null && r.getConsumeNum() > 0) {
                    sb.append(r.getConverted());
                    i += r.getConsumeNum();
                    continue;
                }
            }
            sb.append(c);
        }   
        return sb.toString();
    }
    
    private static boolean diffStr(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null || s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }
    
    private boolean setIfModified(int level, String label) {
        if (diffStr(label, model.getLabel(level))) {
            label = handleUnicodeEscape(label);
            model.setLabel(label, level);
            return true;
        }
        return false;
    }
    
    private void save(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_save
        boolean modified = false;
        if (setIfModified(0, tf1.getText())) {
            modified = true;
        }
        if (setIfModified(1, tf2.getText())) {
            modified = true;
        }
        if (setIfModified(2, tf3.getText())) {
            modified = true;
        }
        if (setIfModified(3, tf4.getText())) {
            modified = true;
        }
        if (modified) {
            view.setModified(true);
            VKBManager.getInstance().redrawTargetFrame();
        }
        setVisible(false);
}//GEN-LAST:event_save

    private void cancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancel
        setVisible(false);
    }//GEN-LAST:event_cancel
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                KeyEditor dialog = new KeyEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton okButton;
    private javax.swing.JTextField tf1;
    private javax.swing.JTextField tf2;
    private javax.swing.JTextField tf3;
    private javax.swing.JTextField tf4;
    // End of variables declaration//GEN-END:variables
    
}
