/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import com.sun.g11n.vkb.sym.*;
import com.sun.g11n.vkb.geom.*;

import static com.sun.g11n.vkb.L10N._;

/**
 * This class handles GUI Frame part of VKB
 * All of exported APIs are package private and called from VKBManager
 * 
 * @author naoyuki
 */
public class FrameStyleManager {

    static FrameStyleManager getInstance(VKBManager manager, Set<KeyboardFrame> kbdSet) {
        if (fsManager == null) {
            fsManager = new FrameStyleManager(manager, kbdSet);
        }
        return fsManager;
    }
    
    private static FrameStyleManager fsManager = null;
    private FrameStyleManager(VKBManager manager, Set<KeyboardFrame> kbdSet) {
        this.kbdSet = kbdSet;
        pos_x = 20;
        pos_y = 20;
        offset_x = 10;
        offset_y = 10;
        this.manager = manager;
        currentStyle = Prefs.getFrameStyle();
    }
    
    // initial position for new keyboard and offset for next one    
    private int pos_x;
    private int pos_y;
    private int offset_x;
    private int offset_y;
    
    private Set<KeyboardFrame> kbdSet;
    private VKBManager manager;
    
    private FrameStyle currentStyle;
    
    // This frame is used for internal or tab frame style
    private JFrame mainFrame;
    
    // helper methods for Internal Frame
    private JDesktopPane desktop;
    private void internalFrameBegin() {
        if (desktop != null) {
            return;
        }
        if (mainFrame == null) {
            mainFrame = new JFrame(_("vkb.frame_title"));
            mainFrame.setBounds(Prefs.getMainFrameRectangle());
            mainFrame.addWindowListener(new WindowAdapter() {
                @Override public void windowClosing(WindowEvent e) {
                    exitMainFrame();
                }
            });
        }
        mainFrame.setVisible(true);
        
        desktop = new JDesktopPane();
        desktop.setBackground(Color.GRAY);
        mainFrame.getContentPane().add(desktop, BorderLayout.CENTER);
        mainFrame.setVisible(true);
    }

    private void internalFrameEnd() {
        if (desktop != null) {
            pos_x = mainFrame.getX();
            pos_y = mainFrame.getY();
            mainFrame.getContentPane().remove(desktop);
            desktop = null;
            mainFrame.setVisible(false);
        }
    }      
    // helper methods for Tab Frame
    private void selectFocusedTab() {
        if (tabPane != null) {
            int id = tabPane.getSelectedIndex();
            if (id >= 0) {
                Component c = tabPane.getComponentAt(id);
                if (c instanceof KeyboardFrame) {
                    KeyboardFrame kf = (KeyboardFrame)c;
                    manager.setCurrentFrame(kf);
                    KeyboardFrameCommonData cdata = kf.getCommonData();
                    manager.setCurrentSymbol(cdata.getSymbol());
                    manager.setCurrentGeometry(cdata.getGeometry());
                }
            }
        }
    }
    private JTabbedPane tabPane;
    private void tabFrameBegin() {
        if (tabPane != null) {
            return;
        }
        if (mainFrame == null) {
            mainFrame = new JFrame(_("vkb.frame_title"));
            mainFrame.addWindowListener(new WindowAdapter() {
                @Override public void windowClosing(WindowEvent e) {
                    exitMainFrame();
                }
            });            
        }

        tabPane = new JTabbedPane();
        tabPane.addChangeListener(new ChangeListener() {
            @Override public void stateChanged(ChangeEvent e) {
                selectFocusedTab();
            }
        });

        mainFrame.getContentPane().setLayout(new BorderLayout());
        mainFrame.getContentPane().add(tabPane, BorderLayout.CENTER);
        mainFrame.setBounds(Prefs.getMainFrameRectangle());
        mainFrame.setVisible(true);
    }
    
    private void tabFrameEnd() {
        if (tabPane != null) {
            pos_x = mainFrame.getX();
            pos_y = mainFrame.getY();
            mainFrame.getContentPane().remove(tabPane);
            tabPane = null;
            mainFrame.setVisible(false);
        }
    }
    
    void setTabTitle(TabKeyboardFrame frame, int id, String title) {
        tabPane.setTabComponentAt(id, new TabComponent(frame, tabPane, title));
    }
    
    private static Color transColor = new Color(0, 0, 0, 0);
    public class TabComponent extends JPanel {
        private final TabKeyboardFrame tabFrame;
        private final JTabbedPane parentPane;

        public TabComponent(TabKeyboardFrame frame, JTabbedPane pane, String title) {
            this.setBackground(transColor);
            tabFrame = frame;
            parentPane = pane;
            JLabel label = new JLabel(title);
            add(label);
            JButton button = new JButton("", new javax.swing.plaf.metal.MetalIconFactory.PaletteCloseIcon());
            button.addActionListener(new ActionListener() {
                @Override public void actionPerformed(ActionEvent e) {
                    removeKeyboardFrame(tabFrame);
                    parentPane.remove(tabFrame);
                }
            });
            add(button);
        }
    }

    KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym, int x, int y) {
        return newKeyboardFrame(getFrameStyle(), geom, sym, x, y, -1, -1);
    }
    KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym, int x, int y, float scale_x, float scale_y) {
        return newKeyboardFrame(getFrameStyle(), geom, sym, x, y, scale_x, scale_y);
    }
    KeyboardFrame newKeyboardFrame(FrameStyle style, Geometry geom, Symbol sym) {
        return newKeyboardFrame(style, geom, sym, 0, 0, -1, -1);
    }
    // real implementation of newKeyboardFrame only called from VKBManager
    // so this is package private 
    KeyboardFrame newKeyboardFrame(FrameStyle style, Geometry geom, Symbol sym, int x, int y, float scale_x, float scale_y) {
        KeyboardFrame returnFrame = null;
        KeyboardFrameCommonData commonData = new KeyboardFrameCommonData(geom, sym);
        if (scale_x != -1 && scale_y != -1) {
            commonData.setScale(scale_x, scale_y);
        }
        switch (style) {
            case SINGLE_FRAME:
                // clear other keyboard and show only this one
                for (KeyboardFrame frame : kbdSet) {
                    frame.dismiss();
                }
                kbdSet.clear();
                // through to MULTIPLE_FRAME
            case MULTIPLE_FRAME:
                // invoke new top-level frame with new keyboard
                StandAloneKeyboardFrame frame = new StandAloneKeyboardFrame(commonData);
                frame.setLocation(x, y);                
                kbdSet.add(frame);
                frame.setVisible(true);
                returnFrame = frame;
                break;
            case TAB_FRAME:
                tabFrameBegin();
                TabKeyboardFrame tframe = new TabKeyboardFrame(commonData, tabPane);
                tabPane.add(tframe);
                tabPane.setTabComponentAt(tabPane.getTabCount() - 1,
                        new TabComponent(tframe, tabPane, commonData.getKBDTitle()));
                tabPane.setSelectedComponent(tframe);
                kbdSet.add(tframe);
                returnFrame = tframe;
                break;
            case INTERNAL_FRAME:
                internalFrameBegin();
                InternalKeyboardFrame iframe = new InternalKeyboardFrame(commonData);
                if (x != -1 && y != -1) {
                    iframe.reshape(x, y, commonData.getWidth(), commonData.getHeight());
                }                
                iframe.show();
                desktop.add(iframe, 0);
                try {
                    iframe.setSelected(true);
                } catch (java.beans.PropertyVetoException e2) {
                    e2.printStackTrace();
                }

                kbdSet.add(iframe);
                returnFrame = iframe;
        }
        
        //ControlPanel panel = ControlPanel.getInstance();
        //panel.enableClose(true);
        //panel.enableDesign(true);
        return returnFrame;
    }
    
    KeyboardFrame newKeyboardFrame() {
        return newKeyboardFrame(getFrameStyle());
    }
    
    KeyboardFrame newKeyboardFrame(int x, int y) {
        pos_x += x;
        pos_y += y;
        return newKeyboardFrame(getFrameStyle());
    }
    
    KeyboardFrame newKeyboardFrame(FrameStyle style) {
        Geometry geom = manager.getCurrentGeometry();
        Symbol sym = manager.getCurrentSymbol();
        return newKeyboardFrame(style, geom, sym);
    }
    
    KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym) {
        return newKeyboardFrame(getFrameStyle(), geom, sym);
    }

    private void exitIfLast() {
        ControlPanel panel = ControlPanel.getInstance();
        if (panel.isVisible()) {
            panel.enableClose(false);
            panel.enableDesign(false);
        } else {
            manager.exitVKB();
        }
    }

    void removeKeyboardFrame(KeyboardFrame frame) {
        boolean lastFrame = false;
        if (kbdSet.size() < 2) {
            lastFrame = true;
            Prefs.setKeyboardFrames(kbdSet);
        }
        kbdSet.remove(frame);
        frame.dismiss();
        if (lastFrame) {
            exitIfLast();
        }
    }
    
    void setFocused(KeyboardFrame frame) {
        switch(getFrameStyle()) {
            case SINGLE_FRAME:
            case MULTIPLE_FRAME:
                if (frame instanceof Window) {
                    ((Window)frame).setVisible(true);
                }
                break;
            case TAB_FRAME:
                if (tabPane != null && frame instanceof JPanel) {
                    tabPane.setSelectedComponent((JPanel)frame);
                }
                break;
            case INTERNAL_FRAME:
                if (frame instanceof JInternalFrame) {
                    try {
                        ((JInternalFrame)frame).setSelected(true);
                    } catch (java.beans.PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
        }
    }
    
    private void exitMainFrame() {
        if (!ControlPanel.getInstance().isVisible()) {
            manager.exitVKB();
        } else {
            switch (currentStyle) {
                case INTERNAL_FRAME:
                    internalFrameEnd();
                    break;
                case TAB_FRAME:
                    tabFrameEnd();
            }
            recordMainFrameRectangle();
        }
        for (KeyboardFrame frame : kbdSet) {
            frame.dismiss();
        }
        kbdSet.clear();
        exitIfLast();
    }
    
    void recordMainFrameRectangle() {
        if (mainFrame != null && mainFrame.isVisible()) {
            Prefs.setMainFrameRectangle(mainFrame.getX(), mainFrame.getY(),
                    mainFrame.getWidth(), mainFrame.getHeight());
        }
    }

    private Set<KeyboardFrameCommonData> clearKbdSetAndGetCommonDataSet() {
        Set<KeyboardFrameCommonData> dataSet = new HashSet<KeyboardFrameCommonData>();
        for (KeyboardFrame frame : kbdSet) {
            dataSet.add(frame.getCommonData());
        }
        for (KeyboardFrame frame : kbdSet) {
            frame.dismiss();
        }
        kbdSet.clear();
        
        return dataSet;
    }

    private void multipleToSingle() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        StandAloneKeyboardFrame frame = null;
        for (KeyboardFrameCommonData cdata : dataSet) {
            if (cdata.isTarget()) {
                frame = new StandAloneKeyboardFrame(cdata);
                frame.setLocation(pos_x, pos_y);
                frame.setVisible(true);
                kbdSet.add(frame);
            }
        }
        if (frame == null) {
            // in case not frame returns isTraget() true
            newKeyboardFrame(FrameStyle.SINGLE_FRAME);
        }
    }
    
    private void internalToMultiple() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        internalFrameEnd();
        for (KeyboardFrameCommonData cdata : dataSet) {
            StandAloneKeyboardFrame sframe = new StandAloneKeyboardFrame(cdata);
            sframe.setLocation(pos_x += offset_x, pos_y += offset_y);
            sframe.setVisible(true);
            kbdSet.add(sframe);    
        }
    }
    
    private void internalToSingle() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        internalFrameEnd();
        StandAloneKeyboardFrame frame = null;
        for (KeyboardFrameCommonData cdata : dataSet) {
            if (cdata.isTarget()) {
                frame = new StandAloneKeyboardFrame(cdata);
                frame.setLocation(pos_x, pos_y);
                frame.setVisible(true);
                kbdSet.add(frame);
            }
        }
        if (frame == null) {
            newKeyboardFrame(FrameStyle.SINGLE_FRAME);
        }
    }
    
    private void multipleToInternal() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        internalFrameBegin();
        int i_pos_x = 20;
        int i_pos_y = 20;
        int i_offset_x = 10;
        int i_offset_y = 10;
        mainFrame.setSize(Main.getInitialFrameWidth(), Main.getInitialFrameHeight());
        for (KeyboardFrameCommonData cdata : dataSet) {
            InternalKeyboardFrame iframe = new InternalKeyboardFrame(cdata);
            iframe.setLocation(i_pos_x += i_offset_x, i_pos_y += i_offset_y);
            iframe.show();
            desktop.add(iframe, 0);
            kbdSet.add(iframe);
            try {
                iframe.setSelected(true);
            } catch (java.beans.PropertyVetoException e2) {
                e2.printStackTrace();
            }
        }
    }
    
    private void multipleToTab() {
        Point p = manager.getCurrentFrame().getLocation();
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        tabFrameBegin();
        mainFrame.setBounds((int)p.getX(), (int)p.getY(), Main.getInitialFrameWidth(), Main.getInitialFrameHeight());
        for (KeyboardFrameCommonData cdata : dataSet) {
            TabKeyboardFrame tframe = new TabKeyboardFrame(cdata, tabPane);
            tabPane.add(tframe);
            tabPane.setTabComponentAt(tabPane.getTabCount() - 1, new TabComponent(tframe, tabPane, tframe.getKBDTitle()));
            tabPane.setSelectedComponent(tframe);
            tframe.setVisible(true);
            kbdSet.add(tframe);
        }
    }
    
    private void internalToTab() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        internalFrameEnd();
        tabFrameBegin();
        mainFrame.setSize(Main.getInitialFrameWidth(), Main.getInitialFrameHeight());
        for (KeyboardFrameCommonData cdata : dataSet) {
            TabKeyboardFrame tframe = new TabKeyboardFrame(cdata, tabPane);
            tabPane.add(tframe);
            tabPane.setTabComponentAt(tabPane.getTabCount() - 1, new TabComponent(tframe, tabPane, tframe.getKBDTitle()));
            tabPane.setSelectedComponent(tframe);
            tframe.setVisible(true);
            kbdSet.add(tframe);          
        }
    }    
    
    private void tabToMultiple() {
        int i_pos_x = 10;
        int i_pos_y = 10;
        int i_offset_x = 10;
        int i_offset_y = 10;
        
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        tabFrameEnd();
        for (KeyboardFrameCommonData cdata : dataSet) {
            StandAloneKeyboardFrame sframe = new StandAloneKeyboardFrame(cdata);
            sframe.setLocation(i_pos_x += i_offset_x, i_pos_y += i_offset_y);
            sframe.setVisible(true);
            kbdSet.add(sframe);    
        }
    }
    
    private void tabToSingle() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        tabFrameEnd();
        StandAloneKeyboardFrame frame = null;
        for (KeyboardFrameCommonData cdata : dataSet) {
            if (cdata.isTarget()) {
                frame = new StandAloneKeyboardFrame(cdata);
                frame.setLocation(pos_x, pos_y);
                frame.setVisible(true);
                kbdSet.add(frame);
            }
        }
        if (frame == null) {
            newKeyboardFrame(FrameStyle.SINGLE_FRAME);
        }
    }
    
    private void tabToInternal() {
        Set<KeyboardFrameCommonData> dataSet = clearKbdSetAndGetCommonDataSet();
        tabFrameEnd();
        internalFrameBegin();
        int i_pos_x = 20;
        int i_pos_y = 20;
        int i_offset_x = 10;
        int i_offset_y = 10;
        mainFrame.setSize(Main.getInitialFrameWidth(), Main.getInitialFrameHeight());
        for (KeyboardFrameCommonData cdata : dataSet) {
            InternalKeyboardFrame iframe = new InternalKeyboardFrame(cdata);
            iframe.setLocation(i_pos_x += i_offset_x, i_pos_y += i_offset_y);
            iframe.show();
            desktop.add(iframe, 0);
            kbdSet.add(iframe);
            try {
                iframe.setSelected(true);
            } catch (java.beans.PropertyVetoException e2) {
                e2.printStackTrace();
            }
        }        
    }
    
    /*
     * Change look of virtual keyboard frames
     */ 
    void setFrameStyle(FrameStyle newStyle) {
        switch (this.currentStyle) {
            case MULTIPLE_FRAME:
                switch(newStyle) {
                    case SINGLE_FRAME:
                        multipleToSingle();
                        break;
                    case TAB_FRAME:
                        multipleToTab();
                        break;
                    case INTERNAL_FRAME:
                        multipleToInternal();
                        break;
                }
                break;
            case SINGLE_FRAME:
                switch(newStyle) {
                    case MULTIPLE_FRAME:
                        // no action needed here
                        break;
                    case TAB_FRAME:
                        // multipleToTab can be used as singleToTab
                        multipleToTab();
                        break;
                    case INTERNAL_FRAME:
                        // multipleToInternal can be used as singleToInternal
                        multipleToInternal();
                        break;
                }
                break;
            case TAB_FRAME:
                switch(newStyle) {
                    case MULTIPLE_FRAME:
                        tabToMultiple();
                        break;
                    case SINGLE_FRAME:
                        tabToSingle();
                        break;
                    case INTERNAL_FRAME:
                        tabToInternal();
                        break;
                }
                break;
            case INTERNAL_FRAME:
                switch(newStyle) {
                    case MULTIPLE_FRAME:
                        internalToMultiple();
                        break;
                    case SINGLE_FRAME:
                        internalToSingle();
                        break;
                    case TAB_FRAME:
                        internalToTab();
                        break;
                }
                break;
        }
        this.currentStyle = newStyle;
        ControlPanel.getInstance().setFrameStyle(newStyle);
        Prefs.setFrameStyle(newStyle);
    }
    
    FrameStyle getFrameStyle() {
        return currentStyle;
    }
    
}
